var DeployProjectMiniModule = Class.create(
{
	initialize: function()
	{
		this.domContainer		= 'deployProjectMiniCage';
		this.projectDropLoaded	= false;	
		this.siteTemplate		= '';
		this.monitorTemplate	= '';
		this.introVisible		= false;
		this.sitesVisible		= false;
	},
	
	finishInit: function()
	{
		new Ajax.Request('portlets/cloud/templates/deploy_project_mini/cloud_site_template.html', 
        {
            onComplete: function(response)
            {
				this.siteTemplate = response.responseText;

		        Portal.Data.cloudProjects.observe('undeployedListChanged', function()
		        {
					this.parseProjectsDrop();
					
		        }.bind(this));
				
		        Portal.Data.cloudProjects.observe('deployedListChanged', function()
		        {
					this.parseSiteList();
		        }.bind(this));
				
		        Portal.Data.cloudProjects.observe('projectListUpdated', function()
		        {
					this.parseProjectsDrop();
					this.parseSiteList();
		        }.bind(this));
				
				if(Portal.Data.cloudProjects.loading)
				{
		            Portal.Data.cloudProjects.observeOnce('projectListChanged', function()
		            {
						this.parseProjectsDrop();
						this.parseSiteList();
						
		            }.bind(this));	
				}
				else
				{
					this.parseProjectsDrop();
					this.parseSiteList();
				}
            }.bind(this)
        });
		
        new Ajax.Request('portlets/cloud/templates/deploy_project_mini/cloud_monitor_template.html', 
        {
            onComplete: function(response)
            {
				this.monitorTemplate = response.responseText;
            }.bind(this)
        });
		
	},
	
	parseWelcome: function parseWelcome()
	{
		if(!$('cloudIntroCage') || !$('deployProjectMiniCage'))
		{
			return;
		}
		
		if(Portal.Data.cloudProjects.totalDeployed == 0 || Portal.Modules.AptanaIdManager.isLoggedIn == false)
		{
			$('cloudIntroCage').show();
			$('deployProjectMiniCage').hide();
		}
		else if (Portal.Data.cloudProjects.totalDeployed > 0)
		{
			$('cloudIntroCage').hide();
			$('deployProjectMiniCage').show();
		}
		else
		{
			$('cloudIntroCage').show();
			$('deployProjectMiniCage').hide();
		}
	},
	
	parseProjectsDrop: function()
	{
		var newContent = '';
		
		if (Portal.Data.cloudProjects.totalProjects == 0) 
		{
			newContent = 'You haven\'t created any projects!  <a href="javascript: Portal.Modules.DeployProjectMini.newProject();">Create one now</a>, and then deploy it to the cloud!';
		}
		else if (Portal.Data.cloudProjects.totalUndeployed == 0)
		{
			newContent = 'All of your projects are currently deployed.  <a href="javascript: Portal.Modules.DeployProjectMini.newProject();">Create a new project</a> to deploy to the cloud!';
		}
		else
		{
			var deployButton = '<a href="javascript: Portal.Modules.DeployProjectMini.doDeploy();"><img src="images_global/button_deploy.png" class="inline link" align="absmiddle" /></a>';
			var content = new Template('<label class="bold" for="projectDrop">Choose Project:</label> #{projectDrop} #{deployButton}');
			var projectDrop = new Template('<select name="projectDrop" class="text" id="projectDrop" style="width: 130px;">#{items}</select>');
			var projectItem = new Template('<option value="#{project}">#{project}</option>');
			var items = '';
			
            Portal.Data.cloudProjects.undeployedProjects.each(function(item)
            {
				items +=  projectItem.evaluate({ project: item.value.name });
            });
			
            newContent = content.evaluate(
            {
				projectDrop: projectDrop.evaluate({items: items}),
				deployButton: deployButton
			});
		}
		
		if(!this.projectDropLoaded && $('projectDropCage'))
		{
            new Effect.Appear('projectDropCage', 
            {
                duration: 0.25,
                beforeStart: function()
                {
					$('projectDropCage').hide();
					$('projectDropCage').update(newContent);
                }
            })
					
			this.projectDropLoaded = true;
			this.parseWelcome();
			return;
		}
		else if ($('projectDropCage'))
		{
			$('projectDropCage').update(newContent);
		}
		
		else if(!this.projectDropLoaded && $('site_projectDropCage'))
		{
            new Effect.Appear('site_projectDropCage', 
            {
                duration: 0.25,
                beforeStart: function()
                {
					$('site_projectDropCage').hide();
					$('site_projectDropCage').update(newContent);
                }
            })
					
			this.projectDropLoaded = true;
			return;
		}
		else if ($('site_projectDropCage'))
		{
			$('site_projectDropCage').update(newContent);
			return;
		}
		
		this.parseWelcome();
	},
	
	parseSiteList: function parseSiteList()
	{
		if(Portal.Data.cloudProjects.totalDeployed == 0)
		{
			return;
		}
		
		if($('deployProjectMiniCage') && $('deployProjectMiniCage').style.display == 'none')
		{
			$('deployProjectMiniCage').show();
		}
		
        $A($$('div.siteInfoCage')).each(function(item)
        {
			var siteId = item.id.gsub('site_info_', '');
			
			if(!Portal.Data.siteList.sites.get(siteId))
			{
                new Effect.BlindUp('site_info_' + siteId, 
                {
                    duration: 0.25,
                    afterFinish: function()
                    {
						if ($('site_info_' + siteId)) 
						{
							$('site_info_' + siteId).remove();
						}
                    }
                });	
			}
        });
		
		var newHtml = '';
		var lastSiteId = '';
		
        Portal.Data.siteList.sites.each(function(site)
        {
			var currentSite = site.value;
			
			if(!currentSite || currentSite.project == null)
			{
				return;
			}
			
			var syncButton = '<a href="javascript: Portal.Modules.DeployProjectMini.doSync(\'' + currentSite.id + '\');"><img src="images_global/button_synchronize.png" /></a>';
			
			if(['Running', 'Warning'].indexOf(currentSite.status) == -1)
			{
				if(['Deleted', 'Deleting'].indexOf(currentSite.status) != -1)
				{
					return;
				}
				
				var statusString = (currentSite.status.indexOf('ing') == -1 && currentSite.status.indexOf('ed') == -1) ? ' is in ' + currentSite.status.toLowerCase() + ' state' : ' is ' + currentSite.status;
				
				syncButton = 'Site' + statusString;
			}
			
			var values = 
			{
				id: currentSite.id,
				domain: currentSite.domain,
				domainTruncated: currentSite.domain.truncate(30),
				projectNameTruncated: (currentSite.project == null) ? 'No local project associated' : currentSite.project.truncate(30),
				display: (!$('site_info_' + currentSite.id)) ? 'none' : '',
				status: currentSite.status,
				sync: (currentSite.lastSyncTime == null) ? 'Never': currentSite.lastSyncTime,
				dump: (currentSite.lastDump == null) ? 'Never': currentSite.lastDump,
				browseLocal: (currentSite.project == null) ? '' : '<a href="javascript: Portal.Modules.DeployProjectMini.showProject(\'' + currentSite.project + '\');">Browse Local</a> |',
				browseRemote: '<a href="javascript: Portal.Modules.DeployProjectMini.showRemote(\'' + currentSite.id + '\');">Browse Remote</a> |',
				syncButton: syncButton
			}
			
			var template = new Template(this.siteTemplate);
			
			newHtml = template.evaluate(values);
			
			if($('site_monitor_' + currentSite.id))
			{
				var monitorTemplate = new Template(this.monitorTemplate);
				var monitorContent = monitorTemplate.evaluate(values);
				$('site_monitor_' + currentSite.id).replace(monitorContent);
			}
			
			
			if($('deployProjectMiniCage') && !$('site_info_' + currentSite.id))
			{
				if(lastSiteId == '')
				{
					$('deployProjectMiniCage').insert({top: newHtml});
				}
				else
				{
					$('site_info_' + lastSiteId).insert({ after: newHtml });
				}
				
				new Effect.Appear('site_info_' + currentSite.id, 
				{
					duration: 0.25
				});
			}
			else if($('deployProjectMiniCage') && $('site_info_' + currentSite.id))
			{
				if($('secondary_' + currentSite.id).style.display != 'none')
				{
					newHtml = newHtml.gsub('display: none', 'display: ');
					newHtml = newHtml.gsub('expand', 'collapse');
				}
				
				$('site_info_' + currentSite.id).replace(newHtml);
			}
			
			lastSiteId = currentSite.id;
        }.bind(this));
		
		this.parseWelcome();
	},
	
	monitorSite: function monitorSite(siteId)
	{
        var window_factory = function(container, title, options)
        {
			var window_header = new Element('div', { className: 'window_header' });
			var window_title = new Element('div', { className: 'window_title' });
			var window_close = new Element('div', { className: 'window_close' });
			var window_contents = new Element('div', { className: 'window_contents' });
			
			window_title.update('Site Monitor: ' + title);

            var w = new Control.Window(container, Object.extend(
            {
				className: 'window',
				closeOnClick: window_close,
				draggable: window_header,
				insertRemoteContentAt: window_contents,
				width: 365
			}, options || {}));
			
			w.container.insert({
				top: window_header
			});
			window_header.insert(window_title);
			window_header.insert(window_close);
			w.container.insert({
				bottom: window_contents
			});
			
			w.open();
        }
		
		var currentSite = Portal.Data.siteList.sites.get(siteId);
			
		if(!currentSite)
		{
			return;
		}
		
		var syncButton = '<a href="javascript: Portal.Modules.DeployProjectMini.doSync(\'' + currentSite.id + '\');"><img src="images_global/button_synchronize.png" /></a>';
		
		if(['Running', 'Warning'].indexOf(currentSite.status) == -1)
		{
			var statusString = (currentSite.status.indexOf('ing') == -1) ? ' is in ' + currentSite.status : ' is ' + currentSite.status;
			
			syncButton = 'Site' + statusString;
		}
		
		var values = 
		{
			id: currentSite.id,
			domain: currentSite.domain,
			domainTruncated: currentSite.domain.truncate(30),
			projectNameTruncated: (currentSite.project == null) ? 'No local project associated' : currentSite.project.truncate(30),
			status: currentSite.status,
			sync: (currentSite.lastSyncTime == null) ? 'Never': currentSite.lastSyncTime,
			dump: (currentSite.lastDump == null) ? 'Never': currentSite.lastDump,
			browseLocal: (currentSite.project == null) ? '' : '<a href="javascript: Portal.Modules.DeployProjectMini.showProject(\'' + currentSite.project + '\');">Browse Local</a> |',
			browseRemote: '<a href="javascript: Portal.Modules.DeployProjectMini.showRemote(\'' + currentSite.id + '\');">Browse Remote</a> |',
			syncButton: syncButton
		}
		
		var template = new Template(this.monitorTemplate);
		
		newHtml = template.evaluate(values);
		
		window_factory(newHtml, currentSite.name);
	},
	
	toggleDetails: function toggleDetails(elementId)
	{
		if($('secondary_' + elementId).style.display == 'none')
		{
			new Effect.BlindDown('secondary_' + elementId, { duration: 0.25, queue: 'end' });
			$('toggle_secondary_' + elementId).removeClassName('expand');
			$('toggle_secondary_' + elementId).addClassName('collapse');
		}
		else
		{
			new Effect.BlindUp('secondary_' + elementId, { duration: 0.25, queue: 'end' });
			$('toggle_secondary_' + elementId).addClassName('expand');
			$('toggle_secondary_' + elementId).removeClassName('collapse');
		}
	},
	
	doDeploy: function doDeploy()
	{
		this.showWizard($F('projectDrop'));
	},
	
	showWizard: function(project)
	{
		var projectType = Portal.Data.cloudProjects.undeployedProjects.get(project).type;
		
		if(Portal.Data.cloudProjects.notCloudCompatible.indexOf(projectType) != -1)
		{
			Portal.API.dialogs.alert('Sorry, but the cloud does not currently support ' + projectType.capitalize() + ' projects.', ' Cannot deploy ' + projectType.capitalize() + ' projects.');
			return;
		}
		
		// show the wizard
		Portal.Modules.DeploymentWizard.showWizard( { data : { projectName: project }} );
	},
	
	doSync: function(siteId)
	{
		EventManager.publish.defer('/portal/cloud/sync', 
		{
			request: 'syncSite',
			id: siteId
		});
	},
	
	showRemote: function showRemote(siteId)
	{
		EventManager.publish('/portal/cloud/site/browse', { request: 'showFile', id: siteId });
	},
	
	showProject: function showProject(project)
	{
		EventManager.publish('/portal/projects/show', { project: project });
	},
	
	newProject: function()
    {
        EventManager.publish('/portal/wizard', 
        {
            id: 'com.aptana.ide.wizards.WebProjectWizard',
            request: 'new'
        });
    },
	
	showSiteInCloud: function showSiteInCloud(siteId)
	{
		Portal.Vars.siteToLoad = siteId;
		Portal.API.tabs.loadTabManually('tab_my_cloud');
	}
});
