
/*
 -------------------------------------------------
|          DEPLOYMENT WIZARD CONTROLLERS          |
 -------------------------------------------------
*/
var DeploymentWizardControllers = 
{
    /**
     * This function gets the deployment rolling by doing a bunch of pre-validation, and then
     * continuing on with the display init stuff if everything's OK
     *
     * This function shouldn't really be called directly, as it will be triggered by a call to this.showWizard(),
     * which is a message handler function for deploy requests...
     *
     */
    _init: function _init()
    {
        // deal with the wizard being invoked while on the cloud tab...
        if ($('site_settings') && Portal.API.tabs.currentTab == 'tab_my_cloud') 
        {
            // switch the current tab of the current site over to the "overview" tab... this
            // prevents clashes with other pages that may be showing
            if (typeof(Portal.Modules.MyCloudPortal.siteTabs) != 'undefined') 
            {
                Portal.Modules.MyCloudPortal.siteTabs.setActiveTab('site_overview');
				
				if($('site_settings'))
				{
					$('site_settings').innerHTML = '';
				}
            }
        }
        
        // remove the configurator if it exists elsewhere in the DOM
        if ($('configuratorCage')) 
        {
            $('configuratorCage').remove();
        }
        
        // failed deployments that run in the background don't reset everything...
        if (this.deploymentInProgress && !$('wizardCage')) 
        {
            if (!this.newSiteData.siteId) 
            {
                this.deploymentInProgress = false;
            }
            else 
            {
                var status = Portal.Data.siteList.sites.get(this.newSiteData.siteId);
                if (['Running', 'Warning', 'Error', 'Deleting', 'Deleted'].indexOf(status) != -1) 
                {
                    this.deploymentInProgress = false;
                }
            }
        }
        
        /**
         * @todo: check for offline mode to prevent attempted deployments
         */
        // don't bork a current deployment
        if (this.deploymentInProgress || (this.wizardDialog && this.wizardDialog.isOpen)) 
        {
            return;
        }
        
        // watch for billing account model on logins during deployment
        Portal.Data.currentUser.observe('billingAccountsLoaded', function()
        {
            if (this.currentStep == 5) 
            {
                this.renderStep5();
            }
        }.bind(this));
        
        if (Portal.Modules.AptanaIdManager.isLoggedIn) 
        {
            this.usernameAction = 'existing';
            this.newSiteData.username = Portal.Modules.AptanaIdManager.username;
        }
        
        // make sure the project is compatible
        this.newSiteData.projectType = (Portal.Data.cloudProjects.undeployedProjects.get(this.newSiteData.projectName)) ? Portal.Data.cloudProjects.undeployedProjects.get(this.newSiteData.projectName).type : 'unknown';
        
        // make sure the site 
        if (Portal.Data.cloudProjects.notCloudCompatible.indexOf(this.newSiteData.projectType) != -1) 
        {
            Portal.API.dialogs.alert('Sorry, Aptana Cloud does not currently support deploying ' + this.newSiteData.projectType.capitalize() + ' projects.', this.newSiteData.projectType.capitalize() + ' projects not supported.');
			
			if ($('deploy_project_button')) 
            {
                $('deploy_project_button').show();
                if($('loading_wizard_cage'))
				{
					$('loading_wizard_cage').hide();
				}
            }
			
			if(typeof(Portal.Modules.CloudWelcomeMat) != 'undefined')
			{
				Portal.Modules.CloudWelcomeMat.loadingWizard = false;
			}
			
            return;
        }
        
        // make sure we're online...
        if (!Portal.Modules.OnlineStatus.isOnline) 
        {
            Portal.API.dialogs.alert('You cannot deploy a site while offline.  Please try again when you have internet connectivity', 'Offline Mode');
            
			if ($('deploy_project_button')) 
            {
                $('deploy_project_button').show();
                if($('loading_wizard_cage'))
				{
					$('loading_wizard_cage').hide();
				}
            }
			
			if(typeof(Portal.Modules.CloudWelcomeMat) != 'undefined')
			{
				Portal.Modules.CloudWelcomeMat.loadingWizard = false;
			}
			
            return;
        }
		
		// make sure the product catalog is loaded
		if (Portal.Data.cloudProducts.error)
		{
			Portal.API.dialogs.alert('Sorry, cloud deployments are currently unavailable.  Please try again in a few minutes.  If this problem persists, please <a href="javascript: Portal.API.utils.openUrl(\'http://support.aptana.com\');">contact us</a> for support.');
			Portal.Data.cloudProducts.fetchProducts();
			
			if ($('deploy_project_button')) 
            {
                $('deploy_project_button').show();
                if($('loading_wizard_cage'))
				{
					$('loading_wizard_cage').hide();
				}
            }
			
			if(typeof(Portal.Modules.CloudWelcomeMat) != 'undefined')
			{
				Portal.Modules.CloudWelcomeMat.loadingWizard = false;
			}
			
			return;
		}
        
        Control.Window.windows.each(function(w)
        {
            if (w instanceof Control.Modal) 
            {
                w.destroy();
            }
            
        });
        
        // the suggested site name
        this.newSiteData.siteName = this.newSiteData.projectName.toLowerCase().gsub('[^a-zA-Z0-9\-]', '');
        
        this._initViews();
    },
    
    /**
     * This function actually triggers the start of a deployment
     *
     * It sets the current project to deploy, then triggers the _init function to get everything rolling.
     *
     * There's a bounce-around of functions that get executed in the start-up of this, so here's a quick reference:
     *  - this.showWizard()
     *  - this._init()
     *  - this._initViews()
     *  - this.showWizardDialog()
     *  - this.initWizard()
     *
     * @param {Object} msg
     */
    showWizard: function showWizard(msg)
    {
		if(!msg)
		{
			return;
		}
		
		// THIS NOW REDIRECTS TO AN EXTERNAL LOCATION
		var project = msg.data.projectName
		var params = '';
		
		// The special out of band value of "/" to indicate no project.
		if (project == '/') {
			project = ''; 
			var projectType = 'unknown';
			params += 'project_type=' + encodeURIComponent(projectType);
		} else {
			try
			{
				var projectType = Portal.Data.cloudProjects.undeployedProjects.get(project).type;
			}
			catch (e)
			{
				var projectType = 'unknown';
			}
			params += 'project_name=' + encodeURIComponent(project) + '&project_type=' + encodeURIComponent(projectType);
		}
		params += '&studio_id=' + encodeURIComponent(Portal.Vars.studioId) + '&mac_address=' + encodeURIComponent(Portal.Vars.macAddress);		
		params += '&command_image_url=' + encodeURIComponent('http://127.0.0.1:' + Portal.Vars.jettyPort + '/command.gif');
		
		if(Portal.Modules.AptanaIdManager.isLoggedIn)
		{
			params += '&username=' + encodeURIComponent(Portal.Modules.AptanaIdManager.username) + '&password=' + encodeURIComponent(Portal.Data.currentUser.password);
		}
		
		var modalContent = '<div class="clean-yellow"><div class="bold line16 center top5"><img src="images_global/img_activity_deploy.gif" class="inline" align="absmiddle" /> ';
		modalContent += 'Loading...</div></div>';
		
		// set up the "working" dialog object, including the message to send once its opened
        var modalJobDialog = new Control.Modal(modalContent, 
        {
            closeOnClick: 	false,
			className:		'modal',
			width:			200,
			overlayOpacity:	0.75,
			fade:			false,
			height:			null,
			iframeshim:		false,
			afterOpen: function()
			{
				switch(Portal.Vars.siteManagerUrl)
				{
					case 'https://acotak-staging.aptana.com/cloud/':
						doRedirect(Portal.Vars.stagingDeployLocation + '?' + params);
						break;
					default:
						doRedirect(Portal.Vars.deployLocation + '?' + params);
				}
			}
        });
		
		modalJobDialog.open();
		
		return;
		
		// ---- nothing else matters ;) ----- //
		
        // reset everything
        this.initVars();
        
		this.deploymentStarted = true;
		
        // get everything going...
        this.newSiteData.projectName = msg.data.projectName;
        
        if (Portal.Modules.AptanaIdManager.isLoggedIn == true) 
        {
            Portal.API.utils.getPref('portal.cloud.deployment.' + Portal.Modules.AptanaIdManager.username + '.rememberme');
            Portal.API.utils.getPref('portal.cloud.deployment.' + Portal.Modules.AptanaIdManager.username + '.rememberme.password');
        }
		
		if(Portal.Modules.AptanaIdManager.isLoggedIn && (Portal.Modules.CloudTrialStatus.endTime != 0))
		{
			Portal.Modules.CloudTrialStatus.fetchTrialUpdate();
		}
		else
		{
			this._init();
		}
    },
    
    /**
     * Last step in the wizard init process, this function finishes all the window building
     * and attaches some more event listeners (back / continue buttons, etc.).  It also resizes the
     * dialog to fit in the viewport vertically.
     *
     * Once everything's done, we'll load the first step.
     */
    initWizard: function initWizard()
    {
		if(!Portal.Modules.CloudTrialStatus.canDeploy)
		{
			this.isTrial = false;
		}
		
        // build the breadcrumbs... duh! :)
        this.buildBreadCrumbs();
        
        // used elsewhere in the wizard
        var wizardContainerId = this.wizardDialog.container.id;
        
        // some more display setup...
        $(wizardContainerId).setStyle(
        {
            background: '#e4e4e4'
        });
        
        // fit this thing vertically in the viewport
        var contentHeight = $(wizardContainerId).getHeight();
        contentHeight -= $('wizardBreadCrumbs').getHeight();
        contentHeight -= $('wizardActions').getHeight();
        
        $('wizardContent').setStyle(
        {
            height: contentHeight + 'px'
        });
        
        // a little content update
        $('projectName').update('<strong>Deploying project "' + this.newSiteData.projectName + '"</strong>');
        
        // and observer setup
        this.boundProcessCurrentStep = this.processCurrentStep.bindAsEventListener(this);
        this.boundDoPreviousStep = this.doPreviousStep.bindAsEventListener(this);
        
        Event.observe('wizardContinue', 'click', this.boundProcessCurrentStep);
        Event.observe('wizardBack', 'click', this.boundDoPreviousStep);
        
        this.loadWizardStepContent();
    },
    
    /**
     * Cancels the deployment and cleans up all the listeners, then closes the dialog
     *
     * @param {Boolean} loggedOut
     */
    cancelDeployment: function cancelDeployment(loggedOut)
    {
        this.wizardDialog.close();
        this.wizardDialog.destroy();
		this.deploymentStarted = false;
        
        Portal.Modules.DeploymentWizard.hotKeyReturn.destroy();
        
        $A($$('a.bread_crumb')).each(function(item)
        {
            Event.stopObserving(item, 'click', this.boundCrumbClick);
        }.bind(this));
        
        Event.stopObserving('wizardContinue', 'click', this.boundProcessCurrentStep);
        Event.stopObserving('wizardBack', 'click', this.boundDoPreviousStep);
        
        if (loggedOut && this.deploymentInProgress) 
        {
            var showAlert = function()
            {
                Portal.API.dialogs.alert('Your deployment is still in progress.  The next time you log in, you will be able to view the status of your site, and manage it if deployment is complete.', 'Deployment still in progress...');
                Portal.Modules.deploymentInProgress = false;
            }
            
            setTimeout(showAlert, 250);
        }
		
		if(!this.deploymentInProgress)
		{
			this.sendTrackingData('c.dw.cncl');
		}
    },
	
	finishDeployment: function finishDeployment()
	{
		this.wizardDialog.close();
        this.wizardDialog.destroy();
        
        Portal.Modules.DeploymentWizard.hotKeyReturn.destroy();
        
        $A($$('a.bread_crumb')).each(function(item)
        {
            Event.stopObserving(item, 'click', this.boundCrumbClick);
        }.bind(this));
        
        Event.stopObserving('wizardContinue', 'click', this.boundProcessCurrentStep);
        Event.stopObserving('wizardBack', 'click', this.boundDoPreviousStep);
	},
    
    /**
     * Figures out what buttons should be shown (back / continue / etc.), and then loads the appropriate step content
     *
     */
    loadWizardStepContent: function loadWizardStepContent()
    {
        // back button display logic
        if (this.currentStep != 1) 
        {
            new Effect.Appear('wizardBack', 
            {
                duration: 0.25
            });
        }
        else 
        {
            new Effect.Fade('wizardBack', 
            {
                duration: 0.25
            });
        }
        
        // continue / place order button display logic
        if (this.currentStep == this.totalSteps || (this.isTrial && this.currentStep == 6)) 
        {
            $('wizardContinue').hide();
			
			if(!this.isTrial)
			{
	            $('wizardPlaceOrder').show();
			}
	        else
			{
				$('wizardPlaceTrialOrder').show();	
			}
        }
        else 
        {
            $('wizardContinue').show();
            if(!this.isTrial)
			{
	            $('wizardPlaceOrder').hide();
			}
	        else
			{
				$('wizardPlaceTrialOrder').hide();	
			}
        }
        
        // now, we fade the current content, and then trigger the view function for the current step...
        new Effect.Fade('dynamicWizardContentCage', 
        {
            duration: 0.25,
            afterFinish: function()
            {
                var step = 'renderStep' + this.currentStep;
                
                this[step]();
            }.bind(this)
        });
    },
	
	fetchSamples: function fetchSamples(msg)
	{
		if(!msg)
		{
			EventManager.publish('/portal/cloud/samples', { request: 'listSamples' });
		}
		else
		{
			this.samples = true;
			this.samplesList = new Hash();
			
	        msg.data.sample.each(function(sample)
	        {
				this.samplesList.set(sample.name, sample);
	        }.bind(this));
		}
	},
	
	showProjectChooserDialog: function showProjectChooserDialog()
	{
		// we now invoke a Web Deployment wizard:
		Portal.Modules.DeploymentWizard.showWizard( { data : { projectName: "/" }} );

		return;
		
		// --- everything that follows for this function is no longer used, but preserved just in case --- //
		
		var file = 'portlets/cloud/templates/deployment_wizard/modal_project_chooser.html';
		
        new Ajax.Request(file, 
        {
            onComplete: function(response)
            {
                this.projectChooserModal = new Control.Modal(response.responseText, 
                {
                    closeOnClick: false,
                    className: 'modal',
                    width: 400,
                    overlayOpacity: 0.5,
                    fade: false,
                    height: null,
                    fadeDuration: 0.25,
                    iframeshim: false,
                    afterOpen: function()
					{
						this.sendTrackingData('c.dw.link');
						
						var newHtml = '<select name="undeployed_project_modal" id="undeployed_project_modal" style="width: 200px;">';
						
						if (Portal.Data.cloudProjects.undeployedProjects.size() == 0) {
							newHtml += '<option value="---">Sample projects...</option>';
						}
						else {
							newHtml += '<option value="---">Please choose...</option>';
						}
						
						if (Portal.Data.cloudProjects.undeployedProjects.size() > 0) {
							newHtml += '<optgroup label="Your Undeployed Projects">';
							
							Portal.Data.cloudProjects.undeployedProjects.each(function(item){
								newHtml += '<option value="0' + item.value.name + '">' + item.value.name + '</option>';
							});
							
							newHtml += '</optgroup>';
						}
						
						newHtml += '<optgroup label="Sample Projects">';
						
						this.samplesList.each(function(item){
							newHtml += '<option value="1' + item.key + '">' + item.key + '</option>';
						});
						
						newHtml += '</optgroup></select>';
						
						$('modalProjectChooserCage').update(newHtml);
						
					}.bind(this)
                });
                
                this.projectChooserModal.open();
            }.bind(this)
        });
	},
	
	closeProjectChooserModal: function closeProjectChooserModal(clicked)
	{
		if (clicked) 
		{
			this.sendTrackingData('c.dw.link.cncl');
		}
		this.projectChooserModal.close();
        this.projectChooserModal.destroy();
	},
	
	invokeWizardExternal: function invokeWizardExternal(project)
	{
		if(project == '---')
		{
			return;
		}
		
		this.loadingWizard = true;
		
		this.closeProjectChooserModal();
		
		this.sendTrackingData('c.dw.link.next');
		
		if(project.substr(0,1) == '0')
		{
			project = project.substr(1);
			try
			{
				var projectType = Portal.Data.cloudProjects.undeployedProjects.get(project).type;	
			} 
			catch(e)
			{
				var projectType = 'unknown';
			}
			
			
			if ($('loading_wizard_cage')) 
			{
				$('loading_wizard_cage').update('<img src="images_global/img_activity.gif" align="absmiddle" class="inline" /> Loading wizard...').show();
			}
			
			// show the wizard
			Portal.Modules.DeploymentWizard.showWizard( { data : { projectName: project }} );
		}
		else
		{
			if($('loading_wizard_cage'))
			{
				$('loading_wizard_cage').update('<img src="images_global/img_activity.gif" align="absmiddle" class="inline" /> Importing project and loading wizard...').show();
			}
			
			project = project.substr(1);
			
			sampleProject = this.samplesList.get(project);
			
            EventManager.publish('/portal/cloud/samples', 
            {
                request: 'importSampleProject',
                name: project,
                file: sampleProject.file
            });
		}
	}
}
