var DeploymentWizardModule = Class.create(
{
    initialize: function initialize()
    {
        this.initVars();
    },
    
    initVars: function initVars()
    {
        // state / flag variables
		this.deploymentStarted			= false;
        this.deploymentInProgress 		= false;
        this.deploymentComplete 		= false;
        this.usernameAction 			= '';
        this.syncShown 					= false;
        this.purchaseCredentialsSaved 	= false;
        this.validatingSiteName 		= false;
        this.changingState 				= false;
        this.nextStepOverride 			= '';
        this.siteNameValid 				= false;
        this.usernameValid 				= false;
        this.messagePending 			= false;
		this.couponCodeApply 			= false;
		this.lastLogMessage 			= '';
		this.currentLogMessage 			= '';
		this.lastProgressWidth 			= 20;
		this.addTabOnSuccess 			= false;
		this.stopAdvance 				= true;
		this.isTrial 					= true;
		this.deploymentCompleteSent		= false;
		this.lastStepEvent				= '';
        
        // process variables
        this.currentStep 		= 1;
        this.totalSteps 		= 0;
        this.currentStepRunning = 0;
        
        // object / data variables
        this.consoleScroller 		= '';
        this.progressBarInterval 	= 10;
        this.newSiteData 			= new UndeployedProject();
        this.billingTemplates 		= new Hash();
        this.breadCrumbs = new Hash(
        {
            1: 'Site Name',
            2: 'Pick a Plan',
            3: 'Plan Options',
            4: 'User Info',
            5: 'Payment Info',
            6: 'Agreement',
            7: 'Confirm'
        });
		
		this.trialBreadCrumbs = new Hash(
        {
            1: 'Site Name',
            4: 'User Info',
            6: 'Agreement',
        });
    },
    
    finishInit: function finishInit()
    {
		this.samples					= false;
		this.samplesList				= new Hash();
		
        this.registerObservers();
        this.extendSelf();
        
        this.notify('startupHookComplete');
    },
    
    dispatchEvent: function dispatchEvent(msg)
    {
		if (msg.data.response == 'listSamples')
		{
			this.fetchSamples(msg);
		}
		
        if (msg.data.projectName) 
        {
            this.showWizard(msg);
            return;
        }
        
		if(msg.data.response == 'describe' && this.currentStep == 1)
		{
			if(this.deploymentStarted && !$('wizardCage'))
			{
				// this.isTrial = ('trial' in msg.data.xmlData) ? msg.data.xmlData.trial.can_deploy_trial : false;
				this._init();
			}
		}
		
        if (msg.data.response == 'get') 
        {
            if (msg.data.name == 'portal.cloud.deployment.' + Portal.Modules.AptanaIdManager.username + '.rememberme') 
            {
                this.purchaseCredentialsSaved = (msg.data.value == 'true') ? true : false;
            }
            if (msg.data.name == 'portal.cloud.deployment.' + Portal.Modules.AptanaIdManager.username + '.rememberme.password') 
            {
				if (msg.data.value != false && msg.data.value != 'false') 
				{
					this.newSiteData.password = msg.data.value;
				}
            }
        }
        
        if (!$('wizardCage') &&['siteEvent','siteConsole'] .indexOf(msg.data.response) == -1) 
        {
            return;
        }
        
        if (msg.data.response == 'checkSiteName') 
        {
            if (this.validatingSiteName == false) 
            {
                this.processStep1(msg);
            }
            else 
            {
				this.validatingSiteName = true;
                this.preValidateSiteName(msg);
            }
        }
        else if (['validateUser', 'createUser'].indexOf(msg.data.response) != -1) 
        {
            this.processStep4(msg);
        }
		else if (msg.data.response == 'siteEvent')
		{
			this.updateProvisioningStatus(msg);
		}
		else if (msg.data.response == 'siteConsole')
		{
			this.updateProvisioningLog(msg);
		}
		else if (msg.data.response == 'deployProject')
		{
			this.doDeployment(msg);
		}
		else if (msg.data.response == 'xmlRest')
		{
			if (this.currentStep == 5) 
			{
				if(this.messagePending)
				{
					// we are showing the current order preview
					this.showBillingOrderPreview(msg);
					
					this.messagePending = false;
				}
				else
				{
					// the user applied the coupon code
					if (this.couponCodeApply) 
					{
						this.showBillingOrderPreview(msg);
						
						this.couponCodeApply = false;
					}
					else 
					{
						this.processStep5(msg);
					}
				}
			}
			else 
			{
				this.renderStep7(msg);
			}
		}
    },
    
    extendSelf: function extendSelf()
    {
        Object.extend(this, DeploymentWizardControllers);
        Object.extend(this, DeploymentWizardViews);
        Object.extend(this, DeploymentWizardBreadCrumbs);
        Object.extend(this, DeploymentWizardHelpers);
        Object.extend(this, DeploymentWizardProcessor);
        Object.extend(this, DeploymentWizardDeploymentManager);
    },
    
    registerObservers: function registerObservers()
    {
        EventManager.subscribe('/portal/cloud/trialstatus', 
        {
            channelHook: 'DeploymentWizard'
        });
		
        EventManager.subscribe('/portal/cloud/startDeployment', 
        {
            channelHook: 'DeploymentWizard'
        });
        EventManager.subscribe('/portal/cloud/deploy/', 
        {
            channelHook: 'DeploymentWizard'
        });
        EventManager.subscribe('/portal/orders/preview', 
        {
            channelHook: 'DeploymentWizard'
        });
		
        // grab the "remember my credentials" stuff...
        EventManager.subscribe('/portal/preferences/', 
        {
            channelHook: 'DeploymentWizard'
        });
		
		EventManager.subscribe('/portal/cloud/samples/', 
        {
            channelHook: 'DeploymentWizard',
            onComplete: function()
            {
				this.fetchSamples();
            }.bind(this)
        });
        
        Portal.Modules.AptanaIdManager.observe('userLoggedOut', function()
        {
            if (!this.wizardDialog || !this.wizardDialog.isOpen) 
            {
                return;
            }
            
            if (this.deploymentInProgress) 
            {
                this.cancelDeployment(true);
            }
            else 
            {
				this.stopAdvance = true;
				this.newSiteData.resetData();
				
                this.purchaseCredentialsSaved = false;
                this.usernameAction = '';
                this.usernameValid = false;
                
                if (this.currentStep >= 4) 
                {
					this.nextStepOverride = '';
					this.currentStepRunning = 4;
                    this.currentStep = 4;
                    this.buildBreadCrumbs();
                    this.loadWizardStepContent();
                }
            }
        }.bind(this));
    }
    
});
Object.Event.extend(DeploymentWizardModule);

Portal.API.startup.registerStartupItem(2, 
{
    moduleName: 'DeploymentWizard',
    moduleObject: DeploymentWizardModule,
    modulePersit: true,
    startupMessage: 'Loading wizards...'
});

var UndeployedProject = Class.create(
{
    initialize: function initialize()
    {
        this.projectName 		= '';
        this.projectType 		= 'jaxer';
        this.siteName 			= '';
        this.hostingData 		= { jaxerEnabled: false };
        this.hostingSummary 	= '';
        this.username 			= '';
        this.password 			= '';
        this.billingAccountId 	= 0;
        this.createNewAccount 	= false;
        this.newBillingData 	= {};
        this.createNewAccount 	= false;
        this.agreeToTerms 		= false;
        this.siteId 			= 0;
		this.couponCode			= '';
		this.couponValid		= false;
    },
    
	resetData: function resetData()
	{
		this.billingAccountId 	= 0;
        this.createNewAccount 	= false;
        this.newBillingData 	= {};
        this.hostingData 		= { jaxerEnabled: false };
		this.createNewAccount 	= false;
        this.agreeToTerms 		= false;
        this.siteId 			= 0;
		this.couponCode			= '';
		this.couponValid		= false;
		this.username			= '';
        this.password 			= '';
	},
	
    update: function update(data)
    {
        if ('projectName' in data) 
        {
            this.projectName = data.projectName;
        }
        
        if ('projectType' in data) 
        {
            this.projectType = data.projectType;
        }
        
        if ('siteName' in data) 
        {
            this.siteName = data.siteName;
        }
        
        if ('hostingData' in data) 
        {
            this.hostingData = data.hostingData;
        }
        
        if ('username' in data) 
        {
            this.username = data.username;
        }
        
        if ('password' in data) 
        {
            this.password = data.password;
        }
        
        if ('billingAccountId' in data) 
        {
            this.billingAccountId = data.billingAccountId;
        }
        
        if ('newBillingData' in data) 
        {
            this.newBillingData = data.newBillingData;
        }
    }
});
