var CloudalyticsClass = Class.create( 
{
	initialize: function()
	{
		this.userAuthenticated = false;
		this.username = '';
		this.password = '';
		this.callbackUrl = '';
		this.dataUrl = '';
		this.sites = new Hash();
	},
	
	finishInit: function()
	{
		var analyticsUrl = Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).urls.analytics;
		
		Portal.Modules.Cloudalytics.callbackUrl = analyticsUrl
		Portal.Modules.Cloudalytics.dataUrl = analyticsUrl.gsub('Dashalytics.php', '/data/');
	},
	
	loginUser: function()
	{
		if(!$('user') || !$F('password'))
		{
			Portal.API.dialogs.alert('Please fill out the form completely to log in.', 'Error');
			return;
		}
		
		this.username = $F('user');
		this.password = $F('password');
		
		$('loginError').removeClassName('clean-error');
		$('loginError').addClassName('activity');
		Portal.API.utils.setContent('loginError', 'Logging in, please wait...');
		$('loginError').style.display = '';
		
		// build url
		var url = this.callbackUrl + '?user=' + this.username + '&password=' + this.password + '&option=sites&currenttime=' + new Date().getTime();
		url = encodeURIComponent(url);
				
        new Ajax.Request('/proxy?url=' + url, 
        {
			method: 'get',
			onComplete: function(request)
			{
				var response = request.responseText.evalJSON();
				
				if(response.err)
				{
					$('loginError').addClassName('clean-error');
					$('loginError').removeClassName('activity');
					Portal.API.utils.setContent('loginError', response.msg);
				}
				else
				{
					Portal.Modules.Cloudalytics.showSiteList(response);
				}
			}
		});
	},
	
	showSiteList: function(data)
	{
		Portal.Modules.Cloudalytics.sites = new Hash();
		// first, store the sites
        data.each(function(site)
        {
        	Portal.Modules.Cloudalytics.sites.set(site.id, { name: site.name, id: site.id, tracker: site.tracker });
		});
		
		var siteList = '';
		var siteListTemplate = new Template('<p><label for="timeframe_#{siteId}">#{siteName}:</label> <select name="timeframe_#{siteId}" id="timeframe_#{siteId}" class="text">#{timeFrames}</select> <a href="javascript: Portal.Modules.Cloudalytics.fetchStats(#{siteId});">View Stats</a></p>');
		var timeFrameTemplate = new Template('<option value="#{key}">#{value}</option>');
		var timeFrames = [
			{ key: '1d', value: '1 Day' },
			{ key: '1w', value: '1 Week' },
			{ key: '1m', value: '1 Month' },
			{ key: '3m', value: '3 Months' },
			{ key: '6m', value: '6 Months' },
			{ key: '1y', value: '1 Year' },
			{ key: '2y', value: '2 Years' }
		];
		
        Portal.Modules.Cloudalytics.sites.each(function(site)
        {
			var timeFrame = '';
			
            timeFrames.each(function(item)
            {
				timeFrame += timeFrameTemplate.evaluate({ key: item.key, value: item.value });
            });
			
			siteList += siteListTemplate.evaluate({siteId: site.value.id, siteName: site.value.name, timeFrames: timeFrame });
			
        });
		
		if(!$('analyticsLoginCage'))
		{
			return;
		}
		
        new Effect.BlindUp('analyticsLoginCage', 
        {
            duration: 0.25,
			afterFinish: function()
			{
				Portal.API.utils.setContent('analyticsSiteList', siteList);
				
				new Effect.BlindDown('analyticsCage', { duration: 0.25 });
			}
        });
	},
	
	fetchStats: function(siteId)
	{
		var siteData = Portal.Modules.Cloudalytics.sites.get(siteId);
		
		var tracker1Template = new Template("<script src=\"https://ssl.google-analytics.com/urchin.js\" type=\"text/javascript\">\n" +
					"<" + "/script>\n" + 
					"<script type=\"text/javascript\"> \n" +
					"_uacct = \"#{trackerCode}\"; \n" +
					"urchinTracker(); \n" +
					"<" + "/script> \n");
		var tracker2Template = new Template("<script type=\"text/javascript\">\n" +
					"var gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\n" +
					"document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n" +
					"<" + "/script>\n" +
					"<script type=\"text/javascript\">\n" +
					"var pageTracker = _gat._getTracker(\"#{trackerCode}\");\n" +
					"pageTracker._initData();\n" +
					"pageTracker._trackPageview();\n" +
					"<" + "/script>\n");
					
		$('tracker1').value = tracker1Template.evaluate({ trackerCode: siteData.tracker });
		$('tracker2').value = tracker2Template.evaluate({ trackerCode: siteData.tracker });
		
		if(!$('analyticsStatsCage'))
		{
			return;
		}
		
		Portal.API.utils.setContent('analyticsChart', '<div class="activity">Loading data, please wait...</div>');
		
		if(!$('analyticsStatsCage'))
		{
			return;
		}
		
		if($('analyticsStatsCage').style.display == 'none')
		{
			new Effect.BlindDown('analyticsStatsCage', 
			{
				duration: 0.25,
				afterFinish: function()
				{
					Portal.Modules.Cloudalytics.fetchChart(siteId);
				}
			});	
		}
		else
		{
			Portal.Modules.Cloudalytics.fetchChart(siteId);
		}
	},
	
	fetchChart: function(siteId)
	{
		var timeRange = $F('timeframe_' + siteId);
		
		var url = Portal.Modules.Cloudalytics.callbackUrl + '?user=' + Portal.Modules.Cloudalytics.username + '&password=' 
				+ Portal.Modules.Cloudalytics.password + '&option=stats&currenttime=' + new Date().getTime()
				+ '&siteid=' + siteId + '&widgetid=' + siteId + '&daterange=' + timeRange;
		url = encodeURIComponent(url);
		
        new Ajax.Request('/proxy?url=' + url, 
        {
			method: 'get',
			onComplete: function(request)
			{
				// now, let's fetch the cached data...
				var url = Portal.Modules.Cloudalytics.dataUrl + 'dashalytics.' + siteId + '.json?currenttime=' + new Date().getTime() + '&widgetid=' + siteId + '&random=' + Math.random();
				url = encodeURIComponent(url);
				
                new Ajax.Request('/proxy?url=' + url, 
                {
					method: 'get', 
					onComplete: function(request)
					{
						var siteData = request.responseText.evalJSON();
						
						var data = Portal.Modules.Cloudalytics.processData(siteData[0].graph.data);
                        var f = Flotr.draw($('analyticsChart'), [
                        {
                            data: data,
                            lines: 
                            {
                                fill: true
                            }
                        }]);
					}
				});
			}
		});
	},
	
	processData: function(data)
	{
		var newData = [];
				
		for (var i = 0; i < data.length; i++) 
		{
			newData.push([i, parseInt(Portal.Modules.Cloudalytics.removeCommas(data[i].Value))]);
		}
		
		return newData;
	},
	
	removeCommas: function(nStr)
	{
		//remove any commas
		nStr = nStr.replace(/,/g,"");
	
		//remove any spaces
		nStr = nStr.replace(/\s/g,"");
	
		return nStr;
	}
});