var SiteServicesListClass = Class.create(
{
	initialize: function initialize(siteId)
	{
		this.loading		= true;
		this.siteId			= siteId;
		this.servicesList	= new Hash();
	},
	
	finishInit: function finishInit()
	{
		this.fetchServices();		
	},
	
	fetchServices: function fetchServices()
	{
		EventManager.publish('/portal/cloud/model', 
        {
			url: 'sites/' + this.siteId + '/services',
            request: 'describe',
            returnChannel: Portal.Channels.services
        });
	},
	
	update: function(data)
	{
		// check for updates to the model (i.e. tomcat no longer in the model, etc.)
		var dataServices = [];
		
		data.services.each(function(item) {
			if('service' in item)
			{
				dataServices.push(item.service.name.toLowerCase());
			}
		});
		
		if(dataServices.size() > 0)
		{
			this.servicesList.each(function(item) {
				if(dataServices.indexOf(item.key) == -1)
				{
					this.servicesList.unset(item.key);
				}
			}.bind(this));
		}
		
		var sortArray = [];
        data.services.each(function(item)
        {
			try
			{
				if ('service' in item) 
				{
					sortArray.push(item.service.name);
				}
				else
				{
					sortArray.push(item.name);
				}
			}
			catch(e)
			{
				console.warn(e);
			}
        });
		
		// we no longer want to sort these, we'll just spit them out as they came in
		// sortArray.sort();
		
        sortArray.each(function(item)
        {
			try
			{
				var service = {};
				
	            data.services.each(function(serviceItem)
	            {
					if('service' in serviceItem && serviceItem.service.name == item)
					{
						service = serviceItem.service;
					}
					else if (serviceItem.name == item)
					{
						service = serviceItem;
					}
	            });
				
				if(!this.servicesList.get(service.name))
				{
					var tempService = new SiteService(service);
				}
				else
				{
					var tempService = this.servicesList.get(service.name);
					tempService.update(service);
				}
				
				this.servicesList.set(service.name, tempService);
			}
			catch (e)
			{
				console.warn(e);
			}
			
        }.bind(this));
		
		if(this.loading)
		{
            EventManager.publish('/portal/cloud/services/versions', 
            {
                request: 'listVersions'
            });
		}
	}
});

var SiteService = Class.create(
{
	initialize: function initialize(data)
	{
		this.name				= '';
		this.status				= '';
		this.currentVersion		= '';
		this.commands			= [];
		this.availableVersions	= [];
		this.configFiles		= [];
		this.logFiles			= [];
		this.info				= [];
		this.enabled			= true;
		
		this.update(data)
	},
	
	update: function update(data)
	{
		if('name' in data)
		{
			this.name = data.name;
		}
		
		if('status' in data)
		{
			this.status = data.status;
		}
		
		if('version' in data)
		{
			this.currentVersion = data.version;
		}
		
		if('versions' in data)
		{
			this.availableVersions = data.versions;
		}
		
		if('available_commands' in data)
		{
			this.setCommands(data.available_commands);
		}
		
		if('config_files' in data)
		{
			this.setConfigFiles(data.config_files);
		}
		
		if('log_files' in data)
		{
			this.setLogFiles(data.log_files);
		}
		
		if('service_info' in data)
		{
			this.setInfo(data.service_info);
		}
		
		if('enabled' in data)
		{
			this.enabled = data.enabled;
		}
	},
	
	setCommands: function setCommands(data)
	{
		this.commands = [];
		
        data.each(function(item)
        {
			if ('command' in item) 
			{
				this.commands.push(item.command);
			}
        }.bind(this));
	},
	
	setConfigFiles: function setConfigFiles(data)
	{
		this.configFiles = [];
		
        data.each(function(item)
        {
            if ('config' in item) 
            {
				this.configFiles.push(item.config);
            }
        }.bind(this))
	},
	
	setLogFiles: function setLogFiles(data)
	{
		this.logFiles = [];
		
        data.each(function(item)
        {
			if ('log' in item)
			{
				this.logFiles.push(item.log);
			}
        }.bind(this));
	},
	
	setInfo: function setInfo(data)
	{
		this.info = [];
		
        data.each(function(item)
        {
			if('info_item' in item)
			{
				this.info.push(item.info_item);
			}
        }.bind(this));
	}
});