var SiteMembershipsClass = Class.create(
{
	initialize: function initialize(siteId)
	{
		this.loading 		= true;
		this.siteId			= siteId;
		this.memberships	= new Hash();
		this.invitations	= new Hash();
	},
	
	finishInit: function finishInit()
	{
		this.fetchMemberships();
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'listMemberships')
		{
			this.update(msg.data);
		}
	},
	
	update: function update(data)
	{
		this.memberships = new Hash();
		
        data.team.memberships.each(function(item)
        {
			var tempMembership = new SiteMembershipClass(item.membership);
			this.memberships.set(item.membership.id, tempMembership);
        }.bind(this));
		
		this.invitations = new Hash();
		
		if ('invitations' in data.team) 
		{
			data.team.invitations.each(function(item) 
			{

				var tempInvitation = new SiteInvitationClass(item.invitation);
				this.invitations.set(item.invitation.id, tempInvitation);
			
			}.bind(this));

		}

		if(this.loading)
		{
			this.loading = false;
		}
	},
	
	fetchMemberships: function()
	{
		// EventManager.publish('/portal/cloud/memberships', { request: 'listMemberships', site: this.siteId });
		EventManager.publish('/portal/cloud/model', 
        {
			url: 'sites/' + this.siteId + '/memberships',
			returnChannel: Portal.Channels.team,
			request: 'describe'
		});
	},
	
	getUsername: function getUsername(userId)
	{
		return this.memberships.get(userId).username;
	}
});

var SiteMembershipClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.id			= '';
		this.role		= '';
		this.user		= '';
		this.username 	= '';
		this.firstName	= '';
		this.lastName	= '';
		this.email		= '';
		
		this.update(data)
	},
	
	update: function update(data)
	{
		if('role_id' in data)
		{
			this.role = data.role_id;
		}
		
		if('user_id' in data)
		{
			this.user = data.user_id;
		}
		
		if('username' in data)
		{
			this.username = data.username;
		}
		
		if('id' in data)
		{
			this.id = data.id;
		}
		
		if('first_name' in data)
		{
			this.firstName = data.first_name;
		}
		
		if('last_name' in data)
		{
			this.lastName = data.last_name;
		}
		
		if('email' in data)
		{
			this.email = data.email;
		}
	}
});

var SiteInvitationClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.id			= 0;
		this.key		= '';
		this.role_id	= 0;
		this.role		= '';
		this.site_id	= 0;
		this.site		= '';
		this.user_id	= 0;
		this.username	= '';
		this.email		= '';
		this.date_created	= '';
		this.date_invited	= '';
		
		this.update(data);
	},
	
	update: function update(data)
	{
		if('id' in data)
		{
			this.id = data.id;
		}		
		
		if('key' in data)
		{
			this.key = data.key;
		}
		
		if('role' in data)
		{
			this.role_id 	= data.role.id;
			this.role		= data.role.name;
		}
		
		if('user' in data)
		{
			this.user_id	= data.user.id;
			this.username	= data.user.username
		}
		
		if('site' in data)
		{
			this.site_id 	= data.site.id;
			this.site		= data.site.name;
		}
		
		if('email' in data)
		{
			this.email = data.email;
		}
		
		if('sent_at' in data && typeof(data.sent_at) == 'string')
		{
			this.date_invited = data.sent_at;
			
			if(this.date_invited.indexOf('T') == -1)
			{
				return;
			}
			
			var dateArray = this.date_invited.split('T');
			var datePart = dateArray[0];
			var timePart = dateArray[1];
			timePart = timePart.substring(0, timePart.lastIndexOf('.'));
			timePart = timePart.split(':');
			datePart = datePart.split('-');
			
			var d = new Date();
			
			d.setYear(datePart[0]);
			d.setMonth(datePart[1]-1);
			d.setDate(datePart[2]);
			d.setHours(timePart[0]);
			d.setMinutes(timePart[1]-d.getTimezoneOffset());
			
			this.date_invited = d.toLocaleString();
		}
		
		if('created_at' in data)
		{
			this.date_created = data.created_at;
		}
	}
})
