var Site = Class.create(
{
	initialize: function initialize(data)
	{
		this.loading		= true;
		this.resizing		= false;
		this.id				= 0;
		this.name			= '';
		this.status			= 'Running';
		this.type			= '';
		this.project		= '';
		this.domain			= '';
		this.ip				= '';
		this.lastSyncTime	= '';
		this.lastSyncUser	= '';
		this.lastDump		= '';
		this.sftpRoot		= '';
		this.isOwner		= false;
		this.ownerId		= 0;
		this.mysqlUser		= '';
		this.mysqlPass		= '';
		this.sudoEnabled	= false;
		this.monitoring		= true;
		this.urls			= new SiteUrlClass();
		this.diskUsage		= new SiteDiskUsageClass();
		this.logs			= new SiteLogsClass();
		this.files			= new SiteFilesClass();
		this.domains		= new SiteDomainsClass();
		this.hostingPlanId	= 0;
		this.hostingOptions	= new Hash();
		this.endpoint		= 'public';
		
		if('id' in data)
		{
			this.events	= new SiteNotificationListClass(data.id);
			this.events.finishInit();	
			
			this.memberships = new SiteMembershipsClass(data.id);
			this.memberships.finishInit();
			
			this.services = new SiteServicesListClass(data.id);
			this.services.finishInit();
		}
		else
		{
			this.events = null;
		}
		
		this.update(data);
	},
	
	update: function update(data)
	{
		if('passThru' in data && 'site' in data.passThru)
		{
			this.sudoEnabled = data.passThru.site.sudo_enabled;
			this.monitoring = data.passThru.site.monitoring;
		}
        
		
		if('endpoint' in data)
		{
			this.endpoint = data.endpoint;
		}
		
		// take care of the other stuff that might need to be updated first...
		if (data.urls) 
		{
			this.urls.update(data);
		}
		this.diskUsage.update(data);
		if (data.paths) 
		{
			this.logs.update(data);
			this.files.update(data.paths);
		}
		
		if (data.domains)
		{
			try
			{
				this.sftpRoot = data.domains[0].paths.sftp_root;
			}
			catch (e)
			{
				// nothing, we don't want an error here
			}
			
			this.domains.update(data);
		}
		
		if('id' in data)
		{
			this.id = data.id
		}
		
		if('name' in data)
		{
			this.name = data.name;
		}
		
		if('status' in data)
		{
			this.status = data.status;
		}
		
		if('type' in data)
		{
			this.type = data.type;
		}
		
		if('project' in data)
		{
			this.project = data.project;
		}
		
		if('ip' in data)
		{
			this.ip = data.ip;
		}
		
		if('lastSyncTime' in data)
		{
			this.lastSyncTime = data.lastSyncTime;
		}
		
		if('lastSync' in data)
		{
			this.lastSyncUser = data.lastSync;
		}
		
		if('lastDumpTime' in data)
		{
			this.lastDump = data.lastDumpTime;
		}
		
		if('owner' in data)
		{
			this.isOwner = data.owner;
		}
		
		if('ownerId' in data)
		{
			this.ownerId = data.ownerId;
		}
		
		if('app_username' in data)
		{
			this.mysqlUser = data.app_username;
		}
		
		if('app_password' in data)
		{
			this.mysqlPass = data.app_password;
		}
		
		if('plan' in data)
		{
			this.hostingPlanId = data.plan;
		}
		
		if('options' in data)
		{
			this.hostingOptions = new Hash();
			
            data.options.each(function(item)
            {
				this.hostingOptions.set(parseInt(item.id), parseInt(item.plan));
            }.bind(this));
		}
		
		if('domain' in data)
		{
			this.domain = data.domain;
			
			// if we've got this, we've gotten the full model
			// this is only relevant in the initial population of the model...
			this.loading = false;
		}
	}
});

/* -------------------------------------------------------- */
/* Site Urls												*/
/* -------------------------------------------------------- */
var SiteUrlClass = Class.create(
{
	initialize: function initialize()
	{
		this.publicUrl	= '';
		this.privateUrl	= '';
		this.stagingUrl	= '';
		this.svn		= '';
		this.git		= '';
		this.sqlBuddy	= '';
		this.phpMyAdmin	= '';
		this.analytics	= '';
		this.webstats	= '';
		this.resources	= '';
		this.jaxerDiag	= '';
		this.awstats	= '';
	},
	
	update: function update(data)
	{
		if('domain' in data)
		{
			this.publicUrl = 'http://' + data.domain;
			this.privateUrl = 'http://private-' + data.domain;
			this.stagingUrl = 'http://staging-' + data.domain;
		}
		
		if('awstats' in data.urls)
		{
			this.awstats = data.urls.awstats;
		}
		
		if('SVN' in data.urls)
		{
			this.svn = data.urls.SVN;
		}
		
		if('git' in data.urls)
		{
			this.git = data.urls.git;
		}
		
		if('DBAdminUrl' in data.urls)
		{
			this.sqlBuddy = data.urls.DBAdminUrl;
		}
		
		if('PHPMyAdmin' in data.urls)
		{
			this.phpMyAdmin = data.urls.PHPMyAdmin;
		}
		
		if('Analytics' in data.urls)
		{
			this.analytics = data.urls.Analytics;
		}
		
		if('Webstats' in data.urls)
		{
			this.webstats = data.urls.Webstats
		}
		
		if('Resource Usage' in data.urls)
		{
			this.resources = data.urls['Resource Usage'];
		}
		
		if('Jaxer Diagnostics' in data.urls)
		{
			this.jaxerDiag = data.urls['Jaxer Diagnostics'];
		}
	}
});

/* -------------------------------------------------------- */
/* Site Files												*/
/* -------------------------------------------------------- */
var SiteFilesClass = Class.create(
{
	initialize: function initialize()
	{
		this.backups			= '';
		this.jaxerLogJs			= '';
		this.jaxerAppsJs		= '';
		this.jaxerConfigJs		= '';
		this.jaxerPrefsJs		= '';
		this.jaxerManagerCfg	= '';
	},
	
	update: function update(data)
	{
		if('Backups' in data)
		{
			this.backups = data.Backups;
		}
		
		if('Jaxer Log Configuration' in data)
		{
			this.jaxerLogJs = data['Jaxer Log Configuration'];
		}
		
		if('Jaxer App Configuration' in data)
		{
			this.jaxerAppsJs = data['Jaxer App Configuration'];
		}
		
		if('Jaxer Configuration' in data)
		{
			this.jaxerConfigJs = data['Jaxer Configuration'];
		}
		
		if('Jaxer Preferences' in data)
		{
			this.jaxerPrefsJs = data['Jaxer Preferences'];
		}
		
		if('Jaxer Manager Configuration' in data)
		{
			this.jaxerManagerCfg = data['Jaxer Manager Configuration'];
		}
	}
});

/* -------------------------------------------------------- */
/* Site Domains												*/
/* -------------------------------------------------------- */
var SiteDomainsClass = Class.create(
{
	initialize: function initialize()
	{
		this.publicInfo		= new Hash();
		this.privateInfo	= new Hash();
		this.stagingInfo	= new Hash();
	},		
	
	update: function update(data)
	{
        data.domains.each(function(domain)
        {
			// private
			if(domain.name.indexOf('private-') != -1)
			{
				this.privateInfo.set('documentRootPrefix', domain.document_root_prefix + '/');
				this.privateInfo.set('documentRoot', domain.document_root.replace(domain.document_root_prefix + '/', ''));
				this.privateInfo.set('id', domain.id);
			}
			// staging
			else if (domain.name.indexOf('staging-') != -1)
			{
				this.stagingInfo.set('documentRootPrefix', domain.document_root_prefix + '/');
				this.stagingInfo.set('documentRoot', domain.document_root.replace(domain.document_root_prefix + '/', ''));
				this.stagingInfo.set('id', domain.id);
			}
			// public
			else
			{
				this.publicInfo.set('documentRootPrefix', domain.document_root_prefix + '/');
				this.publicInfo.set('documentRoot', domain.document_root.replace(domain.document_root_prefix + '/', ''));
				this.publicInfo.set('id', domain.id);
			}
        }.bind(this));
	}
});

/* -------------------------------------------------------- */
/* Site Logs												*/
/* -------------------------------------------------------- */
var SiteLogsClass = Class.create(
{
	initialize: function initialize()
	{
		this.jaxerLog			= '';
		this.publicLog			= '';
		this.publicErrorLog		= '';
		this.privateLog			= '';
		this.privateErrorLog	= '';
	},
	
	update: function update(data)
	{
		if('Jaxer Log' in data.paths)
		{
			this.jaxerLog = data.paths['Jaxer Log'];
		}
		
        data.domains.each(function(item)
        {
			// public stuff...
			if(item.name.indexOf('private') == -1)
			{
				if('access_log' in item.paths)
				{
					this.publicLog = item.paths.access_log;
				}
				
				if('error_log' in item.paths)
				{
					this.publicErrorLog = item.paths.error_log;
				}
			}
			else if (item.name.indexOf('private') != -1)
			{
				if('access_log' in item.paths)
				{
					this.privateLog = item.paths.access_log;
				}
				
				if('error_log' in item.paths)
				{
					this.privateErrorLog = item.paths.error_log;
				}
			}
        }.bind(this));
	}
});

/* -------------------------------------------------------- */
/* Disk Usage												*/
/* -------------------------------------------------------- */
var SiteDiskUsageClass = Class.create(
{
	initialize: function initialize()
	{
		// passed in the site model
		this.diskPercent	= 0;
		this.diskSize		= 0;
		
		// calculated values
		this.totalDisk		= 0;
		this.totalUsed		= 0;
		this.totalLeft		= 0;
		this.usagePercent	= 0;
		this.chartIncrement	= 0;
	},
	
	update: function update(data)
	{
		if('disk' in data)
		{
			this.diskPercent = data.disk;
		}
		
		if('diskSize' in data)
		{
			this.diskSize = data.diskSize;
		}
		
		this.calculateStats();
	},
	
	calculateStats: function calculateStats(startingDiskSize)
	{
		// if (!startingDiskSize) 
		// {
			this.totalDisk = Math.round((this.diskSize * 1000000) / 10000) / 100;
			this.totalUsed = Math.round((this.diskPercent / 100) * (this.diskSize * 1000000) / 10000) / 100;
			this.usagePercent = 100 - this.diskPercent;
			this.totalLeft = Math.round((this.totalDisk - this.totalUsed) * 100) / 100;
			this.chartIncrement = Math.round(this.diskPercent / 5) * 17 - 17;
		/*}
		else
		{
			this.totalDisk = Math.round((this.diskSize * 1000000) / 10000) / 100;
			var diskOffset = this.totalDisk - startingDiskSize;
			this.totalUsed = Math.round((this.diskPercent / 100) * (this.diskSize * 1000000) / 10000) / 100;
			
			this.totalUsed = (this.totalUsed - diskOffset =< 0) ? 0 : this.totalUsed - diskOffset; 
			
			
		}*/
		
		if(isNaN(this.totalDisk))
		{
			this.totalDisk = 0;
		}
		
		if(isNaN(this.totalUsed))
		{
			this.totalUsed = 0;
		}
		
		if(isNaN(this.usagePercent))
		{
			this.usagePercent = 0;
		}
		
		if(isNaN(this.totalLeft))
		{
			this.totalLeft = 0;
		}
		
		if(isNaN(this.chartIncrement))
		{
			this.chartIncrement = 0;
		}
	}
});
