var CloudUserClass = Class.create(UserClass,
{
	initialize: function initialize($super)
	{
		$super();
	},
	
	initVars: function initVars($super)
	{
		$super();
		
		this.subscriptionsLoading 	= true;
		this.userChannelsLoading	= true;
		this.subscriptions 			= new Hash();
		this.userChannels			= new Hash();
	},
	
	finishInit: function finishInit($super)
	{
		$super();
		
		EventManager.subscribe('/portal/cloud/subscriptions', 
        {
            channelHook: 'currentUser',
			onComplete: function()
			{
				this.fetchChannelSubs();
			}.bind(this)
		});
		
        EventManager.subscribe('/portal/cloud/user_channels', 
        {
			channelHook: 'currentUser',
			onComplete: function ()
			{
				this.fetchUserChannels();
			}.bind(this)
		});
		
		Portal.Modules.AptanaIdManager.observe('userLoggedIn', function() 
		{
			this.subscriptionsLoading = true;
			this.userChannelsLoading = true;
			
			this.fetchChannelSubs();
			this.fetchUserChannels();
		}.bind(this));
		
        Portal.Modules.OnlineStatus.observe('onlineStatusChanged', function(isOnline)
        {
			this.subscriptionsLoading = true;
			this.userChannelsLoading = true;
			
			this.fetchChannelSubs();
			this.fetchUserChannels();
        }.bind(this));
	},
	
	dispatchEvent: function dispatchEvent($super, msg)
	{
		$super(msg);
		
		if (msg.data.response == 'describe' && msg.channel == '/portal/cloud/subscriptions')
		{
			this.fetchChannelSubs(msg);
		}
		
		else if (msg.data.response == 'describe' && msg.channel == '/portal/cloud/user_channels')
		{
			this.fetchUserChannels(msg);
		}
	},
	
	fetchUserChannels: function fetchUserChannels(msg)
	{
		if(!msg)
		{
			if(!Portal.Modules.AptanaIdManager.isLoggedIn)
			{
				this.userChannelsLoading = false;
				this.notify('userChannelsLoaded');
				return;
			}
			
			this.userChannelsLoading = true;
			
			// make sure the user model is loaded before we try and fetch the subs..
			if(!this.userId)
			{
				// it isn't so watch "this" for the load event..
				this.observe('userModelLoaded', function()
				{
					this.fetchUserChannels();
					
				}.bind(this));
				
				return;
			}
			
			// request the subscriptions
			EventManager.publish('/portal/cloud/model', 
            {
				url: 'users/' + this.userId + '/channels',
                request: 'describe',
				returnChannel: '/portal/cloud/user_channels'
            });
		}
		else
		{
			this.userChannels = new Hash();
			
			if(!('xmlData' in msg.data) || !('channels' in msg.data.xmlData))
			{
				if(this.userChannelsLoading)
				{
					this.userChannelsLoading = false;
					this.notify('userChannelsLoaded');
					return;
				}
			}
			
            msg.data.xmlData.channels.each(function(item)
            {
				var channel = item.channel;
				
				if(!this.userChannels.get(channel.id))
				{
					var tempChannel = new UserChannelsClass(channel);
				}
				else
				{
					var tempChannel = this.userChannels.get(channel.id);
					tempChannel.update(channel);
				}
				
				this.userChannels.set(channel.id, tempChannel);
				
            }.bind(this));
			
			if(this.userChannelsLoading == true)
			{
				this.userChannelsLoading = false;
			}
			
			this.notify('userChannelsLoaded');
		}
	},
	
	fetchChannelSubs: function fetchChannelSubs(msg)
	{
		if(!msg)
		{
			if(!Portal.Modules.AptanaIdManager.isLoggedIn)
			{
				this.subscriptionsLoading = false;
				this.notify('userModelLoaded');
				return;
			}
			
			this.subscriptionsLoading = true;
			
			// make sure the user model is loaded before we try and fetch the subs..
			if(!this.userId)
			{
				// it isn't so watch "this" for the load event..
				this.observe('userModelLoaded', function()
				{
					this.fetchChannelSubs();
					
				}.bind(this));
				
				return;
			}
			
			// request the subscriptions
			EventManager.publish('/portal/cloud/model', 
            {
				url: 'users/' + this.userId + '/subscriptions',
                request: 'describe',
				returnChannel: '/portal/cloud/subscriptions'
            });
		}
		else
		{
			this.subscriptions = new Hash();
			
			if(!('xmlData' in msg.data) || !('subscriptions' in msg.data.xmlData))
			{
				if(this.subscriptionsLoading)
				{
					this.subscriptionsLoading = false;
					this.notify('subscriptionsLoaded');
					return;
				}
			}
			
            msg.data.xmlData.subscriptions.each(function(item)
            {
				var subscription = item.subscription;
				
				if(!this.subscriptions.get(subscription.id))
				{
					var tempSub = new UserSubscriptionClass(subscription);
				}
				else
				{
					var tempSub = this.subscriptions.get(subscription.id);
					tempSub.update(subscription);
				}
				
				this.subscriptions.set(subscription.id, tempSub);
				
            }.bind(this));
			
			if(this.subscriptionsLoading == true)
			{
				this.subscriptionsLoading = false;
			}
			
			this.notify('subscriptionsLoaded');
		}
	},
	
	getUserSubId: function getUserSubId (eventId, userChannelId)
	{
		var returnValue = false;
		
        this.subscriptions.each(function(subscription)
        {
			if(subscription.value.eventId == eventId && subscription.value.channelId == userChannelId)
			{
				returnValue = subscription.value.id
			}
        });
		
		return returnValue;
	}
	
});

Object.Event.extend(CloudUserClass);;