var ControllerTemplate = new Template('<a href="javascript: Portal.Modules.JaxerServerController.setJaxerState();" id="jaxer_controller"><img src="images_global/button_jaxer_#{state}.png" /></a>');

var JaxerServerControllerModule = Class.create(
{
	initialize: function initialize()
	{
		this.element	= 'jaxer_server_cage';
		this.jaxerState	= '';
	},
	
	finishInit: function finishInit()
	{
        EventManager.subscribe('/portal/jaxer/jaxerController/', 
        {
            channelHook: 'JaxerServerController',
            onComplete: function()
            {
				this.getJaxerState();
            }.bind(this)
        });
		EventManager.subscribe('/portal/jaxer/jaxerController', { channelHook: 'JaxerServerController' });
		
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'serverStatus')
		{
			this.getJaxerState(msg);
		}
		else if (msg.data.response == 'controlServer')
		{
			this.setJaxerState(msg);
		}
	},
	
	getJaxerState: function getJaxerState(msg)
	{
		if(!msg)
		{
			EventManager.publish('/portal/jaxer/jaxerController', { request: 'serverStatus' });
		}
		else
		{
			this.jaxerState = msg.data.status;
			this.displayJaxerController();
		}
	},
	
	setJaxerState: function setJaxerState(msg)
	{
		var stateToSet = 'start';
		
		if(this.jaxerState == 'running')
		{
			stateToSet = 'stop';
		}
		
		if(!msg)
		{
            Portal.API.dialogs.confirm(
            {
				message: 'Are you sure you wish to ' + stateToSet + ' the internal Jaxer server?',
				onConfirm: function()
				{
                    new Effect.Fade(this.element, 
                    {
                        duration: 0.25,
                        afterFinish: function()
                        {
							Portal.API.utils.setContent(this.element, '<div class="activity" style="text-align: left;"><strong>Working...</strong></div>');
							
                            new Effect.Appear(this.element, 
                            {
                                duration: 0.25,
                                afterFinish: function()
                                {
				                    EventManager.publish('/portal/jaxer/jaxerController', 
				                    {
				                        request: 'controlServer',
				                        setState: stateToSet
				                    });
                                }
                            });
                        }.bind(this)
                    });
				}.bind(this)
			})
		}
		else
		{
			if(!$(this.element))
			{
				return;
			}
			
			this.getJaxerState();
		}
	},
	
	displayJaxerController: function displayJaxerController()
	{
		var state = (this.jaxerState == 'running') ? 'stop' : 'start';
		
		$('jaxer_status').update(this.jaxerState);
		
        new Effect.Fade(this.element, 
        {
            duration: 0.25,
            afterFinish: function()
            {
				Portal.API.utils.setContent(this.element, ControllerTemplate.evaluate({ state: state }));
				
				new Effect.Appear(this.element, { duration: 0.25 });
            }.bind(this)
        });
		
	},
	
	doAction: function doAction(action)
	{
		var channel = '';
		
		switch(action)
		{
			case 'shell':
				EventManager.publish('/portal/views/show', { id: 'com.aptana.ide.framework.jaxer.interactiveConsole'})
				break;
			case 'activity':
				EventManager.publish('/portal/jaxer/jaxerController', { request: 'tailLog'})
				break;
			case 'prefs':
				EventManager.publish('/portal/preferences', { request: 'show', id: 'com.aptana.ide.framework.jaxer.preferences.JaxerPreferencePage' });
				break;
			case 'servers':
				EventManager.publish('/portal/views/show', { id: 'com.aptana.ide.server.ui.serversView'})
				break;
			case 'packageServer':
				EventManager.publish('/portal/jaxer', { request: 'showPackageServer' });
				break;
			case 'samples':
				EventManager.publish('/portal/jaxer', { request: 'showSamples' });
				break;
		}
	},
	
	editConfig: function editConfig(config)
	{
		EventManager.publish('/portal/jaxer', { request: 'editConfig', file: config });
	}
});