/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.view;

import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.preferences.ThemeManagerAdapter;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolder;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabItem;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultThemeListener;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.themes.IThemeManager;

public final class TabTools {
    public static DefaultTabFolder createTabFolder(Composite parent) {
        final DefaultTabFolder fld = new DefaultTabFolder(parent, 64, false, false);
        fld.setSimpleTabs(false);
        ToolBar toolBar = new ToolBar(fld.getToolbarParent(), 0);
        fld.setToolbar((Control)toolBar);
        new ToolBarManager(toolBar);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        final DefaultThemeListener themeListener = new DefaultThemeListener(fld, (IPropertyMap)new ThemeManagerAdapter(themeManager));
        IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                themeListener.update();
            }
        };
        themeManager.addPropertyChangeListener(propertyChangeListener);
        themeListener.update();
        fld.setActive(1);
        fld.shellActive(false);
        fld.getControl().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                fld.layout(true);
            }
        });
        fld.layout(true);
        return fld;
    }

    public static DefaultTabItem addTab(DefaultTabFolder fld, String name, Control control) {
        return TabTools.addTab(fld, name, control, 0);
    }

    public static DefaultTabItem addTab(DefaultTabFolder fld, String name, Control control, int pos) {
        DefaultTabItem add = (DefaultTabItem)fld.add(pos, 0);
        add.setInfo(new PartInfo((IPresentablePart)new CustomPresentablePart(name, control)));
        fld.setSelection((AbstractTabItem)add);
        return add;
    }

    public static void removeTab(AbstractTabItem tab) {
        tab.dispose();
    }

    private TabTools() {
    }

    private static final class CustomPresentablePart
    implements IPresentablePart {
        private String name;
        private Control control;

        public CustomPresentablePart(String tabName, Control control) {
            this.name = tabName;
            this.control = control;
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public Control getControl() {
            return this.control;
        }

        public IPartMenu getMenu() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.name;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleStatus() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public Control getToolBar() {
            return null;
        }

        public boolean isBusy() {
            return false;
        }

        public boolean isCloseable() {
            return true;
        }

        public boolean isDirty() {
            return false;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setBounds(Rectangle bounds) {
        }

        public void setFocus() {
        }

        public void setVisible(boolean isVisible) {
        }

        public void addPartPropertyListener(IPropertyChangeListener listener) {
        }

        public String getPartProperty(String key) {
            return null;
        }

        public void removePartPropertyListener(IPropertyChangeListener listener) {
        }

        public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
            return 0;
        }

        public int getSizeFlags(boolean width) {
            return 0;
        }
    }
}

