/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IDisconnectableConnection;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.impl.LineBasedLogWatcher;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import com.aptana.ide.logging.impl.WebLogResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.eclipse.core.runtime.Plugin;

public class SFTPLineBasedLogWatcher
extends LineBasedLogWatcher {
    public SFTPLineBasedLogWatcher(WebLogResource resource, LogWatcherConfiguration config) {
        super(config, resource);
    }

    protected long getCurrentLogLength() throws IOException {
        URLConnection connection = this.getUrl().openConnection();
        try {
            connection.connect();
            long l = connection.getContentLength();
            return l;
        }
        catch (ConnectException ex) {
            throw ex;
        }
        finally {
            if (connection != null && connection instanceof IDisconnectableConnection) {
                ((IDisconnectableConnection)connection).disconnect();
            }
        }
    }

    protected void readData(int startPos, ByteBuffer buffer, int maxBytesToRead) throws IOException {
        URLConnection connection = this.getUrl().openConnection();
        connection.setDoInput(true);
        InputStream stream = null;
        try {
            int got;
            stream = (InputStream)connection.getContent();
            if (startPos > 1) {
                stream.skip(startPos - 1);
            }
            int gotBytes = 0;
            byte[] to = buffer.array();
            while ((got = stream.read(to, gotBytes, maxBytesToRead - gotBytes)) != -1 && (gotBytes += got) != maxBytesToRead) {
            }
            buffer.limit(gotBytes);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            finally {
                if (connection != null && connection instanceof IDisconnectableConnection) {
                    ((IDisconnectableConnection)connection).disconnect();
                }
            }
        }
    }

    protected URL getUrl() {
        try {
            return this.getResource().getURI().toURL();
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

