/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model;

import com.aptana.ide.core.model.CoreModelObject;
import com.aptana.ide.core.model.ModelField;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldModelObject
extends CoreModelObject {
    protected HashMap<String, ModelField> fields = new HashMap();
    protected Node modelNode;

    public FieldModelObject() {
        this.addField("id", "id", null);
    }

    public void setField(String name, String value) {
        ModelField field = this.fields.get(name);
        if (field != null && this.isModelChanged(field.getValue(), value)) {
            field.setValue(value);
            this.fireChange();
        }
    }

    public String getField(String name) {
        return this.getField(name, true);
    }

    public String getField(String name, boolean search) {
        String value = null;
        ModelField field = this.fields.get(name);
        if (field == null && search && this.modelNode != null) {
            this.addField(name, name, this.getTextContent(name, this.modelNode));
            field = this.fields.get(name);
        }
        if (field != null) {
            value = field.getValue();
        }
        return value;
    }

    public Collection<ModelField> getFields() {
        return this.fields.values();
    }

    public int getIntegerField(String name) {
        int value = -1;
        String stringValue = this.getField(name);
        if (stringValue != null) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return value;
    }

    public boolean getBooleanField(String name) {
        return Boolean.parseBoolean(this.getField(name));
    }

    public boolean addField(String remoteName, String localName, String value) {
        boolean added = false;
        if (remoteName != null) {
            ModelField field = new ModelField(localName, remoteName, value);
            if (localName != null) {
                this.fields.put(localName, field);
            }
            this.fields.put(remoteName, field);
            added = true;
        }
        return added;
    }

    @Override
    public void fromNode(Node node) {
        this.modelNode = node;
        boolean changed = false;
        for (ModelField field : this.fields.values()) {
            String newValue = this.getTextContent(field.getRemoteName(), node);
            if (!this.isNewValueValid(field.getValue(), newValue)) continue;
            field.setValue(newValue);
            changed = true;
        }
        if (changed |= this.parseNestedElements(node)) {
            this.fireChange();
        }
    }

    @Override
    public Node toNode() {
        return this.modelNode;
    }

    @Override
    public String getId() {
        return this.getField("id");
    }

    @Override
    public void setId(String id) {
        this.setField("id", id);
    }

    protected boolean parseNestedElements(Node node) {
        return false;
    }

    protected void addNestedElementXML(StringBuffer buffer) {
    }

    @Override
    public String toXML() {
        StringBuffer buffer = new StringBuffer("<" + this.getItemString() + ">");
        this.addNestedElementXML(buffer);
        for (ModelField field : this.fields.values()) {
            if (field.getValue() == null) continue;
            buffer.append("<" + field.getRemoteName() + ">");
            buffer.append(field.getValue());
            buffer.append("</" + field.getRemoteName() + ">");
        }
        buffer.append("</" + this.getItemString() + ">");
        return buffer.toString();
    }
}

