/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.sync;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.Messages;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.WorkspaceSaveParticipant;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.ProtocolManager;
import com.aptana.ide.core.io.sync.ISerializableSyncItem;
import com.aptana.ide.core.io.sync.ISyncManagerChangeListener;
import com.aptana.ide.core.io.sync.VirtualFileManagerSyncPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyncManager
implements ISerializableSyncItem {
    static SyncManager _syncManager = null;
    private ArrayList<Object> items = new ArrayList();
    private ArrayList<String> unknownItems = new ArrayList();
    private ArrayList<ISyncManagerChangeListener> listeners = new ArrayList();

    private SyncManager() {
    }

    private void readState(File file) {
        StringBuffer contents;
        block17: {
            BufferedReader input;
            block16: {
                contents = new StringBuffer();
                input = null;
                try {
                    try {
                        input = new BufferedReader(new FileReader(file));
                        String line = null;
                        while ((line = input.readLine()) != null) {
                            contents.append(line);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format(Messages.InitialStartup_CannotFindFile, file.getAbsolutePath()));
                        break block16;
                    }
                    catch (IOException iOException) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format(Messages.InitialStartup_IOError, file.getAbsolutePath()));
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException iOException) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format(Messages.InitialStartup_ErrorClosing, file.getAbsolutePath()));
                    }
                    throw throwable;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                    break block17;
                }
                catch (IOException iOException) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format(Messages.InitialStartup_ErrorClosing, file.getAbsolutePath()));
                }
                break block17;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), StringUtils.format(Messages.InitialStartup_ErrorClosing, file.getAbsolutePath()));
            }
        }
        SyncManager.getSyncManager().fromSerializableString(contents.toString());
    }

    public static synchronized SyncManager getSyncManager() {
        if (_syncManager == null) {
            _syncManager = new SyncManager();
            WorkspaceSaveParticipant saveParticipant = new WorkspaceSaveParticipant();
            try {
                IPath location;
                ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)AptanaCorePlugin.getDefault(), (ISaveParticipant)saveParticipant);
                if (lastState != null && (location = lastState.lookup((IPath)new Path("save"))) != null) {
                    File f = AptanaCorePlugin.getDefault().getStateLocation().append(location).toFile();
                    _syncManager.readState(f);
                }
            }
            catch (CoreException e) {
                IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.InitialStartup_ErrorReadingData, e);
            }
        }
        return _syncManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Object item) {
        ArrayList<Object> arrayList = this.items;
        synchronized (arrayList) {
            this.items.add(item);
        }
        this.fireSyncManagerChangeEvent(item, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(Object item) {
        ArrayList<Object> arrayList = this.items;
        synchronized (arrayList) {
            this.items.remove(item);
        }
        this.fireSyncManagerChangeEvent(item, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getItems() {
        ArrayList<Object> arrayList = this.items;
        synchronized (arrayList) {
            return this.items.toArray();
        }
    }

    public Object[] getItems(Class<?> type) {
        Object[] allItems = this.getItems();
        ArrayList<Object> finalList = new ArrayList<Object>();
        int i = 0;
        while (i < allItems.length) {
            Object o = allItems[i];
            if (o.getClass() == type) {
                finalList.add(o);
            }
            ++i;
        }
        return finalList.toArray((Object[])Array.newInstance(type, finalList.size()));
    }

    public void fireSyncManagerChangeEvent(Object o, int action) {
        int i = 0;
        while (i < this.listeners.size()) {
            ISyncManagerChangeListener listener = this.listeners.get(i);
            listener.syncManagerEvent(o, action);
            ++i;
        }
    }

    public void addSyncManagerChangeEvent(ISyncManagerChangeListener l) {
        this.listeners.add(l);
    }

    public void removeSyncManagerChangeEvent(ISyncManagerChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public String toSerializableString() {
        String data;
        Object o;
        Object[] allItems = this.getItems();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < allItems.length) {
            o = allItems[i];
            if (o instanceof IVirtualFileManager && o instanceof ISerializableSyncItem && !((IVirtualFileManager)o).isTransient() && (data = ((ISerializableSyncItem)o).toSerializableString()) != null) {
                sb.append(((ISerializableSyncItem)o).getType());
                sb.append("!!!!");
                sb.append(data);
                sb.append("@@@@");
            }
            ++i;
        }
        for (String element : this.unknownItems) {
            sb.append(element);
        }
        sb.append("~~~~");
        i = 0;
        while (i < allItems.length) {
            o = allItems[i];
            if (o instanceof VirtualFileManagerSyncPair && o instanceof ISerializableSyncItem && (data = ((ISerializableSyncItem)o).toSerializableString()) != null) {
                sb.append(((ISerializableSyncItem)o).getType());
                sb.append("!!!!");
                sb.append(data);
                sb.append("@@@@");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void fromSerializableString(String s) {
        String[] sections;
        if (s.indexOf("%%%%") < 0) {
            s = StringUtils.replace(s, "%%", "%%%%");
            s = StringUtils.replace(s, "@@", "@@@@");
            s = StringUtils.replace(s, "~~", "~~~~");
            s = StringUtils.replace(s, "!!", "!!!!");
        }
        if ((sections = s.split("~~~~")).length >= 1) {
            this.parseIVirtualFileManagers(sections[0]);
        }
        if (sections.length == 2) {
            this.parseVirtualFileManagerSyncItems(sections[1]);
        }
    }

    private void parseIVirtualFileManagers(String s) {
        HashMap<String, ArrayList<String>> dataTypes = new HashMap<String, ArrayList<String>>();
        String[] parts = s.split("@@@@");
        int i = 0;
        while (i < parts.length) {
            String item = parts[i];
            String[] itemParts = item.split("!!!!");
            if (itemParts.length == 2) {
                String type = itemParts[0];
                String data = itemParts[1];
                if (!"null".equals(type)) {
                    ArrayList<String> list = (ArrayList<String>)dataTypes.get(type);
                    if (list == null) {
                        list = new ArrayList<String>();
                        dataTypes.put(type, list);
                    }
                    list.add(data);
                }
            }
            ++i;
        }
        for (String type : dataTypes.keySet()) {
            ProtocolManager manager = ProtocolManager.getProtocolManagerByType(type);
            ArrayList dataTypeList = (ArrayList)dataTypes.get(type);
            if (manager != null) {
                for (String data : dataTypeList) {
                    IVirtualFileManager fileManager = manager.getStaticInstance().createFileManager();
                    fileManager.fromSerializableString(data);
                }
                continue;
            }
            String vfm = "";
            for (String data : dataTypeList) {
                vfm = String.valueOf(vfm) + type;
                vfm = String.valueOf(vfm) + "!!!!";
                vfm = String.valueOf(vfm) + data;
                vfm = String.valueOf(vfm) + "@@@@";
            }
            this.unknownItems.add(vfm);
        }
    }

    private void parseVirtualFileManagerSyncItems(String s) {
        String[] parts = s.split("@@@@");
        int i = 0;
        while (i < parts.length) {
            String item = parts[i];
            String[] itemParts = item.split("!!!!");
            if (itemParts.length == 2) {
                String type = itemParts[0];
                String data = itemParts[1];
                if (!"null".equals(type)) {
                    try {
                        VirtualFileManagerSyncPair vfm = new VirtualFileManagerSyncPair();
                        vfm.fromSerializableString(data);
                        this.items.add(vfm);
                        _syncManager.fireSyncManagerChangeEvent(vfm, 0);
                    }
                    catch (Exception ex) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), "Unable to deserialize virtaul file manager", ex);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public String getType() {
        return "com.aptana.ide.core.io.sync.SyncManager";
    }

    public IVirtualFileManager getVirtualFileManagerById(long id) {
        Object[] allItems = this.getItems();
        int i = 0;
        while (i < allItems.length) {
            IVirtualFileManager vfm;
            Object o = allItems[i];
            if (o instanceof IVirtualFileManager && (vfm = (IVirtualFileManager)o).getId() == id) {
                return vfm;
            }
            ++i;
        }
        return null;
    }

    public static VirtualFileManagerSyncPair[] getContainingSyncPairs(IVirtualFile file) {
        ArrayList<VirtualFileManagerSyncPair> mySyncConfigurations = new ArrayList<VirtualFileManagerSyncPair>();
        ArrayList relevantManagers = new ArrayList();
        IVirtualFileManager[] fms = SyncManager.getContainingFileManagers(file);
        relevantManagers.addAll(Arrays.asList(fms));
        Object[] scs = SyncManager.getSyncManager().getItems(VirtualFileManagerSyncPair.class);
        int i = 0;
        while (i < scs.length) {
            VirtualFileManagerSyncPair configuration = (VirtualFileManagerSyncPair)scs[i];
            if (relevantManagers.contains(configuration.getSourceFileManager())) {
                mySyncConfigurations.add(configuration);
            }
            ++i;
        }
        return mySyncConfigurations.toArray(new VirtualFileManagerSyncPair[mySyncConfigurations.size()]);
    }

    public static VirtualFileManagerSyncPair[] getContainingSyncPairs(IVirtualFile file, boolean valid) {
        VirtualFileManagerSyncPair[] confs = SyncManager.getContainingSyncPairs(file);
        if (valid) {
            ArrayList<VirtualFileManagerSyncPair> validPairs = new ArrayList<VirtualFileManagerSyncPair>();
            int i = 0;
            while (i < confs.length) {
                VirtualFileManagerSyncPair virtualFileManagerSyncPair = confs[i];
                if (virtualFileManagerSyncPair.isValid()) {
                    validPairs.add(virtualFileManagerSyncPair);
                }
                ++i;
            }
            return validPairs.toArray(new VirtualFileManagerSyncPair[0]);
        }
        return confs;
    }

    public static boolean isSyncPairEndpoint(IVirtualFileManager fileManager) {
        return SyncManager.getSyncPairs(fileManager).length > 0;
    }

    public static VirtualFileManagerSyncPair[] getSyncPairs(IVirtualFileManager fileManager) {
        Object[] scs = SyncManager.getSyncManager().getItems(VirtualFileManagerSyncPair.class);
        ArrayList<VirtualFileManagerSyncPair> syncPairs = new ArrayList<VirtualFileManagerSyncPair>();
        int i = 0;
        while (i < scs.length) {
            VirtualFileManagerSyncPair object = (VirtualFileManagerSyncPair)scs[i];
            if (object.getDestinationFileManager() != null && object.getDestinationFileManager().equals(fileManager) || object.getSourceFileManager() != null && object.getSourceFileManager().equals(fileManager)) {
                syncPairs.add(object);
            }
            ++i;
        }
        return syncPairs.toArray(new VirtualFileManagerSyncPair[0]);
    }

    public static boolean hasContainingSyncPair(IVirtualFile file) {
        VirtualFileManagerSyncPair[] confs = SyncManager.getContainingSyncPairs(file);
        return confs.length > 0;
    }

    public static IVirtualFileManager[] getContainingFileManagers(IVirtualFile file) {
        ArrayList<Object> relevantManagers = new ArrayList<Object>();
        Object[] objs = SyncManager.getSyncManager().getItems();
        int i = 0;
        while (i < objs.length) {
            Object object = objs[i];
            if (object instanceof IVirtualFileManager && ((IVirtualFileManager)object).containsFile(file)) {
                relevantManagers.add(object);
            }
            ++i;
        }
        return relevantManagers.toArray(new IVirtualFileManager[0]);
    }

    public static boolean isVirtualFileManager(IVirtualFile file) {
        Object[] objs = SyncManager.getSyncManager().getItems();
        int i = 0;
        while (i < objs.length) {
            IVirtualFileManager fileManager;
            Object object = objs[i];
            if (object instanceof IVirtualFileManager && (fileManager = (IVirtualFileManager)object).getBasePath() != null && fileManager.getBaseFile().equals(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IVirtualFileManager[] getContainingFileManagers(ProtocolManager protocolManager, IVirtualFile file) {
        ArrayList<IVirtualFileManager> relevantManagers = new ArrayList<IVirtualFileManager>();
        IVirtualFileManager[] fms = protocolManager.getFileManagers();
        int i = 0;
        while (i < fms.length) {
            IVirtualFileManager manager = fms[i];
            if (manager.containsFile(file)) {
                relevantManagers.add(manager);
            }
            ++i;
        }
        return relevantManagers.toArray(new IVirtualFileManager[0]);
    }
}

