/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.resources.IUniformResource;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class PathUtils {
    private PathUtils() {
    }

    public static String getPath(Object element) {
        if (element instanceof IUniformResource) {
            IStorage storage;
            IUniformResource resource = (IUniformResource)element;
            IPath path = (IPath)resource.getAdapter(IPath.class);
            if (path == null && (storage = (IStorage)resource.getAdapter(IStorage.class)) != null) {
                path = (IPath)storage.getAdapter(IPath.class);
            }
            if (path != null) {
                return path.toOSString();
            }
            return resource.getURI().toString();
        }
        if (element instanceof String) {
            try {
                element = new URI((String)element);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (element instanceof URI) {
            URI uri = (URI)element;
            if ("file".equals(uri.getScheme())) {
                return uri.getSchemeSpecificPart();
            }
            return uri.toString();
        }
        return null;
    }

    public static IFile findWorkspaceFile(String filePath) {
        Path path = new Path(filePath);
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (resource instanceof IFile) {
            return resource;
        }
        return null;
    }
}

