/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.PrintWriter;
import java.sql.SQLException;
import org.ibex.nestedvm.Runtime;
import org.sqlite.DB;
import org.sqlite.Function;

final class NestedDB
extends DB
implements Runtime.CallJavaCB {
    int handle = 0;
    private Runtime rt = null;
    private Function[] functions = null;
    private String[] funcNames = null;
    private final int[] p0 = new int[0];
    private final int[] p1 = new int[]{0};
    private final int[] p2 = new int[]{0, 0};
    private final int[] p3 = new int[]{0, 0, 0};
    private final int[] p4 = new int[]{0, 0, 0, 0};
    private final int[] p5 = new int[]{0, 0, 0, 0, 0};

    NestedDB() {
    }

    synchronized void open(String string) throws SQLException {
        if (this.handle != 0) {
            throw new SQLException("DB already open");
        }
        if (this.rt != null) {
            throw new SQLException("DB closed but runtime exists");
        }
        if (string.length() > 2) {
            char c = Character.toLowerCase(string.charAt(0));
            if (string.charAt(1) == ':' && c >= 'a' && c <= 'z') {
                string = string.substring(2);
                string = string.replace('\\', '/');
                string = "/" + c + ":" + string;
            }
        }
        try {
            this.rt = (Runtime)Class.forName("org.sqlite.SQLite").newInstance();
            this.rt.start();
        }
        catch (Exception exception) {
            throw new CausedSQLException(exception);
        }
        this.rt.setCallJavaCB(this);
        int n = this.rt.xmalloc(4);
        int n2 = this.rt.strdup(string);
        if (this.call("sqlite3_open", n2, n) != 0) {
            this.throwex();
        }
        this.handle = this.deref(n);
        this.rt.free(n2);
        this.rt.free(n);
    }

    public int call(int n, int n2, int n3, int n4) {
        this.xUDF(n, n2, n3, n4);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _close() throws SQLException {
        if (this.handle == 0) {
            return;
        }
        try {
            if (this.call("sqlite3_close", this.handle) != 0) {
                this.throwex();
            }
        }
        finally {
            this.handle = 0;
            this.rt.stop();
            this.rt = null;
        }
    }

    synchronized void interrupt() throws SQLException {
        this.call("sqlite3_interrupt", this.handle);
    }

    synchronized void busy_timeout(int n) throws SQLException {
        this.call("sqlite3_busy_timeout", this.handle, n);
    }

    protected synchronized long prepare(String string) throws SQLException {
        int n = this.rt.xmalloc(4);
        int n2 = this.rt.strdup(string);
        int n3 = this.call("sqlite3_prepare", this.handle, n2, -1, n, 0);
        this.rt.free(n2);
        if (n3 != 0) {
            this.rt.free(n);
            this.throwex();
        }
        int n4 = this.deref(n);
        this.rt.free(n);
        return n4;
    }

    synchronized String errmsg() throws SQLException {
        return this.cstring(this.call("sqlite3_errmsg", this.handle));
    }

    synchronized String libversion() throws SQLException {
        return this.cstring(this.call("sqlite3_libversion", this.handle));
    }

    synchronized int changes() throws SQLException {
        return this.call("sqlite3_changes", this.handle);
    }

    protected synchronized int finalize(long l) throws SQLException {
        return this.call("sqlite3_finalize", (int)l);
    }

    protected synchronized int step(long l) throws SQLException {
        return this.call("sqlite3_step", (int)l);
    }

    protected synchronized int reset(long l) throws SQLException {
        return this.call("sqlite3_reset", (int)l);
    }

    synchronized int clear_bindings(long l) throws SQLException {
        return this.call("sqlite3_clear_bindings", (int)l);
    }

    synchronized int bind_parameter_count(long l) throws SQLException {
        return this.call("sqlite3_bind_parameter_count", (int)l);
    }

    synchronized int column_count(long l) throws SQLException {
        return this.call("sqlite3_column_count", (int)l);
    }

    synchronized int column_type(long l, int n) throws SQLException {
        return this.call("sqlite3_column_type", (int)l, n);
    }

    synchronized String column_name(long l, int n) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_name", (int)l, n));
    }

    synchronized String column_text(long l, int n) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_text", (int)l, n));
    }

    synchronized byte[] column_blob(long l, int n) throws SQLException {
        byte[] byArray = new byte[this.call("sqlite3_column_bytes", (int)l, n)];
        int n2 = this.call("sqlite3_column_blob", (int)l, n);
        this.copyin(n2, byArray, byArray.length);
        return byArray;
    }

    synchronized double column_double(long l, int n) throws SQLException {
        try {
            return Double.parseDouble(this.column_text(l, n));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    synchronized long column_long(long l, int n) throws SQLException {
        try {
            return Long.parseLong(this.column_text(l, n));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    synchronized int column_int(long l, int n) throws SQLException {
        return this.call("sqlite3_column_int", (int)l, n);
    }

    synchronized String column_decltype(long l, int n) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_decltype", (int)l, n));
    }

    synchronized String column_table_name(long l, int n) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_table_name", (int)l, n));
    }

    synchronized int bind_null(long l, int n) throws SQLException {
        return this.call("sqlite3_bind_null", (int)l, n);
    }

    synchronized int bind_int(long l, int n, int n2) throws SQLException {
        return this.call("sqlite3_bind_int", (int)l, n, n2);
    }

    synchronized int bind_long(long l, int n, long l2) throws SQLException {
        return this.bind_text(l, n, Long.toString(l2));
    }

    synchronized int bind_double(long l, int n, double d) throws SQLException {
        return this.bind_text(l, n, Double.toString(d));
    }

    synchronized int bind_text(long l, int n, String string) throws SQLException {
        if (string == null) {
            return this.bind_null(l, n);
        }
        return this.call("sqlite3_bind_text", (int)l, n, this.rt.strdup(string), -1, this.rt.lookupSymbol("free"));
    }

    synchronized int bind_blob(long l, int n, byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length < 1) {
            return this.bind_null(l, n);
        }
        int n2 = byArray.length;
        int n3 = this.rt.xmalloc(n2);
        this.copyout(byArray, n3, n2);
        return this.call("sqlite3_bind_blob", (int)l, n, n3, n2, this.rt.lookupSymbol("free"));
    }

    synchronized void result_null(long l) throws SQLException {
        this.call("sqlite3_result_null", (int)l);
    }

    synchronized void result_text(long l, String string) throws SQLException {
        this.call("sqlite3_result_text", (int)l, this.rt.strdup(string), -1, this.rt.lookupSymbol("free"));
    }

    synchronized void result_blob(long l, byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            this.result_null(l);
            return;
        }
        int n = this.rt.xmalloc(byArray.length);
        this.copyout(byArray, n, byArray.length);
        this.call("sqlite3_result_blob", (int)l, n, byArray.length, this.rt.lookupSymbol("free"));
    }

    synchronized void result_double(long l, double d) throws SQLException {
        this.result_text(l, Double.toString(d));
    }

    synchronized void result_long(long l, long l2) throws SQLException {
        this.result_text(l, Long.toString(l2));
    }

    synchronized void result_int(long l, int n) throws SQLException {
        this.call("sqlite3_result_int", (int)l, n);
    }

    synchronized void result_error(long l, String string) throws SQLException {
        int n = this.rt.strdup(string);
        this.call("sqlite3_result_error", (int)l, n, -1);
        this.rt.free(n);
    }

    synchronized int value_bytes(Function function, int n) throws SQLException {
        return this.call("sqlite3_value_bytes", this.value(function, n));
    }

    synchronized String value_text(Function function, int n) throws SQLException {
        return this.utfstring(this.call("sqlite3_value_text", this.value(function, n)));
    }

    synchronized byte[] value_blob(Function function, int n) throws SQLException {
        byte[] byArray = new byte[this.value_bytes(function, n)];
        int n2 = this.call("sqlite3_value_blob", this.value(function, n));
        this.copyin(n2, byArray, byArray.length);
        return byArray;
    }

    synchronized double value_double(Function function, int n) throws SQLException {
        return Double.parseDouble(this.value_text(function, n));
    }

    synchronized long value_long(Function function, int n) throws SQLException {
        return Long.parseLong(this.value_text(function, n));
    }

    synchronized int value_int(Function function, int n) throws SQLException {
        return this.call("sqlite3_value_int", this.value(function, n));
    }

    synchronized int value_type(Function function, int n) throws SQLException {
        return this.call("sqlite3_value_type", this.value(function, n));
    }

    private int value(Function function, int n) throws SQLException {
        return this.deref((int)function.value + n * 4);
    }

    synchronized int create_function(String string, Function function) throws SQLException {
        int n;
        if (this.functions == null) {
            this.functions = new Function[10];
            this.funcNames = new String[10];
        }
        for (n = 0; n < this.functions.length && this.functions[n] != null; ++n) {
        }
        if (n == this.functions.length) {
            Function[] functionArray = new Function[this.functions.length * 2];
            String[] stringArray = new String[this.funcNames.length * 2];
            System.arraycopy(this.functions, 0, functionArray, 0, this.functions.length);
            System.arraycopy(this.funcNames, 0, stringArray, 0, this.funcNames.length);
            this.functions = functionArray;
            this.funcNames = stringArray;
        }
        this.functions[n] = function;
        this.funcNames[n] = string;
        int n2 = this.rt.strdup(string);
        int n3 = this.call("create_function_helper", this.handle, n2, n, function instanceof Function.Aggregate ? 1 : 0);
        this.rt.free(n2);
        return n3;
    }

    synchronized int destroy_function(String string) throws SQLException {
        int n;
        if (string == null) {
            return 0;
        }
        for (n = 0; n < this.funcNames.length && !string.equals(this.funcNames[n]); ++n) {
        }
        if (n == this.funcNames.length) {
            return 0;
        }
        this.functions[n] = null;
        this.funcNames[n] = null;
        int n2 = this.rt.strdup(string);
        int n3 = this.call("create_function_helper", this.handle, n2, -1, 0);
        this.rt.free(n2);
        return n3;
    }

    synchronized void free_functions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void xUDF(int n, int n2, int n3, int n4) {
        Function function = null;
        try {
            int n5 = this.call("sqlite3_user_data", n2);
            function = this.functions[n5];
            if (function == null) {
                throw new SQLException("function state inconsistent");
            }
            function.context = n2;
            function.value = n4;
            function.args = n3;
            switch (n) {
                case 1: {
                    function.xFunc();
                    return;
                }
                case 2: {
                    ((Function.Aggregate)function).xStep();
                    return;
                }
                case 3: {
                    ((Function.Aggregate)function).xFinal();
                    return;
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            try {
                String string = sQLException.toString();
                if (string == null) {
                    string = "unknown error";
                }
                int n6 = this.rt.strdup(string);
                this.call("sqlite3_result_error", n2, n6, -1);
                this.rt.free(n6);
                return;
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                return;
            }
        }
        finally {
            if (function != null) {
                function.context = 0L;
                function.value = 0L;
                function.args = 0;
            }
        }
    }

    synchronized boolean[][] column_metadata(long l) throws SQLException {
        int n = this.call("sqlite3_column_count", (int)l);
        boolean[][] blArray = new boolean[n][3];
        int n2 = this.rt.xmalloc(12);
        for (int i = 0; i < n; ++i) {
            this.call("column_metadata_helper", this.handle, (int)l, i, n2);
            blArray[i][0] = this.deref(n2) == 1;
            blArray[i][1] = this.deref(n2 + 4) == 1;
            blArray[i][2] = this.deref(n2 + 8) == 1;
        }
        this.rt.free(n2);
        return blArray;
    }

    private int call(String string, int n) throws SQLException {
        this.p1[0] = n;
        return this.call(string, this.p1);
    }

    private int call(String string, int n, int n2) throws SQLException {
        this.p2[0] = n;
        this.p2[1] = n2;
        return this.call(string, this.p2);
    }

    private int call(String string, int n, int n2, int n3) throws SQLException {
        this.p3[0] = n;
        this.p3[1] = n2;
        this.p3[2] = n3;
        return this.call(string, this.p3);
    }

    private int call(String string, int n, int n2, int n3, int n4) throws SQLException {
        this.p4[0] = n;
        this.p4[1] = n2;
        this.p4[2] = n3;
        this.p4[3] = n4;
        return this.call(string, this.p4);
    }

    private int call(String string, int n, int n2, int n3, int n4, int n5) throws SQLException {
        this.p5[0] = n;
        this.p5[1] = n2;
        this.p5[2] = n3;
        this.p5[3] = n4;
        this.p5[4] = n5;
        return this.call(string, this.p5);
    }

    private int call(String string, int[] nArray) throws SQLException {
        try {
            return this.rt.call(string, nArray);
        }
        catch (Runtime.CallException callException) {
            throw new CausedSQLException(callException);
        }
    }

    private int deref(int n) throws SQLException {
        try {
            return this.rt.memRead(n);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private String utfstring(int n) throws SQLException {
        try {
            return this.rt.utfstring(n);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private String cstring(int n) throws SQLException {
        try {
            return this.rt.cstring(n);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private void copyin(int n, byte[] byArray, int n2) throws SQLException {
        try {
            this.rt.copyin(n, byArray, n2);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private void copyout(byte[] byArray, int n, int n2) throws SQLException {
        try {
            this.rt.copyout(byArray, n, n2);
        }
        catch (Runtime.FaultException faultException) {
            throw new CausedSQLException(faultException);
        }
    }

    private static final class CausedSQLException
    extends SQLException {
        private final Exception cause;

        CausedSQLException(Exception exception) {
            if (exception == null) {
                throw new RuntimeException("null exception cause");
            }
            this.cause = exception;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public void printStackTrace() {
            this.cause.printStackTrace();
        }

        public void printStackTrace(PrintWriter printWriter) {
            this.cause.printStackTrace(printWriter);
        }

        public Throwable fillInStackTrace() {
            return this.cause.fillInStackTrace();
        }

        public StackTraceElement[] getStackTrace() {
            return this.cause.getStackTrace();
        }

        public String getMessage() {
            return this.cause.getMessage();
        }
    }
}

