/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2x;

import SQLite.BusyHandler;
import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC2x.DatabaseX;
import SQLite.JDBC2x.JDBCDatabaseMetaData;
import SQLite.JDBC2x.JDBCPreparedStatement;
import SQLite.JDBC2x.JDBCStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;

public class JDBCConnection
implements Connection,
BusyHandler {
    protected DatabaseX db;
    protected String url;
    protected String enc;
    protected Vector stmts;
    protected boolean autocommit = true;
    protected boolean intrans = false;
    protected int timeout = 1000000;
    private String dbfile = null;
    private JDBCDatabaseMetaData meta = null;
    private long t0;
    private boolean readonly = false;

    private boolean busy0(DatabaseX databaseX, int n) {
        if (n <= 1) {
            this.t0 = System.currentTimeMillis();
        }
        if (databaseX != null) {
            long l = System.currentTimeMillis();
            if (l - this.t0 > (long)this.timeout) {
                return false;
            }
            databaseX.wait(100);
            return true;
        }
        return false;
    }

    public boolean busy(String string, int n) {
        return this.busy0(this.db, n);
    }

    private DatabaseX open(boolean bl) throws SQLException {
        DatabaseX databaseX = null;
        try {
            databaseX = new DatabaseX();
            databaseX.open(this.dbfile, bl ? 292 : 420);
            databaseX.set_encoding(this.enc);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        int n = 0;
        while (true) {
            try {
                databaseX.exec("PRAGMA full_column_names = on;", null);
                databaseX.exec("PRAGMA empty_result_callbacks = on;", null);
                if (Database.version().compareTo("2.6.0") < 0) break;
                databaseX.exec("PRAGMA show_datatypes = on;", null);
            }
            catch (Exception exception) {
                if (databaseX.last_error() == 5 && this.busy0(databaseX, ++n)) continue;
                try {
                    databaseX.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new SQLException(exception.toString());
            }
            break;
        }
        return databaseX;
    }

    public JDBCConnection(String string, String string2) throws SQLException {
        if (string.startsWith("sqlite:/")) {
            this.dbfile = string.substring(8);
        } else if (string.startsWith("jdbc:sqlite:/")) {
            this.dbfile = string.substring(13);
        } else {
            throw new SQLException("unsupported url");
        }
        this.url = string;
        this.enc = string2;
        try {
            this.db = this.open(this.readonly);
            this.db.busy_handler(this);
        }
        catch (SQLException sQLException) {
            if (this.db != null) {
                try {
                    this.db.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw sQLException;
        }
        this.stmts = new Vector();
    }

    public Statement createStatement() {
        JDBCStatement jDBCStatement = new JDBCStatement(this);
        this.stmts.addElement(jDBCStatement);
        return jDBCStatement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (n2 != 1007) {
            throw new SQLException("only CONCUR_READ_ONLY supported");
        }
        JDBCStatement jDBCStatement = new JDBCStatement(this);
        this.stmts.addElement(jDBCStatement);
        return jDBCStatement;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.meta == null) {
            this.meta = new JDBCDatabaseMetaData(this);
        }
        return this.meta;
    }

    public void close() throws SQLException {
        try {
            this.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.intrans = false;
        for (int i = 0; i < this.stmts.size(); ++i) {
            ((JDBCStatement)this.stmts.elementAt(i)).close();
        }
        this.stmts.removeAllElements();
        if (this.db != null) {
            try {
                this.db.close();
                this.db = null;
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
    }

    public boolean isClosed() throws SQLException {
        return this.db == null;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readonly;
    }

    public void clearWarnings() throws SQLException {
    }

    public void commit() throws SQLException {
        if (this.db == null) {
            throw new SQLException("stale connection");
        }
        if (!this.intrans) {
            return;
        }
        try {
            this.db.exec("COMMIT", null);
            this.intrans = false;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public int getTransactionIsolation() throws SQLException {
        return 1;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public String nativeSQL(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        JDBCPreparedStatement jDBCPreparedStatement = new JDBCPreparedStatement(this, string);
        this.stmts.addElement(jDBCPreparedStatement);
        return jDBCPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (n2 != 1007) {
            throw new SQLException("only CONCUR_READ_ONLY supported");
        }
        JDBCPreparedStatement jDBCPreparedStatement = new JDBCPreparedStatement(this, string);
        this.stmts.addElement(jDBCPreparedStatement);
        return jDBCPreparedStatement;
    }

    public void rollback() throws SQLException {
        if (this.db == null) {
            throw new SQLException("stale connection");
        }
        if (!this.intrans) {
            return;
        }
        try {
            this.db.exec("ROLLBACK", null);
            this.intrans = false;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (bl && this.intrans && this.db != null) {
            try {
                this.db.exec("ROLLBACK", null);
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
        this.intrans = false;
        this.autocommit = bl;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.intrans) {
            throw new SQLException("incomplete transaction");
        }
        if (bl != this.readonly) {
            DatabaseX databaseX = null;
            try {
                databaseX = this.open(bl);
                this.db.close();
                this.db = databaseX;
                databaseX = null;
                this.readonly = bl;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                if (databaseX != null) {
                    try {
                        databaseX.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                throw new SQLException(exception.toString());
            }
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 1) {
            throw new SQLException("not supported");
        }
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public void setHoldability(int n) throws SQLException {
        if (n == 1) {
            return;
        }
        throw new SQLException("not supported");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("not supported");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("not supported");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("not supported");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 != 1) {
            throw new SQLException("not supported");
        }
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != 1) {
            throw new SQLException("not supported");
        }
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("not supported");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n != 2) {
            throw new SQLException("not supported");
        }
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("not supported");
    }
}

