/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.util;

import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.IUniformResourceMarker;
import com.aptana.ide.core.resources.UniformResourceStorage;
import com.aptana.ide.debug.internal.ui.LocalFileStorageEditorInput;
import com.aptana.ide.debug.internal.ui.UniformResourceStorageEditorInput;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class SourceDisplayUtil {
    private SourceDisplayUtil() {
    }

    public static IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            IMarker marker = ((ILineBreakpoint)element).getMarker();
            if (marker instanceof IUniformResourceMarker) {
                IUniformResource resource = ((IUniformResourceMarker)marker).getUniformResource();
                element = resource.getAdapter(IStorage.class);
                if (element == null) {
                    element = resource;
                }
            } else {
                return new FileEditorInput((IFile)marker.getResource());
            }
        }
        if (element instanceof LocalFileStorage) {
            return new LocalFileStorageEditorInput((IStorage)((LocalFileStorage)element));
        }
        if (element instanceof UniformResourceStorage) {
            if (((UniformResourceStorage)element).getFullPath() != null) {
                return new LocalFileStorageEditorInput((IStorage)((UniformResourceStorage)element));
            }
            if (((UniformResourceStorage)element).exists()) {
                return new UniformResourceStorageEditorInput((UniformResourceStorage)element);
            }
            return null;
        }
        if (element instanceof IAdaptable) {
            return (IEditorInput)((IAdaptable)element).getAdapter(IEditorInput.class);
        }
        return null;
    }

    public static String getEditorId(IEditorInput input, Object element) {
        try {
            UniformResourceStorage storage;
            URI uri;
            String scheme;
            if (input instanceof UniformResourceStorageEditorInput && ("http".equals(scheme = (uri = (storage = (UniformResourceStorage)((UniformResourceStorageEditorInput)input).getStorage()).getURI()).getScheme()) || "https".equals(scheme))) {
                return IDE.getEditorDescriptor((String)(String.valueOf(input.getName()) + ".html")).getId();
            }
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public static void openInEditor(IEditorInput input, int lineNumber) throws PartInitException {
        SourceDisplayUtil.openInEditor(DebugUiPlugin.getActivePage(), input, lineNumber);
    }

    public static void openInEditor(IWorkbenchPage page, IEditorInput input, int lineNumber) throws PartInitException {
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)SourceDisplayUtil.getEditorId(input, null));
        SourceDisplayUtil.revealLineInEditor(editorPart, lineNumber);
    }

    public static void revealLineInEditor(IEditorPart editorPart, int lineNumber) {
        IWorkbenchPage page;
        if (lineNumber > 0) {
            ITextEditor textEditor = null;
            textEditor = editorPart instanceof ITextEditor ? (ITextEditor)editorPart : (ITextEditor)editorPart.getAdapter(ITextEditor.class);
            if (textEditor != null) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                try {
                    try {
                        IRegion line = document.getLineInformation(lineNumber - 1);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    provider.disconnect((Object)document);
                }
            }
        }
        if (!(page = editorPart.getSite().getPage()).isPartVisible((IWorkbenchPart)editorPart)) {
            page.activate((IWorkbenchPart)editorPart);
        }
    }

    public static IEditorPart findEditor(IEditorInput input) {
        return DebugUiPlugin.getActivePage().findEditor(input);
    }

    public static void displaySource(Object context, boolean forceSourceLookup) {
        SourceDisplayUtil.displaySource(context, DebugUiPlugin.getActivePage(), forceSourceLookup);
    }

    public static void displaySource(Object context, IWorkbenchPage page, boolean forceSourceLookup) {
        SourceLookupManager.getDefault().displaySource(context, page, forceSourceLookup);
    }
}

