/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.launchConfigurations;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.PixelConverter;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.debug.core.JSDebugOptionsManager;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.internal.ui.dialogs.HttpServerPathDialog;
import com.aptana.ide.debug.internal.ui.launchConfigurations.Messages;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class HttpServerSettingsTab
extends AbstractLaunchConfigurationTab {
    private Image image;
    private CheckboxTableViewer fListViewer;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private List<PathElement> elements;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.HttpServerSettingsTab_WebServerPathConfiguration);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.fListViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67618);
        Table table = this.fListViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn[] columns = new TableColumn[]{new TableColumn(table, 0), new TableColumn(table, 0), new TableColumn(table, 0)};
        columns[1].setText(Messages.HttpServerSettingsTab_ServerPath);
        columns[2].setText(Messages.HttpServerSettingsTab_WorkspacePath);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(24));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        table.setLayout((Layout)tableLayout);
        this.fListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        table.setFont(parent.getFont());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddButton = new Button(buttonContainer, 8);
        this.fAddButton.setText(StringUtils.ellipsify((String)Messages.HttpServerSettingsTab_Add));
        this.fAddButton.setToolTipText(Messages.HttpServerSettingsTab_AddServerPath);
        this.fAddButton.setFont(parent.getFont());
        GridData data = new GridData(4, -1);
        data.widthHint = Math.max(new PixelConverter((Control)this.fAddButton).convertHorizontalDLUsToPixels(61), this.fAddButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fAddButton.setLayoutData((Object)data);
        this.fEditButton = new Button(buttonContainer, 8);
        this.fEditButton.setText(StringUtils.ellipsify((String)Messages.HttpServerSettingsTab_Edit));
        this.fEditButton.setToolTipText(Messages.HttpServerSettingsTab_EditSelectedPath);
        this.fEditButton.setFont(parent.getFont());
        data = new GridData(4, -1);
        data.widthHint = Math.max(new PixelConverter((Control)this.fEditButton).convertHorizontalDLUsToPixels(61), this.fEditButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fEditButton.setLayoutData((Object)data);
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.fRemoveButton.setText(Messages.HttpServerSettingsTab_Remove);
        this.fRemoveButton.setToolTipText(Messages.HttpServerSettingsTab_RemoveSelectedPath);
        this.fRemoveButton.setFont(parent.getFont());
        data = new GridData(4, -1);
        data.widthHint = Math.max(new PixelConverter((Control)this.fRemoveButton).convertHorizontalDLUsToPixels(61), this.fRemoveButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fRemoveButton.setLayoutData((Object)data);
        this.fListViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((PathElement)event.getElement()).enabled = event.getChecked();
                HttpServerSettingsTab.this.setDirty(true);
                HttpServerSettingsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HttpServerSettingsTab.this.updatePage((IStructuredSelection)event.getSelection());
            }
        });
        this.fListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    HttpServerSettingsTab.this.editPath();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    HttpServerSettingsTab.this.removePaths();
                }
            }
        });
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HttpServerSettingsTab.this.addPath();
            }
        });
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HttpServerSettingsTab.this.editPath();
            }
        });
        this.fEditButton.setEnabled(false);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HttpServerSettingsTab.this.removePaths();
            }
        });
        this.fRemoveButton.setEnabled(false);
        this.setControl((Control)composite);
        PreferenceUtils.persist((IPreferenceStore)DebugUiPlugin.getDefault().getPreferenceStore(), (Table)table, (String)"httpServerSettings");
    }

    private void addPath() {
        HttpServerPathDialog dlg = new HttpServerPathDialog(this.getShell(), Messages.HttpServerSettingsTab_AddNewPath);
        if (dlg.open() == 0) {
            PathElement element = new PathElement(true, dlg.getServerPath(), dlg.getWorkspaceResource().getFullPath().toPortableString());
            this.elements.add(element);
            this.fListViewer.refresh();
            this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            this.refreshViewer();
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void editPath() {
        PathElement element = (PathElement)((IStructuredSelection)this.fListViewer.getSelection()).getFirstElement();
        if (element == null) {
            return;
        }
        HttpServerPathDialog dlg = new HttpServerPathDialog(this.getShell(), Messages.HttpServerSettingsTab_EditPath);
        dlg.setServerPath(element.serverPath);
        dlg.setWorkspaceResource(ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(element.localPath)));
        if (dlg.open() == 0) {
            element.serverPath = dlg.getServerPath();
            element.localPath = dlg.getWorkspaceResource().getFullPath().toPortableString();
            element.enabled = true;
            this.fListViewer.update((Object)element, null);
            this.refreshViewer();
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void removePaths() {
        IStructuredSelection selection = (IStructuredSelection)this.fListViewer.getSelection();
        Object first = selection.getFirstElement();
        int index = -1;
        int i = 0;
        while (i < this.elements.size()) {
            PathElement object = this.elements.get(i);
            if (object.equals(first)) {
                index = i;
                break;
            }
            ++i;
        }
        this.elements.removeAll(selection.toList());
        if (index > this.elements.size() - 1) {
            index = this.elements.size() - 1;
        }
        if (index >= 0) {
            this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)this.elements.get(index)));
        }
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private void refreshViewer() {
        ArrayList<PathElement> checkedElements = new ArrayList<PathElement>();
        for (PathElement pathElement : this.elements) {
            if (!pathElement.enabled) continue;
            checkedElements.add(pathElement);
        }
        this.fListViewer.setAllChecked(false);
        this.fListViewer.setCheckedElements((Object[])checkedElements.toArray(new PathElement[checkedElements.size()]));
    }

    private void updatePage(IStructuredSelection selection) {
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        this.fEditButton.setEnabled(selection.size() == 1);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("pathsMapping", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String[] list = JSDebugOptionsManager.parseList((String)configuration.getAttribute("pathsMapping", ""));
            this.elements = new ArrayList<PathElement>();
            int i = 0;
            int length = list.length;
            while (i < length) {
                String serverPath = list[i++];
                String localPath = list[i++];
                boolean enabled = !"0".equals(list[i++]);
                this.elements.add(new PathElement(enabled, serverPath, localPath));
            }
            this.fListViewer.setInput(this.elements);
            this.refreshViewer();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String[] values = new String[this.elements.size() * 3];
        int index = 0;
        for (PathElement element : this.elements) {
            values[index++] = element.serverPath;
            values[index++] = element.localPath;
            String string = values[index++] = element.enabled ? "1" : "0";
        }
        configuration.setAttribute("pathsMapping", JSDebugOptionsManager.serializeList((String[])values));
    }

    public String getName() {
        return Messages.HttpServerSettingsTab_Title;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = DebugUiPlugin.getImageDescriptor("icons/full/obj16/launch-tree.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    private class PathElement {
        protected boolean enabled;
        protected String serverPath;
        protected String localPath;

        protected PathElement(boolean enabled, String serverPath, String localPath) {
            this.enabled = enabled;
            this.serverPath = serverPath;
            this.localPath = localPath;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PathElement) {
                PathElement pathElement = (PathElement)element;
                switch (columnIndex) {
                    case 1: {
                        return pathElement.serverPath;
                    }
                    case 2: {
                        return pathElement.localPath;
                    }
                }
            }
            return null;
        }
    }
}

