/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.hovers;

import com.aptana.ide.debug.core.model.IJSStackFrame;
import com.aptana.ide.debug.internal.ui.hovers.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;

public class JSDebugHover
implements ITextHover,
ITextHoverExtension {
    private IDebugModelPresentation modelPresentation;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document;
        IJSStackFrame frame = this.getFrame();
        if (frame != null && (document = textViewer.getDocument()) != null) {
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                try {
                    IVariable variable = frame.findVariable(variableName);
                    if (variable != null) {
                        return this.getVariableText(variable);
                    }
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, null, Messages.JSDebugHover_PressF2ForFocus);
            }
        };
    }

    protected IJSStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IJSStackFrame)adaptable.getAdapter(IJSStackFrame.class);
        }
        return null;
    }

    private String getVariableText(IVariable variable) {
        StringBuffer buffer = new StringBuffer();
        IDebugModelPresentation modelPresentation = this.getModelPresentation();
        buffer.append("<p><pre>");
        String variableText = modelPresentation.getText((Object)variable);
        buffer.append(JSDebugHover.replaceHTMLChars(variableText));
        buffer.append("</pre></p>");
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuffer buffer = new StringBuffer(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private IDebugModelPresentation getModelPresentation() {
        if (this.modelPresentation == null) {
            this.modelPresentation = DebugUITools.newDebugModelPresentation((String)"com.aptana.ide.debug.core");
            this.modelPresentation.setAttribute(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES, (Object)Boolean.TRUE);
        }
        return this.modelPresentation;
    }
}

