/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.actions;

import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.debug.core.model.JSDebugModel;
import com.aptana.ide.debug.internal.ui.actions.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection) throws CoreException {
        Job job = new Job(Messages.ToggleBreakpointAdapter_ToggleLineBreakpoint){

            protected IStatus run(IProgressMonitor monitor) {
                if (selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    IEditorPart editorPart = (IEditorPart)part;
                    IEditorInput editorInput = editorPart.getEditorInput();
                    IResource resource = (IResource)editorInput.getAdapter(IFile.class);
                    IUniformResource uniformResource = null;
                    if (resource == null && (uniformResource = (IUniformResource)editorInput.getAdapter(IUniformResource.class)) == null) {
                        return Status.CANCEL_STATUS;
                    }
                    ITextSelection textSelection = (ITextSelection)selection;
                    int lineNumber = textSelection.getStartLine() + 1;
                    ILineBreakpoint breakpoint = resource != null ? JSDebugModel.lineBreakpointExists((IResource)resource, (int)lineNumber) : JSDebugModel.lineBreakpointExists((IUniformResource)uniformResource, (int)lineNumber);
                    try {
                        if (breakpoint != null) {
                            breakpoint.delete();
                        } else if (ToggleBreakpointAdapter.this.canToggleLineBreakpoint(part, selection)) {
                            if (resource != null) {
                                JSDebugModel.createLineBreakpoint((IResource)resource, (int)lineNumber);
                            } else {
                                JSDebugModel.createLineBreakpoint((IUniformResource)uniformResource, (int)lineNumber);
                            }
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    private boolean canToggleLineBreakpoint(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
            Object resource = editorInput.getAdapter(IFile.class);
            if (resource == null) {
                resource = editorInput.getAdapter(IUniformResource.class);
            }
            if (resource != null) {
                int lineNumber = ((ITextSelection)selection).getStartLine() + 1;
                if (resource instanceof IFile ? JSDebugModel.lineBreakpointExists((IResource)((IResource)resource), (int)lineNumber) != null : JSDebugModel.lineBreakpointExists((IUniformResource)((IUniformResource)resource), (int)lineNumber) != null) {
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

