/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.actions;

import com.aptana.ide.debug.core.model.IJSVariable;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ShowConstantsActionDelegate
extends ViewerFilter
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart fView;
    private IAction fAction;

    public void init(IViewPart view) {
        this.fView = view;
        StructuredViewer viewer = this.getStructuredViewer();
        ViewerFilter[] filters = viewer.getFilters();
        ViewerFilter filter = null;
        int i = 0;
        while (i < filters.length) {
            if (filters[i] == this) {
                filter = filters[i];
                break;
            }
            ++i;
        }
        if (filter == null) {
            viewer.addFilter((ViewerFilter)this);
        }
        viewer.refresh();
        this.fAction.setChecked(this.getPreferenceValue(view));
    }

    public void dispose() {
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        IPreferenceStore store = this.getPreferenceStore();
        String key = String.valueOf(this.fView.getSite().getId()) + "." + this.getPreferenceKey();
        store.setValue(key, action.isChecked());
        DebugUiPlugin.getDefault().savePluginPreferences();
        this.getStructuredViewer().refresh();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IJSVariable) {
            try {
                if (!this.getValue()) {
                    return !((IJSVariable)element).isConst();
                }
            }
            catch (DebugException e) {
                DebugUiPlugin.log(e);
            }
        }
        return true;
    }

    protected IPreferenceStore getPreferenceStore() {
        return DebugUiPlugin.getDefault().getPreferenceStore();
    }

    protected boolean getPreferenceValue(IViewPart part) {
        String baseKey = this.getPreferenceKey();
        String viewKey = part.getSite().getId();
        String compositeKey = String.valueOf(viewKey) + "." + baseKey;
        IPreferenceStore store = this.getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(baseKey);
        return value;
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.fView.getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected boolean getValue() {
        return this.fAction.isChecked();
    }

    protected String getPreferenceKey() {
        return "com.aptana.ide.debug.ui.show_constants";
    }
}

