/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.debug.core.DetailFormatter;
import com.aptana.ide.debug.core.JSDetailFormattersManager;
import com.aptana.ide.debug.core.model.IJSVariable;
import com.aptana.ide.debug.internal.ui.actions.ObjectActionDelegate;
import com.aptana.ide.debug.internal.ui.dialogs.DetailFormatterDialog;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class NewDetailFormatterAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        String typeName;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        try {
            if (!(element instanceof IJSVariable)) {
                return;
            }
            typeName = ((IJSVariable)element).getReferenceTypeName();
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
            return;
        }
        JSDetailFormattersManager detailFormattersManager = JSDetailFormattersManager.getDefault();
        DetailFormatter detailFormatter = new DetailFormatter(typeName, "", true);
        if (new DetailFormatterDialog(DebugUiPlugin.getActivePage().getWorkbenchWindow().getShell(), detailFormatter, null, true, false).open() == 0) {
            detailFormattersManager.setAssociatedDetailFormatter(detailFormatter);
            this.refreshCurrentSelection();
        }
    }
}

