/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PathUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.resources.IUniformResourceMarker;
import com.aptana.ide.debug.core.JSDebugPlugin;
import com.aptana.ide.debug.core.model.IJSDebugTarget;
import com.aptana.ide.debug.core.model.IJSExceptionBreakpoint;
import com.aptana.ide.debug.core.model.IJSImplicitBreakpoint;
import com.aptana.ide.debug.core.model.IJSLineBreakpoint;
import com.aptana.ide.debug.core.model.IJSScriptElement;
import com.aptana.ide.debug.core.model.IJSStackFrame;
import com.aptana.ide.debug.core.model.IJSVariable;
import com.aptana.ide.debug.core.model.IJSWatchpoint;
import com.aptana.ide.debug.core.model.ISourceLink;
import com.aptana.ide.debug.core.model.JSInspectExpression;
import com.aptana.ide.debug.internal.ui.DebugUIImages;
import com.aptana.ide.debug.internal.ui.JSDebugImageDescriptor;
import com.aptana.ide.debug.internal.ui.Messages;
import com.aptana.ide.debug.internal.ui.util.SourceDisplayUtil;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class JSDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private boolean showTypes = false;

    public void setAttribute(String attribute, Object value) {
        if (IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES.equals(attribute)) {
            this.showTypes = (Boolean)value;
        }
    }

    public String getText(Object element) {
        try {
            IBreakpoint breakpoint;
            if (element instanceof IStackFrame) {
                return this.getStackFrameText((IStackFrame)element);
            }
            if (element instanceof IThread) {
                return this.getThreadText((IThread)element);
            }
            if (element instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element);
            }
            if (element instanceof IJSScriptElement) {
                return this.getScriptElementText((IJSScriptElement)element);
            }
            if (element instanceof ISourceLink) {
                return ((ISourceLink)element).getLocation();
            }
            if (element instanceof IMarker && (breakpoint = this.getBreakpoint((IMarker)element)) != null) {
                return this.getBreakpointText(breakpoint);
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        return null;
    }

    public Image getImage(Object element) {
        try {
            if (element instanceof IVariable) {
                return this.getVariableImage((IVariable)element);
            }
            if (element instanceof IBreakpoint) {
                return this.getBreakpointImage((IBreakpoint)element);
            }
            if (element instanceof IJSScriptElement) {
                return this.getScriptElementImage((IJSScriptElement)element);
            }
            if (element instanceof IMarker) {
                IBreakpoint breakpoint = this.getBreakpoint((IMarker)element);
                if (breakpoint != null) {
                    return this.getBreakpointImage(breakpoint);
                }
            } else if (element instanceof JSInspectExpression) {
                return DebugUIImages.get("IMG_OBJS_INSPECT");
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)"", (Throwable)e);
        }
        return super.getImage(element);
    }

    private String getStackFrameText(IStackFrame frame) throws DebugException {
        String fileName;
        if (frame instanceof IJSStackFrame) {
            fileName = ((IJSStackFrame)frame).getSourceFileName();
            IFile file = PathUtils.findWorkspaceFile((String)fileName);
            if (file != null) {
                fileName = file.getFullPath().lastSegment();
            }
        } else {
            fileName = Messages.JSDebugModelPresentation_line;
        }
        int line = frame.getLineNumber();
        return StringUtils.format((String)"{0} [{1}:{2}]", (Object[])new String[]{frame.getName(), fileName, line >= 0 ? Integer.toString(line) : Messages.JSDebugModelPresentation_notavailable});
    }

    private String getThreadText(IThread thread) throws CoreException {
        String stateString = null;
        if (thread.isTerminated()) {
            stateString = Messages.JSDebugModelPresentation_Terminated;
        } else if (thread.isSuspended()) {
            stateString = Messages.JSDebugModelPresentation_Suspended;
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            if (breakpoints.length > 0) {
                IBreakpoint breakpoint = breakpoints[0];
                if (breakpoint instanceof IJSImplicitBreakpoint) {
                    String lineNumber;
                    IJSImplicitBreakpoint implicitBreakpoint = (IJSImplicitBreakpoint)breakpoint;
                    String fileName = implicitBreakpoint.getFileName();
                    IFile file = PathUtils.findWorkspaceFile((String)fileName);
                    if (file != null) {
                        fileName = file.getFullPath().toString();
                    }
                    try {
                        lineNumber = Integer.toString(implicitBreakpoint.getLineNumber());
                    }
                    catch (CoreException coreException) {
                        lineNumber = "-1";
                    }
                    String format = Messages.JSDebugModelPresentation_lineIn_0_1_2;
                    if (implicitBreakpoint.isDebuggerKeyword()) {
                        format = Messages.JSDebugModelPresentation_keywordAtLine_0_1_2;
                    } else if (implicitBreakpoint.isFirstLine()) {
                        format = Messages.JSDebugModelPresentation_atStartLine_0_1_2;
                    } else if (implicitBreakpoint.isException()) {
                        format = Messages.JSDebugModelPresentation_exceptionAtLine_0_1_2;
                    } else if (implicitBreakpoint.isWatchpoint()) {
                        format = Messages.JSDebugModelPresentation_watchpointAtLine_0_1_2;
                    }
                    stateString = StringUtils.format((String)format, (Object[])new String[]{stateString, lineNumber, fileName});
                } else {
                    String fileName;
                    IMarker marker = breakpoint.getMarker();
                    if (marker instanceof IUniformResourceMarker) {
                        fileName = PathUtils.getPath((Object)((IUniformResourceMarker)marker).getUniformResource());
                    } else if (marker.getResource() instanceof IWorkspaceRoot) {
                        URI uri = (URI)marker.getAttribute("com.aptana.ide.debug.core.breakpointLocation");
                        if ("file".equals(uri.getScheme())) {
                            fileName = PathUtils.getPath((Object)uri);
                            IFile file = PathUtils.findWorkspaceFile((String)fileName);
                            if (file != null) {
                                fileName = file.getFullPath().toString();
                            }
                        } else {
                            fileName = uri.toString();
                        }
                    } else {
                        fileName = marker.getResource().getFullPath().toString();
                    }
                    String lineNumber = Integer.toString(marker.getAttribute("lineNumber", -1));
                    stateString = breakpoint instanceof IJSLineBreakpoint && ((IJSLineBreakpoint)breakpoint).isRunToLine() ? StringUtils.format((String)Messages.JSDebugModelPresentation_runToLine_0_1_2, (Object[])new String[]{stateString, lineNumber, fileName}) : StringUtils.format((String)Messages.JSDebugModelPresentation_breakpointAtLine_0_1_2, (Object[])new String[]{stateString, lineNumber, fileName});
                }
            }
        } else {
            stateString = thread.isStepping() ? Messages.JSDebugModelPresentation_Stepping : Messages.JSDebugModelPresentation_Running;
        }
        if (stateString != null) {
            return StringUtils.format((String)"{0} ({1})", (Object[])new String[]{thread.getName(), stateString});
        }
        return thread.getName();
    }

    private String getBreakpointText(IBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IJSExceptionBreakpoint) {
            return this.getExceptionBreakpointText((IJSExceptionBreakpoint)breakpoint);
        }
        if (breakpoint instanceof IJSWatchpoint) {
            return this.getWatchpointText((IJSWatchpoint)breakpoint);
        }
        StringBuffer label = new StringBuffer();
        IMarker marker = breakpoint.getMarker();
        if (marker instanceof IUniformResourceMarker) {
            label.append(PathUtils.getPath((Object)((IUniformResourceMarker)marker).getUniformResource()));
        } else {
            IResource resource = marker.getResource();
            if (resource != null) {
                label.append(resource.getFullPath().toString());
            }
        }
        if (breakpoint instanceof ILineBreakpoint) {
            try {
                int lineNumber = ((ILineBreakpoint)breakpoint).getLineNumber();
                label.append(StringUtils.format((String)" [{0}: {1}]", (Object[])new String[]{Messages.JSDebugModelPresentation_line, Integer.toString(lineNumber)}));
            }
            catch (CoreException coreException) {}
        }
        return label.toString();
    }

    private Image getBreakpointImage(IBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IJSExceptionBreakpoint) {
            return DebugUIImages.get("IMG_OBJS_JSEXCEPTION");
        }
        if (breakpoint instanceof IJSWatchpoint) {
            return DebugUIImages.get("IMG_OBJS_JSWATCHPOINT");
        }
        int flags = this.computeBreakpointAdornmentFlags(breakpoint);
        JSDebugImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? new JSDebugImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags) : new JSDebugImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags);
        return DebugUIImages.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
    }

    private int computeBreakpointAdornmentFlags(IBreakpoint breakpoint) {
        int flags = 0;
        try {
            if (breakpoint.isEnabled()) {
                flags |= 1;
            }
            if (breakpoint instanceof IJSLineBreakpoint && (((IJSLineBreakpoint)breakpoint).isConditionEnabled() || ((IJSLineBreakpoint)breakpoint).getHitCount() > 0)) {
                flags |= 2;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
        }
        return flags;
    }

    private String getExceptionBreakpointText(IJSExceptionBreakpoint breakpoint) throws CoreException {
        return StringUtils.format((String)Messages.JSDebugModelPresentation_Exception, (Object[])new String[]{breakpoint.getExceptionTypeName()});
    }

    private String getWatchpointText(IJSWatchpoint watchpoint) throws CoreException {
        return StringUtils.format((String)"{0}", (Object[])new String[]{watchpoint.getVariableName()});
    }

    private String getScriptElementText(IJSScriptElement scriptElement) throws CoreException {
        if (scriptElement.getParent() == null) {
            return scriptElement.getName();
        }
        return StringUtils.format((String)"{0}()", (Object[])new String[]{scriptElement.getName()});
    }

    private Image getScriptElementImage(IJSScriptElement scriptElement) {
        if (scriptElement.getParent() == null) {
            return DebugUIImages.get("IMG_OBJS_TOP_SCRIPT_ELEMENT");
        }
        return DebugUIImages.get("IMG_OBJS_SCRIPT_ELEMENT");
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        IDebugTarget target = value.getDebugTarget();
        if (target.isSuspended() && target instanceof IJSDebugTarget) {
            DetailsJob job = new DetailsJob(value, listener);
            job.schedule();
            return;
        }
        String details = "";
        try {
            details = value.getValueString();
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
        }
        listener.detailComputed(value, details);
    }

    public IEditorInput getEditorInput(Object element) {
        return SourceDisplayUtil.getEditorInput(element);
    }

    public String getEditorId(IEditorInput input, Object element) {
        return SourceDisplayUtil.getEditorId(input, element);
    }

    public String getVariableText(IVariable variable) {
        String varLabel = Messages.JSDebugModelPresentation_UnknownName;
        try {
            varLabel = variable.getName();
        }
        catch (DebugException debugException) {}
        String typeName = Messages.JSDebugModelPresentation_UnknownType;
        try {
            typeName = variable.getReferenceTypeName();
        }
        catch (DebugException debugException) {}
        IValue value = null;
        try {
            value = variable.getValue();
        }
        catch (DebugException debugException) {}
        String valueString = Messages.JSDebugModelPresentation_UnknownValue;
        if (value != null) {
            try {
                valueString = this.getValueText(value);
            }
            catch (DebugException debugException) {}
        }
        StringBuffer sb = new StringBuffer();
        if (this.showTypes) {
            sb.append(typeName).append(' ');
        }
        sb.append(varLabel);
        if (valueString.length() != 0) {
            sb.append("= ");
            sb.append(valueString);
        }
        return sb.toString();
    }

    protected String getValueText(IValue value) throws DebugException {
        String valueString = value.getValueString();
        return valueString;
    }

    protected Image getVariableImage(IVariable variable) throws DebugException {
        if (variable instanceof IJSVariable) {
            IJSVariable jsVar = (IJSVariable)variable;
            if (jsVar.isException()) {
                return DebugUIImages.get("IMG_OBJS_EXCEPTION_VARIABLE");
            }
            if (jsVar.isLocal()) {
                return DebugUIImages.get("IMG_OBJS_LOCAL_VARIABLE");
            }
            if (jsVar.isTopLevel()) {
                return DebugUIImages.get("IMG_OBJS_VARIABLE");
            }
            if (jsVar.isConst()) {
                return DebugUIImages.get("IMG_OBJS_CONSTANT_FIELD");
            }
            return DebugUIImages.get("IMG_OBJS_FIELD");
        }
        return null;
    }

    private IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    private final class DetailsJob
    extends Job {
        private IValue value;
        private IValueDetailListener listener;

        public DetailsJob(IValue value, IValueDetailListener listener) {
            super(Messages.JSDebugModelPresentation_DetailsComputing);
            this.setSystem(true);
            this.value = value;
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IJSDebugTarget target = (IJSDebugTarget)this.value.getDebugTarget();
            String details = "";
            try {
                details = target.computeValueDetails(this.value);
            }
            catch (DebugException e) {
                IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
            }
            this.listener.detailComputed(this.value, details);
            return Status.OK_STATUS;
        }
    }
}

