/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.io.file;

import com.aptana.ide.core.ui.io.file.DeleteResourceShortcutListener;
import java.util.Hashtable;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FilePlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "com.aptana.ide.io.file";
    private static final int DEFAULT_FILE_PERMISSIONS = 438;
    private static final int DEFAULT_DIRECTORY_PERMISSIONS = 511;
    private static FilePlugin plugin;
    private static Hashtable<String, Image> images;

    static {
        images = new Hashtable();
    }

    public FilePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DeleteResourceShortcutListener listener = new DeleteResourceShortcutListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        this.getPreferenceStore().setDefault("FilePermission", 438);
        this.getPreferenceStore().setDefault("DirectoryPermission", 511);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static FilePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = FilePlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }
}

