/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.ExceptionUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.IVirtualFileManagerDialog;
import com.aptana.ide.core.ui.dialogs.GenericDialog;
import com.aptana.ide.core.ui.io.file.Messages;
import com.aptana.ide.io.file.FilePlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class VirtualFileManagerLocationDialog
extends GenericDialog
implements IVirtualFileManagerDialog {
    private static final int ProgressInitalSleepDelay = 250;
    private IVirtualFileManager _item;
    private boolean _newItem = false;
    protected Shell shell;
    protected ProgressMonitorPart progressMonitorPart;

    public VirtualFileManagerLocationDialog(Shell parent, int style) {
        super(parent, style);
    }

    public VirtualFileManagerLocationDialog(Shell parent) {
        this(parent, 0);
    }

    protected void setUpdatedValues() {
    }

    protected boolean validateFields() {
        return false;
    }

    public void handleCancel() {
        if (this._newItem && this._item != null) {
            this._item.getProtocolManager().removeFileManager(this._item);
        }
        this._item = null;
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private boolean attemptConnection() throws InvocationTargetException, InterruptedException {
        if (this.progressMonitorPart == null) {
            throw new IllegalArgumentException(Messages.VirtualFileManagerLocationDialog_ProgressMonitorNullError);
        }
        ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.VirtualFileManagerLocationDialog_TryingToConnect, -1);
                Thread.sleep(250L);
                try {
                    try {
                        VirtualFileManagerLocationDialog.this._item.disconnect();
                        VirtualFileManagerLocationDialog.this._item.resolveBasePath();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, (boolean)true, (IProgressMonitor)this.progressMonitorPart, (Display)Display.getDefault());
        return true;
    }

    public boolean isNewItem() {
        return this._newItem;
    }

    public IVirtualFileManager getItem() {
        return this._item;
    }

    public void setItem(IVirtualFileManager vfm, boolean newItem) {
        this._item = vfm;
        this._newItem = newItem;
    }

    public IVirtualFileManager open() {
        return null;
    }

    protected class OkButtonSelectionAdapter
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            block7: {
                if (VirtualFileManagerLocationDialog.this.validateFields()) {
                    VirtualFileManagerLocationDialog.this.setUpdatedValues();
                    try {
                        VirtualFileManagerLocationDialog.this.attemptConnection();
                        VirtualFileManagerLocationDialog.this.shell.dispose();
                    }
                    catch (InvocationTargetException e1) {
                        String msg = null;
                        Throwable t = ExceptionUtils.getRootException((Throwable)e1);
                        if (t != null) {
                            msg = t.getMessage();
                        }
                        if (msg == null) {
                            msg = Messages.VirtualFileManagerLocationDialog_UnknownError;
                        }
                        String message = StringUtils.format((String)Messages.VirtualFileManagerLocationDialog_ConnectionErrorMessage, (String)msg);
                        IdeLog.logError((Plugin)FilePlugin.getDefault(), (String)message, (Throwable)t);
                        MessageDialog md = new MessageDialog(VirtualFileManagerLocationDialog.this.shell, Messages.VirtualFileManagerLocationDialog_ConnectionErrorTitle, null, message, 4, new String[]{CoreStrings.CONTINUE, CoreStrings.CANCEL}, 1);
                        if (md.open() == 0) {
                            VirtualFileManagerLocationDialog.this.shell.dispose();
                        }
                    }
                    catch (Exception e1) {
                        String message = StringUtils.format((String)Messages.VirtualFileManagerLocationDialog_ConnectionErrorMessage, (String)e1.getMessage());
                        IdeLog.logError((Plugin)FilePlugin.getDefault(), (String)message, (Throwable)e1);
                        MessageDialog md = new MessageDialog(VirtualFileManagerLocationDialog.this.shell, Messages.VirtualFileManagerLocationDialog_ConnectionErrorTitle, null, message, 4, new String[]{CoreStrings.CONTINUE, CoreStrings.CANCEL}, 1);
                        if (md.open() != 0) break block7;
                        VirtualFileManagerLocationDialog.this.shell.dispose();
                    }
                }
            }
        }
    }

    protected class TestButtonSelectionAdapter
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            if (!VirtualFileManagerLocationDialog.this.validateFields()) {
                return;
            }
            if (!e.widget.isDisposed()) {
                VirtualFileManagerLocationDialog.this.setUpdatedValues();
                ((Control)e.widget).setEnabled(false);
                try {
                    VirtualFileManagerLocationDialog.this.attemptConnection();
                    MessageDialog.openInformation((Shell)VirtualFileManagerLocationDialog.this.shell, (String)Messages.VirtualFileManagerLocationDialog_ConnectionSuccessful, (String)StringUtils.format((String)Messages.VirtualFileManagerLocationDialog_ConnectionToSucceeded, (String)VirtualFileManagerLocationDialog.this._item.getNickName()));
                }
                catch (InvocationTargetException e1) {
                    String msg = null;
                    Throwable t = ExceptionUtils.getRootException((Throwable)e1);
                    if (t != null) {
                        msg = t.getMessage();
                    }
                    if (msg == null) {
                        msg = Messages.VirtualFileManagerLocationDialog_UnknownError;
                    }
                    MessageDialog.openWarning((Shell)VirtualFileManagerLocationDialog.this.shell, (String)Messages.VirtualFileManagerLocationDialog_ConnectionErrorTitle, (String)StringUtils.format((String)Messages.VirtualFileManagerLocationDialog_ConnectionErrorMessage, (String)msg));
                }
                catch (Exception e1) {
                    MessageDialog.openWarning((Shell)VirtualFileManagerLocationDialog.this.shell, (String)Messages.VirtualFileManagerLocationDialog_ConnectionErrorTitle, (String)StringUtils.format((String)Messages.VirtualFileManagerLocationDialog_ConnectionErrorMessage, (String)e1.getLocalizedMessage()));
                }
                ((Control)e.widget).setEnabled(true);
            }
        }
    }
}

