/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.IVirtualFileManagerDialog;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.core.ui.dialogs.GenericDialog;
import com.aptana.ide.core.ui.io.file.Messages;
import com.aptana.ide.core.ui.io.file.ProjectFileManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ProjectLocationDialog
extends GenericDialog
implements IVirtualFileManagerDialog {
    private Text localPath;
    private ProjectFileManager _item;
    protected Object result;
    protected Shell shell;
    private Label connectsALocalLabel;
    private boolean _newItem;

    public ProjectLocationDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ProjectLocationDialog(Shell parent) {
        this(parent, 0);
    }

    public IVirtualFileManager open() {
        this.createContents();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        SWTUtils.centerAndPack((Shell)this.shell, (Shell)this.getParent());
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this._newItem) {
            this._item = null;
        }
        return this._item;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.addCloseBoxListener(this.shell);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(473, 163);
        this.shell.setText(Messages.ProjectLocationDialog_ProjectSiteConfiguration);
        Composite composite_2 = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 2;
        composite_2.setLayout((Layout)gridLayout_5);
        composite_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label label = new Label(composite_2, 131072);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setAlignment(131072);
        label.setImage(SWTUtils.getImage((AbstractUIPlugin)CoreUIPlugin.getDefault(), (String)"icons/aptana_dialog_tag.png"));
        this.connectsALocalLabel = new Label(composite_2, 64);
        this.connectsALocalLabel.setFont(SWTUtils.getDefaultSmallFont());
        GridData gridData_4 = new GridData(4, 0x1000000, false, false);
        gridData_4.heightHint = 43;
        gridData_4.widthHint = 382;
        gridData_4.horizontalIndent = 5;
        gridData_4.verticalIndent = 3;
        this.connectsALocalLabel.setLayoutData((Object)gridData_4);
        this.connectsALocalLabel.setText(Messages.ProjectLocationDialog_ConnectionMessage);
        Label label_1 = new Label((Composite)this.shell, 0);
        GridData gridData_1 = new GridData(4, 0x1000000, false, false);
        gridData_1.heightHint = 1;
        label_1.setLayoutData((Object)gridData_1);
        Composite composite_1 = new Composite((Composite)this.shell, 0);
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 3;
        gridLayout_3.verticalSpacing = 10;
        gridLayout_3.horizontalSpacing = 10;
        gridLayout_3.marginHeight = 10;
        gridLayout_3.marginWidth = 10;
        composite_1.setLayout((Layout)gridLayout_3);
        Label _PathLabel = new Label(composite_1, 0);
        _PathLabel.setText(Messages.ProjectLocationDialog_ProjectPath);
        this.localPath = new Text(composite_1, 2048);
        this.localPath.setLayoutData((Object)new GridData(296, -1));
        Button browseLocalPath = new Button(composite_1, 0);
        browseLocalPath.setLayoutData((Object)new GridData());
        browseLocalPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectLocationDialog.this.handleBrowseProject();
            }
        });
        browseLocalPath.setText(StringUtils.ellipsify((String)CoreStrings.BROWSE));
        new Label(composite_1, 0);
        Button okButton = new Button(composite_1, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false);
        gridData.minimumWidth = 100;
        okButton.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(okButton);
        okButton.setText(CoreStrings.OK);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProjectLocationDialog.this.validateFields()) {
                    return;
                }
                ProjectLocationDialog.this._item.setNickName(ProjectLocationDialog.this.localPath.getText());
                ProjectLocationDialog.this._item.setBasePath(ProjectLocationDialog.this.localPath.getText());
                ProjectLocationDialog.this._item.setHidden(true);
                ProjectLocationDialog.this.shell.dispose();
            }
        });
        Button cancelButton = new Button(composite_1, 0);
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        cancelButton.setText(CoreStrings.CANCEL);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectLocationDialog.this.handleCancel();
            }
        });
        this.initializeDefaultValues();
    }

    protected boolean validateFields() {
        boolean fieldsEmpty = false;
        if (!SWTUtils.testWidgetValue((Text)this.localPath)) {
            fieldsEmpty = true;
        }
        return !fieldsEmpty;
    }

    private void initializeDefaultValues() {
        if (this._item != null) {
            SWTUtils.setTextWidgetValue((Text)this.localPath, (String)this._item.getRelativePath());
        }
    }

    private void handleBrowseProject() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.ProjectLocationDialog_SelectSynchronizeSource);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.localPath.setText(((Path)result[0]).toString());
        }
    }

    public void setItem(IVirtualFileManager vfm, boolean newItem) {
        if (!(vfm instanceof ProjectFileManager)) {
            throw new IllegalArgumentException(Messages.ProjectLocationDialog_CanOnlyAcceptProjectFileManagerItemsError);
        }
        this._item = (ProjectFileManager)vfm;
        this._newItem = newItem;
    }

    public void handleCancel() {
        this._item = null;
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }
}

