/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.views.outline;

import com.aptana.ide.editors.unified.InstanceCreator;
import com.aptana.ide.views.IViewerFilterContributor;
import com.aptana.ide.views.ViewerFilterContributorsProvider;
import com.aptana.ide.views.outline.IUnifiedOutlinePage;
import com.aptana.ide.views.outline.OutlineItem;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class UnifiedViewerFilter
extends ViewerFilter {
    static final String ID = "com.aptana.ide.views.outline.UnifiedViewerFilter";
    private IUnifiedOutlinePage _page;
    private HashMap<String, List<IViewerFilterContributor>> languageToFiltersMap;

    public UnifiedViewerFilter(IUnifiedOutlinePage page) {
        this._page = page;
        this.loadContributingFilters();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = true;
        if (this._page.hidePrivateMembers() && element instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)element;
            String prefix = UnifiedOutlineProvider.getInstance().getPrivateMemberPrefix(item.getLanguage());
            if (prefix != null && prefix.length() > 0 && item.getLabel().startsWith(prefix)) {
                result = false;
            } else {
                List<IViewerFilterContributor> filters = this.languageToFiltersMap.get(item.getLanguage());
                if (filters != null) {
                    for (IViewerFilterContributor filter : filters) {
                        result = filter.select(viewer, parentElement, element, this._page);
                        if (!result) break;
                    }
                }
            }
        }
        return result;
    }

    private void loadContributingFilters() {
        Map<String, List<InstanceCreator>> viewerFiltersContributors = ViewerFilterContributorsProvider.getInstance().getViewerFiltersContributors(ID);
        this.languageToFiltersMap = new HashMap();
        Set<String> languages = viewerFiltersContributors.keySet();
        for (String language : languages) {
            List<InstanceCreator> creators = viewerFiltersContributors.get(language);
            if (creators == null) continue;
            for (InstanceCreator creator : creators) {
                IViewerFilterContributor filter = (IViewerFilterContributor)creator.createInstance();
                if (filter == null) continue;
                List<IViewerFilterContributor> filters = this.languageToFiltersMap.get(language);
                if (filters == null) {
                    filters = new ArrayList<IViewerFilterContributor>(1);
                    this.languageToFiltersMap.put(language, filters);
                }
                filters.add(filter);
            }
        }
    }
}

