/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.wizards;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.wizards.Messages;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class UntitledTextFileWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow fWindow;

    protected String getFriendlyName() {
        return "";
    }

    public void dispose() {
        this.fWindow = null;
    }

    protected String getFileExtension() {
        return "";
    }

    private File queryFile() {
        IPath stateLocation = EditorsPlugin.getDefault().getStateLocation();
        IPath path = stateLocation.append("/_" + new Object().hashCode() + this.getFileExtension());
        return new File(path.toOSString());
    }

    protected String getEditorId(File file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "com.aptana.ide.ui.UntitledTextEditor";
    }

    private IEditorInput createEditorInput(File file) {
        return CoreUIUtils.createNonExistingFileEditorInput((File)file, (String)StringUtils.format((String)Messages.UntitledTextFileWizard_Untitled, (String)this.getFriendlyName()));
    }

    public boolean performFinish() {
        File file = this.queryFile();
        IEditorInput input = this.createEditorInput(file);
        String editorId = this.getEditorId(file);
        IWorkbenchPage page = this.fWindow.getActivePage();
        try {
            IEditorPart part = page.openEditor(input, editorId);
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                IDocumentProvider dp = editor.getDocumentProvider();
                IDocument doc = dp.getDocument((Object)editor.getEditorInput());
                try {
                    String fileContents = this.getInitialFileContents();
                    if (fileContents != null) {
                        doc.replace(0, 0, fileContents);
                    }
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UntitledTextFileWizard_Error, (Throwable)e);
                }
            }
            if (part instanceof IUnifiedEditor) {
                IUnifiedEditor te = (IUnifiedEditor)part;
                te.getViewer().getTextWidget().setCaretOffset(this.getInitialCaretOffset());
                String parentDir = this.getParentDirectoryHint();
                if (parentDir != null && !"".equals(parentDir)) {
                    te.setParentDirectoryHint(parentDir);
                }
            }
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.UntitledTextFileWizard_UnableToInitializePart, (Throwable)e);
            return false;
        }
        return true;
    }

    private String getParentDirectoryHint() {
        String dir = CoreUIPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.core.ui.PREF_CURRENT_DIRECTORY");
        return dir;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWindow = workbench.getActiveWorkbenchWindow();
    }

    protected String getInitialFileContents() {
        return "";
    }

    protected int getInitialCaretOffset() {
        return this.getInitialFileContents().length();
    }
}

