/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.outline.propertyManager;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.views.outline.propertyManager.EditableProperty;
import com.aptana.ide.editors.views.outline.propertyManager.INumericProperty;
import com.aptana.ide.editors.views.outline.propertyManager.Messages;
import com.aptana.ide.editors.views.outline.propertyManager.ReadableProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PropertyManager
implements PropertyChangeListener,
IPropertySource,
IPropertySourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ArrayList properties;
    private transient Hashtable knownDescriptors;
    private transient ArrayList propertyChangeListeners;
    protected Object owner;

    public PropertyManager(Object owner) {
        this.owner = owner;
        this.properties = new ArrayList();
        this.knownDescriptors = new Hashtable();
        this.linkPropertyOwner(owner);
    }

    private void linkPropertyOwner(Object owner) {
        if (owner instanceof ReadableProperty) {
            ReadableProperty property = (ReadableProperty)owner;
            property.setSubPropertyManager(this);
        }
    }

    public void addProperty(ReadableProperty readableProperty) {
        if (!this.hasProperty(readableProperty.getID())) {
            readableProperty.addPropertyChangeListener(this);
            this.properties.add(readableProperty);
        }
    }

    public void removeProperty(ReadableProperty readableProperty) {
        readableProperty.removePropertyChangeListener(this);
        this.properties.remove(readableProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeListeners().add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeListeners().remove(listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.notifyPropertyChangeListeners(event);
    }

    private void notifyPropertyChangeListeners(PropertyChangeEvent event) {
        PropertyChangeEvent newEvent = new PropertyChangeEvent(this.owner, event.getPropertyName(), event.getOldValue(), event.getNewValue());
        for (PropertyChangeListener listener : this.getPropertyChangeListeners()) {
            listener.propertyChange(newEvent);
        }
    }

    public EditableProperty getEditableProperty(Object id) {
        ReadableProperty prop = this.getProperty(id);
        if (prop != null && prop instanceof EditableProperty) {
            return (EditableProperty)prop;
        }
        return null;
    }

    public ReadableProperty getProperty(Object id) {
        ReadableProperty prop = this.findProperty(id);
        if (prop != null) {
            return prop;
        }
        String error = StringUtils.format((String)Messages.PropertyManager_CouldNotFindProperty, (Object)id);
        throw new IllegalArgumentException(error);
    }

    public boolean hasProperty(Object id) {
        return this.findProperty(id) != null;
    }

    public ReadableProperty getReadableProperty(Object id) {
        return this.getProperty(id);
    }

    private ReadableProperty findProperty(Object id) {
        for (ReadableProperty prop : this.properties) {
            if (!prop.getID().equals(id)) continue;
            return prop;
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] descriptors = new PropertyDescriptor[this.properties.size()];
        int p = 0;
        for (ReadableProperty readableProperty : this.properties) {
            if (readableProperty == null) continue;
            if (readableProperty.hasDynamicPropertyDescriptor()) {
                descriptors[p] = readableProperty.getPropertyDescriptor();
            } else {
                String id = readableProperty.getID();
                if (!this.getKnownDescriptors().containsKey(id)) {
                    this.getKnownDescriptors().put(id, readableProperty.getPropertyDescriptor());
                }
                descriptors[p] = (IPropertyDescriptor)this.getKnownDescriptors().get(id);
            }
            ++p;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        ReadableProperty readableProperty = this.getProperty(id);
        if (readableProperty != null) {
            if (readableProperty.hasSubProperties()) {
                return readableProperty.getSubPropertyManager();
            }
            return readableProperty.getUnderlyingValue();
        }
        return null;
    }

    public Number getPropertyNumberValue(Object id) {
        ReadableProperty readableProperty = this.getProperty(id);
        if (readableProperty instanceof INumericProperty) {
            return ((INumericProperty)((Object)readableProperty)).getNumberValue();
        }
        throw new IllegalArgumentException(StringUtils.format((String)Messages.PropertyManager_NotNumericProperty, (Object)id));
    }

    public int getPropertyIntValue(Object id) throws IllegalArgumentException {
        return this.getPropertyNumberValue(id).intValue();
    }

    public float getPropertyFloatValue(Object id) throws IllegalArgumentException {
        return this.getPropertyNumberValue(id).floatValue();
    }

    public double getPropertyDoubleValue(Object id) throws IllegalArgumentException {
        return this.getPropertyNumberValue(id).doubleValue();
    }

    public long getPropertyLongValue(Object id) throws IllegalArgumentException {
        return this.getPropertyNumberValue(id).longValue();
    }

    public boolean isPropertySet(Object id) {
        ReadableProperty readableProperty = this.getProperty(id);
        if (readableProperty != null && readableProperty.hasDefaultValue() && readableProperty.hasValue()) {
            return !readableProperty.getUnderlyingDefaultValue().equals(readableProperty.getUnderlyingValue());
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        EditableProperty editableProperty = this.getEditableProperty(id);
        if (editableProperty != null && editableProperty.hasDefaultValue()) {
            editableProperty.setUnderlyingValue(editableProperty.getUnderlyingDefaultValue());
        }
    }

    public void setPropertyValue(Object id, Object value) {
        ReadableProperty readableProperty = this.getProperty(id);
        if (readableProperty != null) {
            readableProperty.setUnderlyingValue(value);
        }
    }

    public Object getEditableValue() {
        if (this.owner instanceof ReadableProperty) {
            ReadableProperty property = (ReadableProperty)this.owner;
            return property.getUnderlyingValue();
        }
        return this.owner;
    }

    public IPropertySource getPropertySource(Object object) {
        return this;
    }

    public ArrayList getProperties() {
        return new ArrayList(this.properties);
    }

    protected ArrayList getPropertyChangeListeners() {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList();
        }
        return this.propertyChangeListeners;
    }

    protected Hashtable getKnownDescriptors() {
        if (this.knownDescriptors == null) {
            this.knownDescriptors = new Hashtable();
        }
        return this.knownDescriptors;
    }
}

