/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.validator.Messages;
import com.aptana.ide.editors.validator.ValidatorRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class ValidatorManager {
    private HashMap validators;
    private static ValidatorManager instance;

    ValidatorManager() {
        this.initialize();
    }

    public static ValidatorManager getInstance() {
        if (instance == null) {
            instance = new ValidatorManager();
        }
        return instance;
    }

    public ValidatorRef[] getValidators(String mimeType) {
        return (ValidatorRef[])this.validators.get(mimeType);
    }

    private void initialize() {
        this.validators = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.aptana.ide.editors", "validator");
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    IConfigurationElement element = configElements[j];
                    ValidatorRef validator = new ValidatorRef();
                    validator.setMimeType(element.getAttribute("mimeType"));
                    validator.setClassName(element.getAttribute("class"));
                    validator.setName(element.getAttribute("name"));
                    validator.setExtenderNameSpace(extensions[i].getNamespace());
                    validator.setConfigElement(element);
                    this.addValidator(validator);
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ValidatorManager_ErrorRetrievingExtensionConfig, (Throwable)ex);
                }
                ++j;
            }
            ++i;
        }
        this.rearrangeValidatorsAsArray();
    }

    private void rearrangeValidatorsAsArray() {
        Set keys = this.validators.keySet();
        for (String key : keys) {
            ArrayList validatorList = (ArrayList)this.validators.get(key);
            if (validatorList == null) continue;
            ValidatorRef[] validatorArray = validatorList.toArray(new ValidatorRef[0]);
            this.validators.put(key, validatorArray);
        }
    }

    private void addValidator(ValidatorRef validator) {
        ArrayList<ValidatorRef> validatorList = (ArrayList<ValidatorRef>)this.validators.get(validator.getMimeType());
        if (validatorList == null) {
            validatorList = new ArrayList<ValidatorRef>();
            this.validators.put(validator.getMimeType(), validatorList);
        }
        validatorList.add(validator);
    }
}

