/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.untitled;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.untitled.Messages;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class BaseTextEditor
extends TextEditor {
    private String directoryHint;

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        super.performSave(overwrite, progressMonitor);
        this.onSaveComplete();
    }

    protected void onSaveComplete() {
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IFile file;
        IEditorInput input = this.getEditorInput();
        String oldPath = CoreUIUtils.getPathFromEditorInput((IEditorInput)input);
        File newFile = null;
        File oldFile = oldPath == null ? null : new File(oldPath);
        IFile iFile = file = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (file != null) {
            super.performSaveAs(progressMonitor);
            String newPath = CoreUIUtils.getPathFromEditorInput((IEditorInput)this.getEditorInput());
            newFile = new File(newPath);
        } else {
            newFile = this.doExternalSaveAs(progressMonitor);
        }
        this.onSaveAsComplete(oldFile, newFile);
    }

    protected void onSaveAsComplete(File oldFile, File newFile) {
    }

    private File doExternalSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        File file;
        block17: {
            String text;
            File f;
            Shell shell = this.getSite().getShell();
            IDocumentProvider provider = this.getDocumentProvider();
            IEditorInput input = this.getEditorInput();
            FileDialog fileDialog = new FileDialog(shell, 8192);
            String fileName = this.getDefaultSaveAsFile();
            fileDialog.setFileName(fileName);
            FileDialogFilterInfo filterInfo = this.getFileDialogFilterInformation(fileName);
            String[] fileExtensions = filterInfo.getFilterExtensions();
            if (fileExtensions != null && fileExtensions.length > 0) {
                fileDialog.setFilterExtensions(fileExtensions);
                fileDialog.setFilterNames(filterInfo.getFilterNames());
            }
            if (this.directoryHint != null && (f = new File(this.directoryHint)).exists()) {
                fileDialog.setFilterPath(this.directoryHint);
            }
            if ((text = fileDialog.open()) == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return null;
            }
            file = new File(text);
            IEditorInput newInput = CoreUIUtils.createJavaFileEditorInput((File)file);
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status != null && status.getSeverity() == 8) break block17;
                    String title = Messages.BaseTextEditor_SaveFileError;
                    String msg = StringUtils.format((String)Messages.BaseTextEditor_ErrorSaving, (Object[])new Object[]{x.getMessage()});
                    if (status != null) {
                        switch (status.getSeverity()) {
                            case 1: {
                                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            case 2: {
                                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            default: {
                                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                        }
                        break block17;
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            finally {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput(newInput);
                }
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
        if (success) {
            return file;
        }
        return null;
    }

    protected FileDialogFilterInfo getFileDialogFilterInformation(String fileName) {
        FileDialogFilterInfo filterInfo = null;
        String fileExtension = this.getFileExtension(fileName);
        if (!fileExtension.equals("")) {
            filterInfo = new FileDialogFilterInfo();
            filterInfo.setFilterExtensions(new String[]{"*" + fileExtension, "All Files (*.*)"});
            filterInfo.setFilterNames(new String[]{"*" + fileExtension, Messages.BaseTextEditor_AllFiles});
        } else {
            filterInfo = new FileDialogFilterInfo();
            filterInfo.setFilterExtensions(new String[]{"*.*"});
            filterInfo.setFilterNames(new String[]{Messages.BaseTextEditor_AllFiles});
        }
        return filterInfo;
    }

    protected String getDefaultSaveAsFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return fileInput.getFile().getLocation().toOSString();
        }
        if (input instanceof IPathEditorInput) {
            IPathEditorInput pathInput = (IPathEditorInput)input;
            return pathInput.getPath().toOSString();
        }
        if (input instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput nonExist = (NonExistingFileEditorInput)input;
            IPath path = nonExist.getPath((Object)input);
            String fileName = this.getTitle();
            String lastSegment = path.lastSegment();
            int extIndex = lastSegment.lastIndexOf(".");
            if (extIndex != -1) {
                fileName = String.valueOf(fileName) + lastSegment.substring(extIndex);
            }
            return fileName;
        }
        return null;
    }

    protected String getFileExtension(String fileName) {
        String lastSegment = fileName;
        int extIndex = lastSegment.lastIndexOf(".");
        if (extIndex != -1) {
            return lastSegment.substring(extIndex);
        }
        return "";
    }

    public String getParentDirectoryHint() {
        return this.directoryHint;
    }

    public void setParentDirectoryHint(String hint) {
        this.directoryHint = hint;
    }

    protected class FileDialogFilterInfo {
        private String[] filterNames;
        private String[] filterExtensions;

        public String[] getFilterExtensions() {
            return this.filterExtensions;
        }

        public void setFilterExtensions(String[] filterExtensions) {
            this.filterExtensions = filterExtensions;
        }

        public String[] getFilterNames() {
            return this.filterNames;
        }

        public void setFilterNames(String[] filterNames) {
            this.filterNames = filterNames;
        }
    }
}

