/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.parsing;

import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.bnf.IReductionContext;
import com.aptana.ide.parsing.bnf.IReductionHandler;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnifiedReductionHandler<T extends IParseNode>
implements IReductionHandler {
    private transient Object[] _values = new Object[16];
    private int _size;
    protected IParseNodeFactory nodeFactory;
    protected LexemeList lexemes;

    public void afterParse(IParseState parseState, IParseNode parentNode) {
        this.nodeFactory = null;
        this.lexemes = null;
        int i = 0;
        while (i < this._size) {
            this._values[i] = null;
            ++i;
        }
        this._size = 0;
    }

    public void beforeParse(IParseState parseState, IParseNode parentNode) {
        if (parseState != null) {
            this.nodeFactory = parseState.getParseNodeFactory();
            this.lexemes = parseState.getLexemeList();
        }
    }

    protected T createNode(int type, Lexeme startingLexeme) {
        IParseNode result = null;
        if (this.nodeFactory != null) {
            result = this.nodeFactory.createParseNode(type, startingLexeme);
        }
        return (T)result;
    }

    private void ensureCapacity(int index) {
        int currentLength = this._values.length;
        if (index > currentLength) {
            int newLength = currentLength * 3 / 2 + 1;
            if (newLength < index) {
                newLength = index;
            }
            Object[] newList = new Object[newLength];
            System.arraycopy(this._values, 0, newList, 0, this._size);
            this._values = newList;
        }
    }

    public Object[] getValues() {
        Object[] result = new Object[this._size];
        if (this._size > 0) {
            System.arraycopy(this._values, 0, result, 0, this._size);
        }
        return result;
    }

    public void push(Object value) {
        this.ensureCapacity(this._size + 1);
        this._values[this._size++] = value;
    }

    protected Object[] pop(int count) {
        Object[] nodes = new Object[count];
        System.arraycopy(this._values, this._size - count, nodes, 0, count);
        this._size -= count;
        return nodes;
    }

    public abstract void reduce(IReductionContext var1);
}

