/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.hyperlinks;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.managers.EnvironmentManager;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.utils.EditorHelper;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import java.io.File;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;

public class UnifiedSourceHyperlink
implements IHyperlink {
    private IFileLanguageService service;
    private String text;
    private IRegion region;
    private Lexeme lexeme;

    public UnifiedSourceHyperlink(IFileLanguageService service, Lexeme lexeme, IRegion region, String text) {
        this.service = service;
        this.text = text;
        this.region = region;
        this.lexeme = lexeme;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return this.text;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        if (this.service == null || this.lexeme == null) {
            return;
        }
        String mimetype = this.lexeme.getLanguage();
        IRuntimeEnvironment env = EnvironmentManager.getEnvironment(mimetype);
        IFileLanguageService langService = this.service.getFileContext().getLanguageService(mimetype);
        if (langService == null || env == null) {
            return;
        }
        IOffsetMapper langMapper = langService.getOffsetMapper();
        if (langMapper == null) {
            return;
        }
        CodeLocation loc = (CodeLocation)langMapper.findTarget(this.lexeme);
        if (loc != null) {
            this.openInEditor(CoreUIUtils.getPathFromURI((String)loc.getFullPath()), loc.getStartLexeme());
        }
    }

    private void openInEditor(String fileName, Lexeme lexeme) {
        IEditorPart part;
        File file = new File(fileName);
        if (file.exists() && (part = EditorHelper.openInEditor(file)) instanceof UnifiedEditor) {
            UnifiedEditor jsEditor = (UnifiedEditor)part;
            jsEditor.selectAndReveal(lexeme.offset, lexeme.getEndingOffset() - lexeme.offset);
        }
    }
}

