/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.help;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.help.HelpResource;
import com.aptana.ide.editors.unified.help.Messages;
import com.aptana.ide.lexer.Lexeme;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.ui.PlatformUI;

public class LexemeHelpContext
implements IContext2 {
    private IHelpResource[] fHelpResources;
    private String fText;
    private String fTitle;

    public LexemeHelpContext(IContext context, IFileLanguageService fileLanguageService, Lexeme lexeme, int offset) {
        IHelpResource[] resources;
        ArrayList<IHelpResource> helpResources = new ArrayList<IHelpResource>();
        if (context != null && (resources = context.getRelatedTopics()) != null) {
            int j = 0;
            while (j < resources.length) {
                helpResources.add(resources[j]);
                ++j;
            }
        }
        if (lexeme != null) {
            Lexeme newLexeme = fileLanguageService.getValidDocumentationLexeme(lexeme);
            HelpResource[] resources2 = fileLanguageService.getDocumentationResourcesFromLexeme(lexeme);
            if (resources2 != null) {
                int i = 0;
                while (i < resources2.length) {
                    helpResources.add(resources2[i]);
                    ++i;
                }
            }
            this.fText = fileLanguageService.getDocumentationFromLexeme(newLexeme);
            if (this.fText == null || this.fText.length() == 0) {
                this.fText = "No documentation available";
            }
            this.fText = this.stripUnusedTags(this.fText);
            if (newLexeme != null) {
                String title = fileLanguageService.getDocumentationTitleFromLexeme(newLexeme);
                this.fTitle = StringUtils.format((String)Messages.LexemeHelpContext_About, (Object[])new String[]{title});
            }
        } else if (context != null) {
            this.fText = context.getText();
        }
        Pattern p = Pattern.compile("<a href=\"(.*)\">(.*)</a>");
        Matcher m = p.matcher(this.fText);
        while (m.find()) {
            String href = m.group(1);
            String label = m.group(2);
            HelpResource hr = new HelpResource("External Link: " + label, href);
            helpResources.add(hr);
        }
        this.fText = this.fText.replaceAll("<a href=\"(.*)\">(.*)</a>", "$2");
        this.fHelpResources = helpResources.toArray(new IHelpResource[helpResources.size()]);
        if (this.fText == null) {
            this.fText = "No documentation available";
        }
        this.fText = this.fText.replaceAll("\n\n\n*", "\n\n");
        String oldWhitespace = StringUtils.findEndWhitespace((String)this.fText);
        int newLines = StringUtils.getNumberOfNewlines((String)oldWhitespace);
        if (newLines <= 2) {
            int i = newLines;
            while (i < 2) {
                this.fText = String.valueOf(this.fText) + "\n";
                ++i;
            }
        } else {
            this.fText = StringUtils.trimEnd((String)this.fText);
            this.fText = String.valueOf(this.fText) + "\n\n";
        }
    }

    private String stripUnusedTags(String text) {
        if (text == null) {
            return null;
        }
        String tempText = text;
        tempText = tempText.replaceAll("<h2>", "<b>");
        tempText = tempText.replaceAll("</h2>", "</b><br>");
        tempText = tempText.replaceAll("<hr>", "");
        tempText = tempText.replaceAll("<h3>", "<b>");
        tempText = tempText.replaceAll("</h3>", "</b><br>");
        tempText = tempText.replaceAll("<pre>", "<code>");
        tempText = tempText.replaceAll("</pre>", "</code>");
        tempText = tempText.replaceAll("</?warning>", "");
        tempText = tempText.replaceAll("</?tip>", "");
        tempText = tempText.replaceAll("</?glossary>", "");
        tempText = tempText.replaceAll("</?method>", "");
        tempText = tempText.replaceAll("</?varname>", "");
        tempText = tempText.replaceAll("</?specification>", "");
        tempText = tempText.replaceAll("<p>", "");
        tempText = tempText.replaceAll("</p>", "<br><br>");
        tempText = tempText.replaceAll("\\s+", " ");
        tempText = tempText.replaceAll("<br> ", "<br>");
        tempText = tempText.replaceAll("<br>", "\n");
        return tempText;
    }

    public IHelpResource[] getRelatedTopics() {
        return this.fHelpResources;
    }

    public String getText() {
        return this.fText;
    }

    public String getStyledText() {
        return this.fText;
    }

    public String getCategory(IHelpResource topic) {
        return null;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public static void displayHelp(String contextId, IFileLanguageService fileLanguageService, Lexeme lexeme, int offset) {
        Object context = HelpSystem.getContext((String)contextId);
        if (context != null) {
            if (lexeme != null && lexeme.length > 0) {
                context = new LexemeHelpContext((IContext)context, fileLanguageService, lexeme, offset);
            }
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
        }
    }
}

