/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.errors;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.IFileErrorListener;
import com.aptana.ide.editors.unified.errors.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;

public abstract class FileErrorListener
implements IFileErrorListener {
    protected void setMarkerAttributes(IMarker marker, IFileError error, IDocument document) {
        try {
            marker.setAttribute("transient", true);
            marker.setAttribute("severity", error.getSeverity());
            marker.setAttribute("charStart", error.getOffset());
            marker.setAttribute("charEnd", error.getOffset() + error.getLength());
            marker.setAttribute("message", (Object)error.getMessage());
            try {
                int line = document.getLineOfOffset(error.getOffset());
                marker.setAttribute("lineNumber", line);
            }
            catch (BadLocationException badLocationException) {}
        }
        catch (CoreException e1) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.FileErrorListener_Error, (Throwable)e1);
        }
    }

    protected void notifyProblemsView(IFileError[] errors) {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
            }
        });
    }
}

