/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.contentassist;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.IUnifiedViewer;
import com.aptana.ide.editors.unified.contentassist.ICompletionProposalContributor;
import com.aptana.ide.editors.unified.contentassist.IUnifiedCompletionProposal;
import com.aptana.ide.editors.unified.contentassist.IUnifiedContentAssistProcessor;
import com.aptana.ide.editors.unified.contentassist.Messages;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IOffsetMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public abstract class UnifiedContentAssistProcessor
implements IUnifiedContentAssistProcessor {
    public static final String USERAGENT_ID = "userAgent";
    public static final String USERAGENT_ELEMENT = "user-agent";
    public static final String ATTR_USER_AGENT_NAME = "name";
    public static final String ATTR_USER_AGENT_ID = "id";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_ICON_DISABLED = "icon-disabled";
    protected IUnifiedViewer unifiedViewer = null;
    public static char DEFAULT_CHARACTER = '\u0000';
    private List _contributors = new ArrayList();
    private static HashMap agentImages = new HashMap();
    private static List agentNames = new ArrayList();

    static {
        try {
            UnifiedContentAssistProcessor.loadUserAgents();
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Unable to load user agents", (Throwable)ex);
        }
    }

    public static String[] getUserAgents() {
        if (PluginUtils.isPluginLoaded((Plugin)UnifiedEditorsPlugin.getDefault())) {
            IPreferenceStore prefs = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
            String agents = prefs.getString("com.aptana.ide.editor.USER_AGENT_PREFERENCE");
            return agents.split(",");
        }
        return new String[]{Messages.UnifiedContentAssistProcessor_IE, Messages.UnifiedContentAssistProcessor_Mozilla};
    }

    public static void addUserAgent(String id, String name, Image normal, Image disabled) {
        agentImages.put(id, normal);
        agentImages.put(String.valueOf(id) + "Grey", disabled);
        agentNames.add(id);
    }

    private static void loadUserAgents() {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint("com.aptana.ide.editors", USERAGENT_ID)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(USERAGENT_ELEMENT)) {
                        String agentID = element.getAttribute(ATTR_USER_AGENT_ID);
                        String agentName = element.getAttribute(ATTR_USER_AGENT_NAME);
                        String agentIconPath = element.getAttribute(ATTR_ICON);
                        String agentIconDisabledPath = element.getAttribute(ATTR_ICON_DISABLED);
                        if (agentID != null) {
                            IExtension ext = element.getDeclaringExtension();
                            String pluginId = ext.getNamespaceIdentifier();
                            Bundle bundle = Platform.getBundle((String)pluginId);
                            if (agentIconPath != null && agentIconDisabledPath != null) {
                                Image agentIcon = SWTUtils.getImage((Bundle)bundle, (String)agentIconPath);
                                Image agentIconDisabled = SWTUtils.getImage((Bundle)bundle, (String)agentIconDisabledPath);
                                if (agentIcon != null && agentIconDisabled != null) {
                                    UnifiedContentAssistProcessor.addUserAgent(agentID, agentName, agentIcon, agentIconDisabled);
                                }
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static String[] getDefaultUserAgents() {
        return agentNames.toArray(new String[0]);
    }

    public static HashMap getUserAgentImages() {
        return agentImages;
    }

    public abstract int[] getCompletionProposalIdleActivationTokens();

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public int[] getCompletionProposalSeparatorLexemes() {
        return new int[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getCompletionProposalPrivateActivationCharacters() {
        return new char[0];
    }

    public char[] getCompletionProposalAllActivationCharacters() {
        char[] allActivationChars = UnifiedContentAssistProcessor.combine(this.getCompletionProposalAutoActivationCharacters(), this.getContextInformationAutoActivationCharacters());
        Arrays.sort(allActivationChars);
        return allActivationChars;
    }

    public boolean isValidIdleActivationLocation(ITextViewer viewer, int offset) {
        Lexeme currentLexeme = this.getOffsetMapper().getCurrentLexeme();
        return UnifiedContentAssistProcessor.isValidIdleActivationToken(currentLexeme, this.getCompletionProposalIdleActivationTokens());
    }

    public void addCompletionProposalContributor(ICompletionProposalContributor contributor) {
        this._contributors.add(contributor);
    }

    public void removeCompletionProposalContributor(ICompletionProposalContributor contributor) {
        this._contributors.remove(contributor);
    }

    public ICompletionProposalContributor[] getCompletionProposalContributors() {
        return this._contributors.toArray(new ICompletionProposalContributor[0]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposals(viewer, offset, DEFAULT_CHARACTER, false);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar) {
        return this.computeCompletionProposals(viewer, offset, activationChar, false);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        if (viewer instanceof IUnifiedViewer) {
            this.unifiedViewer = (IUnifiedViewer)viewer;
        }
        this.getOffsetMapper().getCurrentLexeme();
        int currentIndex = this.computeCurrentLexemeIndex(offset, this.getOffsetMapper().getLexemeList());
        ICompletionProposal[] results = null;
        int sourceLength = 50;
        if (offset < 50) {
            sourceLength = offset;
        }
        String documentSnippet = "";
        try {
            documentSnippet = viewer.getDocument().get(offset - sourceLength, sourceLength);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)CoreStrings.ERROR, (Throwable)e);
        }
        char previousChar = UnifiedContentAssistProcessor.getActivationChar(documentSnippet, documentSnippet.length(), this.getCompletionProposalAllActivationCharacters());
        ArrayList proposals = new ArrayList();
        results = this.computeInnerCompletionProposals(viewer, offset, currentIndex, this.getOffsetMapper().getLexemeList(), activationChar, previousChar);
        if (results != null) {
            proposals.addAll(Arrays.asList(results));
        }
        for (ICompletionProposalContributor element : this._contributors) {
            ICompletionProposal[] contribs = element.computeCompletionProposals(viewer, offset, currentIndex, this.getOffsetMapper().getLexemeList(), activationChar, previousChar, autoActivated);
            if (contribs == null) continue;
            proposals.addAll(Arrays.asList(contribs));
        }
        if (this.unifiedViewer != null) {
            UnifiedContentAssistProcessor.resetViewerState(this.unifiedViewer);
        }
        ICompletionProposal[] newResults = proposals.toArray(new ICompletionProposal[0]);
        Arrays.sort(newResults, this.getProposalComparator());
        return newResults;
    }

    public abstract Comparator getProposalComparator();

    public static void resetViewerState(IUnifiedViewer unifiedViewer) {
        unifiedViewer.setHotkeyActivated(false);
    }

    public int computeCurrentLexemeIndex(int offset, LexemeList lexemeList) {
        return UnifiedContentAssistProcessor.computeCurrentLexemeIndex(offset, lexemeList, this.getCompletionProposalSeparatorLexemes());
    }

    public static int computeCurrentLexemeIndex(int offset, LexemeList lexemeList, int[] separatorTokens) {
        int lexemeIndex = lexemeList.getLexemeFloorIndex(offset);
        if (lexemeIndex <= 0) {
            return lexemeIndex;
        }
        Arrays.sort(separatorTokens);
        Lexeme l = lexemeList.get(lexemeIndex);
        int newIndex = lexemeIndex;
        int i = 0;
        while (i < separatorTokens.length) {
            int test = separatorTokens[i];
            if (l.typeIndex == test && l.offset == offset) {
                --newIndex;
                break;
            }
            ++i;
        }
        return newIndex;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        IContextInformation[] results = null;
        int currentIndex = this.computeCurrentLexemeIndex(offset, this.getOffsetMapper().getLexemeList());
        results = this.computeInnerContextInformation(viewer.getDocument().get(), offset, currentIndex, this.getOffsetMapper().getLexemeList());
        return results;
    }

    public abstract IOffsetMapper getOffsetMapper();

    public abstract ICompletionProposal[] computeInnerCompletionProposals(ITextViewer var1, int var2, int var3, LexemeList var4, char var5, char var6);

    public abstract IContextInformation[] computeInnerContextInformation(String var1, int var2, int var3, LexemeList var4);

    public static boolean isValidIdleActivationToken(Lexeme lexeme, int[] tokens) {
        if (lexeme == null) {
            return false;
        }
        Arrays.sort(tokens);
        return Arrays.binarySearch(tokens, lexeme.typeIndex) >= 0;
    }

    public static int setSelection(String prefix, ICompletionProposal[] results) {
        int selectedIndex = -1;
        if (prefix == null || prefix.equals("") || results == null) {
            return selectedIndex;
        }
        IUnifiedCompletionProposal sensitiveProposal = null;
        IUnifiedCompletionProposal insensitiveProposal = null;
        IUnifiedCompletionProposal suggestedProposal = null;
        int i = 0;
        while (i < results.length) {
            IUnifiedCompletionProposal cp = (IUnifiedCompletionProposal)results[i];
            String display = cp.getDisplayString();
            int result = display.compareToIgnoreCase(prefix);
            if (result >= 0) {
                if (display.toLowerCase().startsWith(prefix.toLowerCase())) {
                    if (insensitiveProposal == null) {
                        insensitiveProposal = cp;
                        selectedIndex = i;
                    }
                    if (display.startsWith(prefix)) {
                        sensitiveProposal = cp;
                        selectedIndex = i;
                        break;
                    }
                } else {
                    suggestedProposal = cp;
                    break;
                }
            }
            if (i == results.length - 1) {
                suggestedProposal = cp;
            }
            ++i;
        }
        if (sensitiveProposal != null) {
            sensitiveProposal.setDefaultSelection(true);
        } else if (insensitiveProposal != null) {
            insensitiveProposal.setDefaultSelection(true);
        } else if (suggestedProposal != null) {
            suggestedProposal.setSuggestedSelection(true);
        } else if (results.length > 0) {
            ((IUnifiedCompletionProposal)results[0]).setSuggestedSelection(true);
        }
        return selectedIndex;
    }

    public static int setSelectionUnsorted(String prefix, ICompletionProposal[] results) {
        IUnifiedCompletionProposal selectedProposal = null;
        int selectedIndex = -1;
        if (prefix == null || prefix.equals("")) {
            return selectedIndex;
        }
        int i = 0;
        while (i < results.length) {
            IUnifiedCompletionProposal cp = (IUnifiedCompletionProposal)results[i];
            if (cp.getDisplayString().startsWith(prefix)) {
                selectedProposal = cp;
                selectedIndex = i;
                break;
            }
            ++i;
        }
        if (selectedProposal != null) {
            selectedProposal.setDefaultSelection(true);
        } else if (results.length > 0) {
            ((IUnifiedCompletionProposal)results[0]).setDefaultSelection(true);
            selectedIndex = 0;
        }
        return selectedIndex;
    }

    public static Lexeme getPreviousLexemeOfType(int offset, int[] lexemeTypes, LexemeList lexemeList, boolean includeCurrent) {
        return UnifiedContentAssistProcessor.getPreviousLexemeOfType(offset, lexemeTypes, new int[0], lexemeList, includeCurrent);
    }

    public static Lexeme getPreviousLexemeOfType(int offset, int[] lexemeTypes, int[] lexemeTypesToBail, LexemeList lexemeList, boolean includeCurrent) {
        int index;
        Arrays.sort(lexemeTypes);
        Arrays.sort(lexemeTypesToBail);
        Lexeme startLexeme = lexemeList.getFloorLexeme(offset);
        if (!includeCurrent) {
            startLexeme = UnifiedContentAssistProcessor.getPreviousLexeme(offset, lexemeList);
        }
        if (startLexeme == null) {
            return null;
        }
        int i = index = lexemeList.getLexemeIndex(startLexeme);
        while (i >= 0) {
            Lexeme l = lexemeList.get(i);
            if (Arrays.binarySearch(lexemeTypes, l.typeIndex) >= 0) {
                return l;
            }
            if (Arrays.binarySearch(lexemeTypesToBail, l.typeIndex) >= 0) {
                return null;
            }
            --i;
        }
        return null;
    }

    public static Lexeme getPreviousLexeme(int offset, LexemeList lexemeList) {
        if (offset == 0) {
            return null;
        }
        Lexeme floor = lexemeList.getFloorLexeme(offset);
        if (floor.offset == offset) {
            int index = lexemeList.getLexemeIndex(floor);
            if (index > 0) {
                return lexemeList.get(index - 1);
            }
            return null;
        }
        return floor;
    }

    public static char getActivationChar(String source, int offset, char[] activationCharacters1, char[] activationCharacters2) {
        char[] newArray = new char[activationCharacters1.length + activationCharacters2.length];
        int i = 0;
        while (i < activationCharacters1.length) {
            newArray[i] = activationCharacters1[i];
            ++i;
        }
        i = 0;
        while (i < activationCharacters2.length) {
            newArray[i + activationCharacters1.length] = activationCharacters2[i];
            ++i;
        }
        return UnifiedContentAssistProcessor.getActivationChar(source, offset, newArray);
    }

    public static char getActivationChar(String source, int offset, char[] activationCharacters) {
        Arrays.sort(activationCharacters);
        if (offset > 0) {
            char activationCharacter = UnifiedContentAssistProcessor.getPreviousChar(source, offset);
            if (Arrays.binarySearch(activationCharacters, activationCharacter) < 0) {
                activationCharacter = DEFAULT_CHARACTER;
            }
            return activationCharacter;
        }
        return DEFAULT_CHARACTER;
    }

    public static char getPreviousChar(String source, int offset) {
        if (source == null) {
            throw new IndexOutOfBoundsException(Messages.UnifiedContentAssistProcessor_StringNotNull);
        }
        if (offset > 0 && offset <= source.length()) {
            char activationCharacter = source.charAt(offset - 1);
            return activationCharacter;
        }
        return DEFAULT_CHARACTER;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    public static char[] combine(char[] array1, char[] array2) {
        char[] newArray = new char[array1.length + array2.length];
        int i = 0;
        while (i < array1.length) {
            newArray[i] = array1[i];
            ++i;
        }
        i = 0;
        while (i < array2.length) {
            newArray[i + array2.length] = array2[i];
            ++i;
        }
        return newArray;
    }

    public static boolean containsExactProposalMatch(String proposal, ICompletionProposal[] proposals) {
        if (proposals == null) {
            return false;
        }
        int i = 0;
        while (i < proposals.length) {
            ICompletionProposal prop = proposals[i];
            String displayProp = prop.getDisplayString();
            if (displayProp.equals(proposal)) {
                return true;
            }
            if (prop instanceof IUnifiedCompletionProposal && ((IUnifiedCompletionProposal)prop).getReplaceString().equals(proposal)) {
                return true;
            }
            String tempProposal = proposal;
            if (tempProposal.startsWith("\"") || tempProposal.startsWith("'")) {
                tempProposal = tempProposal.substring(1);
            }
            if (tempProposal.endsWith("\"") || tempProposal.endsWith("'")) {
                tempProposal = tempProposal.substring(0, tempProposal.length() - 1);
            }
            if (displayProp.equals(tempProposal)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Image[] getUserAgentImages(String[] supportedUserAgents, String[] allUserAgents) {
        if (supportedUserAgents.length > 0) {
            ArrayList<Image> images = new ArrayList<Image>();
            int i = 0;
            while (i < supportedUserAgents.length) {
                String agentName = supportedUserAgents[i];
                Image image = null;
                int j = 0;
                while (j < allUserAgents.length) {
                    String ua = allUserAgents[j];
                    if (ua.equals(agentName)) {
                        image = (Image)agentImages.get(agentName);
                    }
                    ++j;
                }
                if (image == null) {
                    image = (Image)agentImages.get(String.valueOf(agentName) + "Grey");
                }
                images.add(image);
                ++i;
            }
            return images.toArray(new Image[0]);
        }
        return UnifiedContentAssistProcessor.getGreyUserAgentImages(allUserAgents);
    }

    public static Image[] getGreyUserAgentImages(String[] userAgents) {
        ArrayList<Image> images = new ArrayList<Image>();
        int i = 0;
        while (i < userAgents.length) {
            String agentName = userAgents[i];
            Image image = (Image)agentImages.get(String.valueOf(agentName) + "Grey");
            images.add(image);
            ++i;
        }
        return images.toArray(new Image[0]);
    }

    public static Image[] getAllUserAgentImages(String[] userAgents) {
        ArrayList<Image> images = new ArrayList<Image>();
        int i = 0;
        while (i < userAgents.length) {
            String agentName = userAgents[i];
            Image image = (Image)agentImages.get(agentName);
            images.add(image);
            ++i;
        }
        return images.toArray(new Image[0]);
    }
}

