/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.colorizer.CategoryColorizer;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.Messages;
import com.aptana.ide.editors.unified.colorizer.Region;
import com.aptana.ide.editors.unified.colorizer.TokenColorizer;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.LexerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColorizerWriter {
    public static final String XMLNS_ATTR = "xmlns";
    public static final String NAMESPACE_ATTR = "http://www.aptana.com/2007/colorizer/1.0";

    public void buildColorizationPreference(LanguageColorizer lc, String language, String prefID) throws LexerException {
        try {
            Document document = this.buildDom(lc, language);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(domSource, result);
            IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
            store.setValue(prefID, writer.toString());
        }
        catch (Exception e) {
            throw new LexerException(Messages.ColorizerWriter_ERROR_SAVING, e);
        }
    }

    public void buildColorizationFile(LanguageColorizer lc, String language, File file) throws LexerException {
        block4: {
            try {
                Document document = this.buildDom(lc, language);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                DOMSource domSource = new DOMSource(document);
                File output = file;
                if (output == null) break block4;
                try {
                    FileOutputStream stream = new FileOutputStream(output);
                    StreamResult result = new StreamResult(stream);
                    transformer.transform(domSource, result);
                    stream.close();
                }
                catch (TransformerException e) {
                    throw new LexerException(Messages.ColorizerWriter_ERROR_SAVING, (Exception)e);
                }
            }
            catch (Exception e) {
                throw new LexerException(Messages.ColorizerWriter_ERROR_SAVING, e);
            }
        }
    }

    protected Document buildDom(LanguageColorizer lc, String language) throws ParserConfigurationException {
        Collection tokenColorizers = lc.getTokenColorizers();
        Collection categoryColorizers = lc.getCategoryColorizers();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElement("colorizer");
        document.appendChild(root);
        root.setAttribute(XMLNS_ATTR, NAMESPACE_ATTR);
        root.setAttribute("language", language);
        if (lc.getBackground() != null) {
            String editorBG = ColorizerWriter.createRGBString(lc.getBackground());
            root.setAttribute("background", editorBG);
        }
        if (lc.getSelectionBackground() != null) {
            String selectionBG = ColorizerWriter.createRGBString(lc.getSelectionBackground());
            root.setAttribute("selection-background", selectionBG);
        }
        if (lc.getSelectionForeground() != null) {
            String selectionFG = ColorizerWriter.createRGBString(lc.getSelectionForeground());
            root.setAttribute("selection-foreground", selectionFG);
        }
        if (lc.getCaretColor() != null) {
            String caretColor = ColorizerWriter.createRGBString(lc.getCaretColor());
            root.setAttribute("caret-color", caretColor);
        }
        if (lc.getLineHighlightColor() != null) {
            String lineHighlight = ColorizerWriter.createRGBString(lc.getLineHighlightColor());
            root.setAttribute("line-highlight", lineHighlight);
        }
        if (lc.getFoldingBg() != null) {
            String foldingBg = ColorizerWriter.createRGBString(lc.getFoldingBg());
            root.setAttribute("folding-background", foldingBg);
        }
        if (lc.getFoldingFg() != null) {
            String foldingFg = ColorizerWriter.createRGBString(lc.getFoldingFg());
            root.setAttribute("folding-foreground", foldingFg);
        }
        for (CategoryColorizer cColorizer : categoryColorizers) {
            String cName = cColorizer.getName();
            String cStyle = cColorizer.getStyle().getName();
            Element catElement = document.createElement("category");
            catElement.setAttribute("name", cName);
            catElement.setAttribute("style", cStyle);
            root.appendChild(catElement);
            Iterator tokens = tokenColorizers.iterator();
            ColorizerWriter.addColorization(root, cColorizer.getStyle(), document);
            while (tokens.hasNext()) {
                TokenColorizer tColorizer = (TokenColorizer)tokens.next();
                IToken token = tColorizer.getToken();
                if (!cName.equals(token.getCategory())) continue;
                String type = token.getType();
                String token_style = tColorizer.getBaseColorization().getName();
                Element tokenElement = document.createElement("token");
                tokenElement.setAttribute("type", type);
                tokenElement.setAttribute("style", token_style);
                catElement.appendChild(tokenElement);
                ColorizerWriter.addRegions(root, tokenElement, tColorizer, document);
                ColorizerWriter.addColorization(root, tColorizer.getBaseColorization(), document);
            }
        }
        return document;
    }

    private static String createRGBString(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    private static void addColorization(Element parent, ColorizationStyle style, Document document) {
        Color fg;
        Color bg = style.getBackgroundColor();
        Element styleElement = document.createElement("style");
        if (bg != null) {
            String bgColor = ColorizerWriter.createRGBString(bg);
            styleElement.setAttribute("background", bgColor);
        }
        if ((fg = style.getForegroundColor()) != null) {
            String fgColor = ColorizerWriter.createRGBString(fg);
            styleElement.setAttribute("foreground", fgColor);
        }
        if (style.isBold()) {
            styleElement.setAttribute("font-weight", "bold");
        }
        if (style.isItalic()) {
            styleElement.setAttribute("font-style", "italic");
        }
        if (style.isUnderline()) {
            styleElement.setAttribute("text-decoration", "underline");
        }
        if (style.getName() != null) {
            styleElement.setAttribute("id", style.getName());
            parent.appendChild(styleElement);
        }
    }

    private static void addRegions(Element root, Element parent, TokenColorizer tokenColorizer, Document document) {
        for (Region region : tokenColorizer.getRegions()) {
            Element regionElement = document.createElement("region");
            regionElement.setAttribute("name", region.getName());
            regionElement.setAttribute("style", region.getStyle().getName());
            regionElement.setAttribute("offset", region.getOffsetString());
            regionElement.setAttribute("length", region.getLengthString());
            ColorizerWriter.addColorization(root, region.getStyle(), document);
            parent.appendChild(regionElement);
        }
    }
}

