/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.InstanceCreator;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.CategoryColorizer;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.IColorizerHandler;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.Messages;
import com.aptana.ide.editors.unified.colorizer.Region;
import com.aptana.ide.editors.unified.colorizer.TokenColorizer;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.sax.AttributeSniffer;
import com.aptana.sax.Schema;
import com.aptana.sax.SchemaBuilder;
import com.aptana.sax.SchemaInitializationException;
import com.aptana.sax.ValidatingReader;
import com.aptana.xml.IErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class ColorizerReader
extends ValidatingReader {
    private static final String SCHEMA = "/com/aptana/ide/editors/resources/ColorizationSchema.xml";
    private static final Pattern PARSE_ERROR_LINE_NUMBER = Pattern.compile(" line (\\d+)");
    private String currentCategory;
    private IToken currentToken;
    private String mimeType;
    private Locator locator;
    private IErrorHandler errorHandler;
    private ITokenList defaultTokenList;
    private LanguageColorizer colorizer;
    private Map<String, Map<String, IToken>> categoriesToToken;
    private Map<String, ColorizationStyle> styles;
    private Map<String, String> ids;
    private Map<String, URL> urls;
    private Map<Object, String> waitingElements;
    private Map<Region, IToken> regionsToToken;
    private Map<String, InstanceCreator> instanceCreators = new HashMap<String, InstanceCreator>();
    private List<IColorizerHandler> handlers = new ArrayList<IColorizerHandler>();
    protected boolean registerColorizer;

    public ColorizerReader() {
        this(null);
    }

    public ColorizerReader(ITokenList tokenList) {
        this.categoriesToToken = new HashMap<String, Map<String, IToken>>();
        this.styles = new HashMap<String, ColorizationStyle>();
        this.ids = new HashMap<String, String>();
        this.urls = new HashMap<String, URL>();
        this.waitingElements = new HashMap<Object, String>();
        this.regionsToToken = new HashMap<Region, IToken>();
        this.defaultTokenList = tokenList;
        this._schema = this.createSchema();
    }

    public void loadExtensionPointColorizers() {
        this.registerColorizer = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.colorization");
        if (ep == null) {
            return;
        }
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            try {
                String pluginID = extensions[i].getContributor().getName();
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String handler;
                    if ("colorization".equals(elements[j].getName())) {
                        Bundle bundle;
                        URL filePath;
                        String colorizationFile = elements[j].getAttribute("file");
                        final String id = elements[j].getAttribute("id");
                        if (colorizationFile != null && id != null && id.length() > 0 && (filePath = (bundle = Platform.getBundle((String)pluginID)).getEntry(colorizationFile)) != null) {
                            InstanceCreator creator = new InstanceCreator(null, null){

                                public Object createInstance() {
                                    return ColorizerReader.this.loadColorizationFromURL(filePath, id, false);
                                }
                            };
                            AttributeSniffer sniffer = new AttributeSniffer("colorizer", "language");
                            sniffer.read(filePath.openStream());
                            if (sniffer.getMatchedValue() != null) {
                                String language = sniffer.getMatchedValue();
                                this.instanceCreators.put(language, creator);
                            }
                        }
                    } else if ("handler".equals(elements[j].getName()) && (handler = elements[j].getAttribute("class")) != null) {
                        try {
                            Object obj = elements[j].createExecutableExtension("class");
                            if (obj instanceof IColorizerHandler) {
                                IColorizerHandler colorizerHandler = (IColorizerHandler)obj;
                                this.handlers.add(colorizerHandler);
                            }
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Error creating colorizer handler", (Throwable)e);
                        }
                    }
                    ++j;
                }
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ColorizerReader_ERROR_EXTENSION_POINT);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
            }
            ++i;
        }
    }

    public LanguageColorizer loadLanguageColorizer(InputStream stream, boolean register) {
        this.registerColorizer = register;
        this.colorizer = null;
        try {
            this.loadXML(stream);
        }
        catch (Exception exception) {
            this.colorizer = null;
        }
        return this.colorizer;
    }

    public void importColorization(File file, String mimeType) {
        block17: {
            InputStream stream;
            block16: {
                stream = null;
                try {
                    try {
                        String id = this.ids.get(mimeType);
                        if (id != null) {
                            IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
                            String content = store.getString(id);
                            stream = file.toURL().openStream();
                            this.loadXML(stream);
                            if (mimeType != null) {
                                store.setValue(id, content);
                            }
                        }
                    }
                    catch (Exception exception) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ColorizerReader_ERROR_IMPORTING);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block17;
                }
                catch (IOException iOException) {}
                break block17;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LanguageColorizer importColorization(File file) {
        FileInputStream stream;
        block10: {
            LanguageColorizer languageColorizer;
            stream = null;
            try {
                LanguageColorizer colorizer;
                stream = new FileInputStream(file);
                this.registerColorizer = false;
                languageColorizer = colorizer = this.loadXML(stream);
            }
            catch (Exception exception) {
                try {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ColorizerReader_ERROR_IMPORTING);
                    break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream == null) throw throwable;
                        ((InputStream)stream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (stream == null) return languageColorizer;
                ((InputStream)stream).close();
                return languageColorizer;
            }
            catch (IOException iOException) {}
            return languageColorizer;
        }
        try {
            if (stream == null) return null;
            ((InputStream)stream).close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public LanguageColorizer loadColorization(String id, boolean register) {
        this.registerColorizer = register;
        this.colorizer = null;
        this.mimeType = null;
        try {
            IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
            String content = store.getString(id);
            ByteArrayInputStream stream = null;
            if (content.length() > 0) {
                stream = new ByteArrayInputStream(content.getBytes());
                this.loadXML(stream);
                if (this.mimeType != null) {
                    this.setPreferenceId(this.mimeType, id);
                    store.setValue(id, content);
                }
            }
        }
        catch (Exception exception) {
            this.colorizer = null;
        }
        return this.colorizer;
    }

    public LanguageColorizer loadColorizationFromURL(URL url, String id, boolean useDefault) {
        block16: {
            InputStream stream;
            block15: {
                stream = null;
                this.colorizer = null;
                this.mimeType = null;
                try {
                    try {
                        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
                        String content = store.getString(id);
                        stream = content.length() > 0 && !useDefault ? new ByteArrayInputStream(content.getBytes()) : url.openStream();
                        this.loadXML(stream);
                        if (this.mimeType != null) {
                            this.setPreferenceId(this.mimeType, id);
                            this.urls.put(this.mimeType, url);
                            store.setValue(id, content);
                        }
                    }
                    catch (Exception exception) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.ColorizerReader_ERROR_LOADING, (String)id));
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block16;
                }
                catch (IOException iOException) {}
                break block16;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return this.colorizer;
    }

    private LanguageColorizer loadXML(InputStream stream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = null;
            saxParser = factory.newSAXParser();
            saxParser.parse(stream, (DefaultHandler)((Object)this));
            return this.colorizer;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Error parsing colorization file", (Throwable)e);
            return null;
        }
    }

    public String getPreferenceId(String mimeType) {
        return this.ids.get(mimeType);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void sendWarning(String message) {
        if (this.errorHandler != null) {
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (line == -1) {
                Matcher m = PARSE_ERROR_LINE_NUMBER.matcher(message);
                line = m.find() ? Integer.parseInt(m.group(1)) : 0;
            }
            this.errorHandler.handleWarning(line, column, message);
        }
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void sendError(String message) {
        if (this.errorHandler != null) {
            int line = this.locator.getLineNumber();
            int column = this.locator.getColumnNumber();
            if (line == -1) {
                Matcher m = PARSE_ERROR_LINE_NUMBER.matcher(message);
                line = m.find() ? Integer.parseInt(m.group(1)) : 0;
            }
            this.errorHandler.handleError(line, column, message);
        }
    }

    private RGB parseRGB(String value) {
        RGB rgb;
        block13: {
            String original = value;
            rgb = new RGB(0, 0, 0);
            try {
                value = value.trim();
                if (value.startsWith("rgb")) {
                    value = value.substring(4, value.length());
                    String[] rgbs = (value = value.substring(0, value.length() - 1)).split(",");
                    if (rgbs.length < 3) break block13;
                    try {
                        rgb.red = Integer.parseInt(rgbs[0].trim());
                    }
                    catch (NumberFormatException e) {
                        this.sendError("Invalid red value for rgb color \"" + original + "\"");
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ColorizerReader_ERROR_PARSING_COLOR, (Throwable)e);
                    }
                    try {
                        rgb.green = Integer.parseInt(rgbs[1].trim());
                    }
                    catch (NumberFormatException e) {
                        this.sendError("Invalid red value for rgb color \"" + original + "\"");
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ColorizerReader_ERROR_PARSING_COLOR, (Throwable)e);
                    }
                    try {
                        rgb.blue = Integer.parseInt(rgbs[2].trim());
                    }
                    catch (NumberFormatException e) {
                        this.sendError("Invalid red value for rgb color \"" + original + "\"");
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ColorizerReader_ERROR_PARSING_COLOR, (Throwable)e);
                    }
                    break block13;
                }
                if (value.startsWith("COLOR")) {
                    Class<SWT> c = SWT.class;
                    Field f = c.getField(value);
                    final int result = f.getInt(c);
                    final Display display = Display.getDefault();
                    if (display != null) {
                        class ColorResult {
                            Color color = null;

                            ColorResult() {
                            }
                        }
                        final ColorResult colorResult = new ColorResult();
                        display.syncExec(new Runnable(){
                            {
                            }

                            public void run() {
                                colorResult.color = display.getSystemColor(result);
                            }
                        });
                        if (colorResult.color != null) {
                            rgb = colorResult.color.getRGB();
                        }
                    }
                } else {
                    this.sendError("Invalid rgb value: \"" + original + "\"");
                }
            }
            catch (Exception exception) {
                this.sendError("Invalid rgb value: \"" + original + "\", defaulting to black.");
            }
        }
        return rgb;
    }

    private void groupTokens(ITokenList tokenList) {
        this.categoriesToToken = new HashMap<String, Map<String, IToken>>();
        if (tokenList == null) {
            return;
        }
        int i = 0;
        while (i < tokenList.size()) {
            IToken curr = tokenList.get(i);
            Map<Object, Object> types = null;
            if (this.categoriesToToken.containsKey(curr.getCategory())) {
                types = this.categoriesToToken.get(curr.getCategory());
            } else {
                types = new HashMap();
                this.categoriesToToken.put(curr.getCategory(), types);
                ColorizationStyle originalColorStyle = new ColorizationStyle();
                originalColorStyle.setForegroundColor(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
                originalColorStyle.setName(curr.getCategory());
                CategoryColorizer catColorizer = new CategoryColorizer();
                catColorizer.setName(curr.getCategory());
                catColorizer.setStyle(originalColorStyle);
                this.colorizer.addCategoryColorizer(catColorizer);
            }
            types.put(curr.getType(), curr);
            ++i;
        }
    }

    private IToken getToken(String category, String type) {
        Map<String, IToken> tokens;
        if (this.categoriesToToken.containsKey(category) && (tokens = this.categoriesToToken.get(category)).containsKey(type)) {
            return tokens.get(type);
        }
        return null;
    }

    private boolean containsCategory(String category) {
        return this.categoriesToToken.containsKey(category);
    }

    private void styleToken(LanguageColorizer lc, IToken token, String style) {
        if (this.styles.containsKey(style)) {
            ColorizationStyle originalColorStyle = this.styles.get(style);
            ColorizationStyle newColorStyle = new ColorizationStyle(originalColorStyle);
            newColorStyle.setName(String.valueOf(token.getCategory()) + "_" + token.getType());
            TokenColorizer tc = lc.getTokenColorizer(token);
            if (tc == null) {
                tc = new TokenColorizer();
                tc.setToken(token);
                lc.addTokenColorizer(tc);
            }
            tc.setBaseColorization(newColorStyle);
        } else {
            TokenColorizer tc = new TokenColorizer();
            tc.setToken(token);
            ColorizationStyle newColorStyle = new ColorizationStyle();
            newColorStyle.setName(String.valueOf(token.getCategory()) + "_" + token.getType());
            newColorStyle.setForegroundColor(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
            tc.setBaseColorization(newColorStyle);
            lc.addTokenColorizer(tc);
            this.waitingElements.put(token, style);
        }
    }

    private void styleCategory(LanguageColorizer lc, String category, String style) {
        if (this.styles.containsKey(style)) {
            ColorizationStyle originalColorStyle = this.styles.get(style);
            ColorizationStyle newColorStyle = new ColorizationStyle(originalColorStyle);
            newColorStyle.setName(category);
            CategoryColorizer catColorizer = new CategoryColorizer();
            catColorizer.setName(category);
            catColorizer.setStyle(newColorStyle);
            lc.addCategoryColorizer(catColorizer);
        } else {
            this.waitingElements.put(category, style);
        }
    }

    private void styleRegion(LanguageColorizer lc, IToken token, Region region, String style) {
        if (this.styles.containsKey(style)) {
            ColorizationStyle originalColorStyle = this.styles.get(style);
            ColorizationStyle newColorStyle = new ColorizationStyle(originalColorStyle);
            newColorStyle.setName(String.valueOf(token.getCategory()) + "_" + token.getType() + "_" + region.getName());
            region.setStyle(newColorStyle);
            TokenColorizer tc = lc.getTokenColorizer(token);
            tc.addColorization(region);
        } else {
            this.waitingElements.put(region, style);
        }
    }

    public void enterColorizer(String ns, String name, String qname, Attributes attributes) {
        this.styles.clear();
        this.waitingElements.clear();
        this.regionsToToken.clear();
        this.categoriesToToken.clear();
        this.mimeType = attributes.getValue("language");
        this.colorizer = new LanguageColorizer(this.mimeType);
        int i = 0;
        while (i < this.handlers.size()) {
            IColorizerHandler handler = this.handlers.get(i);
            if (handler != null && this.mimeType.equals(handler.getLanguage())) {
                this.colorizer.addHandler(handler);
            }
            ++i;
        }
        this.groupTokens(this.getDefaultTokenList());
        String backgroundColor = attributes.getValue("background");
        String selectionFgColor = attributes.getValue("selection-foreground");
        String selectionBgColor = attributes.getValue("selection-background");
        String caretColor = attributes.getValue("caret-color");
        String lineHighlightColor = attributes.getValue("line-highlight");
        String foldingBgColor = attributes.getValue("folding-background");
        String foldingFgColor = attributes.getValue("folding-foreground");
        if (backgroundColor != null && selectionFgColor != null && selectionBgColor != null && caretColor != null && lineHighlightColor != null) {
            RGB bgColor = this.parseRGB(backgroundColor);
            this.colorizer.setBackground(UnifiedColorManager.getInstance().getColor(bgColor));
            RGB selectionFg = this.parseRGB(selectionFgColor);
            this.colorizer.setSelectionForeground(UnifiedColorManager.getInstance().getColor(selectionFg));
            RGB selectionBg = this.parseRGB(selectionBgColor);
            this.colorizer.setSelectionBackground(UnifiedColorManager.getInstance().getColor(selectionBg));
            RGB cColor = this.parseRGB(caretColor);
            this.colorizer.setCaretColor(UnifiedColorManager.getInstance().getColor(cColor));
            RGB lineColor = this.parseRGB(lineHighlightColor);
            this.colorizer.setLineHighlightColor(UnifiedColorManager.getInstance().getColor(lineColor));
            if (foldingBgColor != null && foldingFgColor != null) {
                RGB foldingFg = this.parseRGB(foldingFgColor);
                this.colorizer.setFoldingFg(UnifiedColorManager.getInstance().getColor(foldingFg));
                RGB foldingBg = this.parseRGB(foldingBgColor);
                this.colorizer.setFoldingBg(UnifiedColorManager.getInstance().getColor(foldingBg));
            }
        }
    }

    public void exitColorizer(String ns, String name, String qname) {
        this.styles.clear();
        if (this.waitingElements.isEmpty() && this.registerColorizer) {
            LanguageRegistry.registerLanguageColorizer(this.mimeType, this.colorizer);
        }
        this.waitingElements.clear();
        this.regionsToToken.clear();
        this.categoriesToToken.clear();
    }

    public void enterCategory(String ns, String name, String qname, Attributes attributes) {
        this.currentCategory = attributes.getValue("name");
        String style = attributes.getValue("style");
        if (this.containsCategory(this.currentCategory)) {
            this.styleCategory(this.colorizer, this.currentCategory, style);
        } else {
            this.currentCategory = null;
        }
    }

    public void exitCategory(String ns, String name, String qname) {
        this.currentCategory = null;
    }

    public void enterToken(String ns, String name, String qname, Attributes attributes) {
        String category;
        String type = attributes.getValue("type");
        String string = category = this.currentCategory == null ? attributes.getValue("category") : this.currentCategory;
        if (category != null) {
            String style = attributes.getValue("style");
            IToken token = this.getToken(category, type);
            if (token != null) {
                this.currentToken = token;
                this.styleToken(this.colorizer, token, style);
            }
        }
    }

    public void exitToken(String ns, String name, String qname) {
        this.currentToken = null;
    }

    public void enterStyle(String ns, String name, String qname, Attributes attributes) {
        ColorizationStyle style = new ColorizationStyle();
        String id = attributes.getValue("id");
        String fg = attributes.getValue("foreground");
        String bg = attributes.getValue("background");
        String bold = attributes.getValue("font-weight");
        String italic = attributes.getValue("font-style");
        String ul = attributes.getValue("text-decoration");
        if (this.styles.containsKey(id)) {
            this.sendWarning("Ignorning declaration of duplicate style \"" + id + "\"");
            return;
        }
        style.setName(id);
        RGB rgb = this.parseRGB(fg);
        style.setForegroundColor(UnifiedColorManager.getInstance().getColor(rgb));
        if (bg != null) {
            rgb = this.parseRGB(bg);
            style.setBackgroundColor(UnifiedColorManager.getInstance().getColor(rgb));
        }
        if ("bold".equalsIgnoreCase(bold)) {
            style.setBold(true);
        }
        if ("italic".equalsIgnoreCase(italic)) {
            style.setItalic(true);
        }
        if ("underline".equalsIgnoreCase(ul)) {
            style.setUnderline(true);
        }
        this.styles.put(id, style);
        if (this.waitingElements.containsValue(id)) {
            Iterator<Object> waitingList = this.waitingElements.keySet().iterator();
            while (waitingList.hasNext()) {
                Object curr = waitingList.next();
                if (!id.equals(this.waitingElements.get(curr))) continue;
                if (curr instanceof IToken) {
                    waitingList.remove();
                    this.styleToken(this.colorizer, (IToken)curr, id);
                    continue;
                }
                if (curr instanceof String) {
                    waitingList.remove();
                    this.styleCategory(this.colorizer, (String)curr, id);
                    continue;
                }
                if (!(curr instanceof Region)) continue;
                waitingList.remove();
                IToken token = this.regionsToToken.get(curr);
                this.styleRegion(this.colorizer, token, (Region)curr, id);
            }
        }
    }

    public void enterRegion(String ns, String name, String qname, Attributes attributes) {
        String style = attributes.getValue("style");
        String offset = attributes.getValue("offset").trim();
        String length = attributes.getValue("length").trim();
        String id = attributes.getValue("name");
        boolean offsetRelative = false;
        boolean lengthRelative = false;
        if (this.currentToken != null) {
            int offsetInt;
            try {
                if (offset.startsWith("LENGTH")) {
                    offsetInt = Integer.parseInt(offset.substring("LENGTH".length(), offset.length()));
                    offsetRelative = true;
                } else {
                    offsetInt = Integer.parseInt(offset);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.sendError("Number format exception in length of region " + id);
                return;
            }
            try {
                int lengthInt;
                if (length.startsWith("LENGTH")) {
                    lengthInt = Integer.parseInt(length.substring("LENGTH".length(), length.length()));
                    lengthRelative = true;
                } else {
                    lengthInt = Integer.parseInt(length);
                }
                Region region = new Region(offsetInt, offsetRelative, lengthInt, lengthRelative, null);
                region.setLengthString(length);
                region.setOffsetString(offset);
                region.setName(id);
                this.regionsToToken.put(region, this.currentToken);
                this.styleRegion(this.colorizer, this.currentToken, region, style);
            }
            catch (NumberFormatException numberFormatException) {
                this.sendError("Number format exception in offset of region " + id);
                return;
            }
        }
    }

    public void exitRegion(String ns, String name, String qname) {
    }

    public void characters(char[] buffer, int offset, int length) {
    }

    public void restoreDefault(String language) {
        URL url = this.urls.get(language);
        String id = this.ids.get(language);
        if (url != null && id != null) {
            this.loadColorizationFromURL(url, id, true);
        }
    }

    public void setPreferenceId(String language, String preferenceId) {
        this.ids.put(language, preferenceId);
    }

    public InstanceCreator getInstanceCreator(String language) {
        return this.instanceCreators.get(language);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Schema createSchema() {
        InputStream schemaStream;
        block10: {
            Schema schema2;
            schemaStream = ColorizerReader.class.getResourceAsStream(SCHEMA);
            try {
                Schema schema;
                schema2 = schema = SchemaBuilder.fromXML((InputStream)schemaStream, (Object)((Object)this));
            }
            catch (SchemaInitializationException schemaInitializationException) {
                try {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.ColorizerReader_ERROR_LOADING_SCHEMA);
                    break block10;
                }
                catch (Throwable throwable) {
                    try {
                        schemaStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                schemaStream.close();
                return schema2;
            }
            catch (IOException iOException) {}
            return schema2;
        }
        try {
            schemaStream.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    private ITokenList getDefaultTokenList() {
        if (this.defaultTokenList != null) {
            return this.defaultTokenList;
        }
        return LanguageRegistry.getTokenList(this.mimeType);
    }
}

