/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.editors.ISaveAsEvent;
import com.aptana.ide.core.ui.editors.ISaveEvent;
import com.aptana.ide.core.ui.views.IRefreshableView;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.actions.OpenDeclarationAction;
import com.aptana.ide.editors.actions.ShowWhitespace;
import com.aptana.ide.editors.formatting.UnifiedBracketInserterManager;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.unified.AbstractPairFinder;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IPairFinder;
import com.aptana.ide.editors.unified.IPairMatchExt;
import com.aptana.ide.editors.unified.IRedrawRangeListener;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UnifiedColorizer;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.editors.unified.UnifiedDocumentPartitioner;
import com.aptana.ide.editors.unified.UnifiedReconcilingStrategy;
import com.aptana.ide.editors.unified.UnifiedViewer;
import com.aptana.ide.editors.unified.actions.CodeFormatAction;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.colorizer.UnifiedCursorLinePainter;
import com.aptana.ide.editors.unified.contentassist.ContentAssistAction;
import com.aptana.ide.editors.unified.context.ContextItem;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.editors.unified.errors.ExternalFileErrorListener;
import com.aptana.ide.editors.unified.errors.FileErrorListener;
import com.aptana.ide.editors.unified.errors.ProjectFileErrorListener;
import com.aptana.ide.editors.unified.folding.FoldingExtensionPointLoader;
import com.aptana.ide.editors.unified.folding.LanguageProjectAnnotation;
import com.aptana.ide.editors.unified.help.LexemeUIHelp;
import com.aptana.ide.editors.unified.messaging.UnifiedMessages;
import com.aptana.ide.editors.unified.painting.WhitespacePainter;
import com.aptana.ide.editors.unified.utils.DragAndDropInstaller;
import com.aptana.ide.editors.untitled.BaseTextEditor;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.ui.editors.FindNextAction;
import com.aptana.ide.ui.editors.FindReplaceAction;
import com.aptana.ide.views.outline.UnifiedOutlinePage;
import com.aptana.ide.views.outline.UnifiedQuickOutlinePage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.UnifiedLineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.UnifiedOverviewRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.text.source.projection.UnifiedProjectionSupport;
import org.eclipse.jface.text.source.projection.UnifiedRulerColumn;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.BookmarkRulerAction;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TaskRulerAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class UnifiedEditor
extends BaseTextEditor
implements IUnifiedEditor,
IPropertyChangeListener,
ISelectionChangedListener,
IRedrawRangeListener {
    public static final String FIND_REPLACE = "com.aptana.ide.core.ui.FindReplaceAction";
    public static final String FIND_NEXT = "com.aptana.ide.core.ui.FindNextAction";
    public static final String FIND_PREVIOUS = "com.aptana.ide.core.ui.FindPreviousAction";
    public static final String ADD_BOOKMARK = "AddBookmark";
    public static final String ADD_TASK = "AddTask";
    public static boolean ctrlDown;
    protected UnifiedOutlinePage outlinePage;
    protected boolean autoActivateCodeAssist = true;
    protected ListenerList fileServiceChangeListeners = new ListenerList();
    private UnifiedColorizer _colorizer;
    private IUnifiedEditorContributor _baseContributor;
    private FileErrorListener _errorListener;
    private WhitespacePainter _whitespacePainter;
    private EditorFileContext _fileContextWrapper;
    private ArrayList<ISaveAsEvent> _saveAsListeners;
    private ArrayList<ISaveEvent> _saveListeners;
    private IRefreshableView _fileExplorerView;
    private IPreferenceStore _prefStore;
    private IPartListener _partListener;
    private UnifiedProjectionSupport _projectionSupport;
    private Listener _keyUpListener;
    private VerifyKeyListener _verifyKeyListener;
    private UnifiedViewer _viewer;
    private IContextAwareness _contextAwareness;
    private boolean _isDisposing = false;
    private boolean _hasKeyBeenPressed = false;
    private LineStyleListener _lineStyleListener;
    private TextChangeListener _textChangeListener;
    private PairMatcher _pairMatcher;
    private Image _caretImage;
    private UnifiedCursorLinePainter _painter;
    private int _maxColorizingColumns;
    private boolean _extendedStylesEnabled;
    private SelectionAdapter _selectionListener;
    private FocusAdapter _focusListener;
    private ITextListener _textListener;
    private IPreferenceStore _runtimeStore = new PreferenceStore();
    private UnifiedBracketInserterManager _bracketInserterManager;
    private CodeFormatAction _formatAction;
    private IRange underLine;

    public UnifiedEditor() {
        this.addPluginToPreferenceStore(UnifiedEditorsPlugin.getDefault());
        this._saveListeners = new ArrayList();
        this._saveAsListeners = new ArrayList();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IUnifiedEditorContributor[] contributors;
        this._baseContributor = this.createLocalContributor();
        this._colorizer = UnifiedColorizer.getInstance();
        this.setSourceViewerConfiguration(new UnifiedConfiguration(this, this.getPreferenceStore()));
        this.getFileServiceFactory();
        this._prefStore = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        this._prefStore = this._prefStore == null ? null : this._prefStore;
        this.setDocumentProvider(this.createDocumentProvider());
        this._fileContextWrapper = new EditorFileContext();
        this._baseContributor.setFileContext(this._fileContextWrapper);
        this.syncFoldingPreferenceStore();
        super.init(site, input);
        this.setEditorContextMenuId(String.valueOf(this.getSite().getId()) + "#UnifiedEditorContext");
        this.setRulerContextMenuId(String.valueOf(this.getSite().getId()) + "#UnifiedRulerContext");
        IPreferenceStore localPreferenceStore = this.getPreferenceStore();
        if (localPreferenceStore != null) {
            this.autoActivateCodeAssist = localPreferenceStore.getBoolean("com.aptana.ide.editors.CODE_ASSIST_AUTO_ACTIVATION");
        }
        if ((contributors = this._baseContributor.getChildContributors()) != null && !this.autoActivateCodeAssist) {
            int i = 0;
            while (i < contributors.length) {
                boolean bl = this.autoActivateCodeAssist = this.autoActivateCodeAssist || contributors[i].isAutoActivateContentAssist();
                if (this.autoActivateCodeAssist) break;
                ++i;
            }
        }
    }

    private void syncFoldingPreferenceStore() {
        String language;
        LanguageColorizer colorizer;
        if (this._baseContributor != null && (colorizer = LanguageRegistry.getLanguageColorizer(language = this._baseContributor.getLocalContentType())) != null && colorizer.getFoldingBg() != null) {
            this._runtimeStore.setDefault("AbstractTextEditor.Color.Background.SystemDefault", true);
            this._runtimeStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", false);
            PreferenceConverter.setValue((IPreferenceStore)this._runtimeStore, (String)"AbstractTextEditor.Color.Background", (RGB)colorizer.getFoldingBg().getRGB());
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add(this.getAction(ADD_BOOKMARK));
        menu.add(this.getAction(ADD_TASK));
        menu.add((IContributionItem)new Separator("source"));
        menu.add((IAction)this._formatAction);
        this._formatAction.setActiveEditor(null, (IEditorPart)this);
        menu.add((IContributionItem)new Separator());
        super.rulerContextMenuAboutToShow(menu);
        FoldingExtensionPointLoader.fillRulerContextMenu(this, menu);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("debug"));
        super.editorContextMenuAboutToShow(menu);
        IUnifiedEditorContributor contributor = this.getBaseContributor();
        if (contributor != null) {
            String mimeType = contributor.getLocalContentType();
            if (mimeType != null && LanguageRegistry.getCodeFormatter(mimeType) != null) {
                menu.add((IContributionItem)new Separator("source"));
                menu.add((IAction)this._formatAction);
                this._formatAction.setActiveEditor(null, (IEditorPart)this);
            }
            OpenDeclarationAction openDelcaration = new OpenDeclarationAction();
            openDelcaration.setActiveEditor(this, this.getFileContext().getLanguageService(mimeType));
            menu.add((IAction)openDelcaration);
        }
    }

    protected void addPluginToPreferenceStore(AbstractUIPlugin plugin) {
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this._runtimeStore, this.getPreferenceStore(), plugin.getPreferenceStore()}));
    }

    public void createPartControl(Composite parent) {
        ProjectionViewer viewer;
        super.createPartControl(parent);
        boolean dnd = this.getPreferenceStore().getBoolean("com.aptana.ide.editors.DRAG_AND_DROP_ENABLED");
        String version = System.getProperty("osgi.framework.version");
        if (dnd && version != null && version.length() >= 3) {
            char minor = version.charAt(2);
            try {
                int iMinor = Integer.parseInt(String.valueOf(minor));
                if (iMinor < 3) {
                    DragAndDropInstaller.installTextDragAndDrop((ISourceViewer)this.getSourceViewer(), (AbstractTextEditor)this);
                }
            }
            catch (NumberFormatException e) {
                IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Error parsing osgi.framework.version", (Throwable)e);
            }
        }
        if ((viewer = (ProjectionViewer)this.getSourceViewer()).canDoOperation(19)) {
            viewer.doOperation(19);
        }
        this.showWhitespace(ShowWhitespace.isInstanceChecked());
        this._maxColorizingColumns = this.getPreferenceStore().getInt("com.aptana.ide.editor.COLORIZER_MAXCOLUMNS");
        this.linkColorer();
        this.linkPairMatcher();
        this._extendedStylesEnabled = this.getPreferenceStore().getBoolean("com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_ENABLED");
        if (this._extendedStylesEnabled) {
            this.installTextOccurrenceHighlightSupport();
        }
        LexemeUIHelp.setHelp(this, this.getViewer().getTextWidget(), this.getFileContext());
        this.setEditorOptions();
    }

    private void setEditorOptions() {
        if (this.getBaseContributor() == null || this.getViewer() == null || this.getViewer().getTextWidget() == null) {
            return;
        }
        String language = this.getBaseContributor().getLocalContentType();
        LanguageColorizer colorizer = LanguageRegistry.getLanguageColorizer(language);
        if (colorizer != null && colorizer.getLineHighlightColor() != null && colorizer.getCaretColor() != null && colorizer.getBackground() != null && colorizer.getSelectionForeground() != null && colorizer.getSelectionBackground() != null) {
            Color bg;
            Color deadSpace;
            if (this.getViewer() instanceof ITextViewerExtension2) {
                ITextViewerExtension2 highlightEditor = (ITextViewerExtension2)this.getViewer();
                if (this.getViewer().getTextWidget() != null) {
                    if (this._painter != null) {
                        highlightEditor.removePainter((IPainter)this._painter);
                    }
                    this._painter = new UnifiedCursorLinePainter(this, (ITextViewer)this.getViewer());
                    this._painter.setHighlightColor(colorizer.getLineHighlightColor());
                    highlightEditor.addPainter((IPainter)this._painter);
                    if (this._selectionListener != null) {
                        this.getViewer().getTextWidget().removeSelectionListener((SelectionListener)this._selectionListener);
                    }
                    if (this._focusListener != null) {
                        this.getViewer().getTextWidget().removeFocusListener((FocusListener)this._focusListener);
                    }
                    if (this._textListener != null) {
                        this.getViewer().removeTextListener(this._textListener);
                    }
                    this._selectionListener = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
                            if (UnifiedEditor.this._painter != null && text != null && !text.isDisposed()) {
                                Point p = text.getSelectionRange();
                                if (p.y == 0) {
                                    UnifiedEditor.this._painter.paintLines(0, text.getLineCount());
                                    text.redraw();
                                    text.update();
                                }
                            }
                        }
                    };
                    this._focusListener = new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
                            if (UnifiedEditor.this._painter != null && text != null && !text.isDisposed()) {
                                Point p = text.getSelectionRange();
                                if (p.y > 0) {
                                    UnifiedEditor.this._painter.paintLines(0, text.getLineCount());
                                }
                            }
                        }
                    };
                    this._textListener = new ITextListener(){

                        public void textChanged(TextEvent event) {
                            StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
                            if (UnifiedEditor.this._painter != null && text != null && !text.isDisposed()) {
                                Point p = text.getSelectionRange();
                                if (p.y > 0) {
                                    UnifiedEditor.this._painter.paintLines(0, text.getLineCount());
                                }
                            }
                        }
                    };
                    this.getViewer().addTextListener(this._textListener);
                    this.getViewer().getTextWidget().addFocusListener((FocusListener)this._focusListener);
                    this.getViewer().getTextWidget().addSelectionListener((SelectionListener)this._selectionListener);
                    if (this.isWordWrapEnabled()) {
                        this.getViewer().getTextWidget().setWordWrap(true);
                        this.getViewer().getTextWidget().addControlListener((ControlListener)new ControlAdapter(){

                            public void controlResized(ControlEvent e) {
                                IOverviewRuler overviewRuler;
                                IVerticalRuler ruler;
                                UnifiedRulerColumn column;
                                if (UnifiedEditor.this._projectionSupport != null && (column = UnifiedEditor.this._projectionSupport.getRulerColumn()) != null) {
                                    column.redraw();
                                }
                                if ((ruler = UnifiedEditor.this.getVerticalRuler()) instanceof CompositeRuler) {
                                    Iterator columnIter = ((CompositeRuler)ruler).getDecoratorIterator();
                                    while (columnIter.hasNext()) {
                                        Object column2 = columnIter.next();
                                        if (!(column2 instanceof AnnotationRulerColumn)) continue;
                                        ((AnnotationRulerColumn)column2).redraw();
                                    }
                                }
                                if (((AbstractDecoratedTextEditor)UnifiedEditor.this).fLineNumberRulerColumn != null) {
                                    ((AbstractDecoratedTextEditor)UnifiedEditor.this).fLineNumberRulerColumn.redraw();
                                }
                                if ((overviewRuler = UnifiedEditor.this.getOverviewRuler()) != null) {
                                    overviewRuler.update();
                                }
                            }
                        });
                    }
                }
            }
            this.setFoldingColors(colorizer);
            if (!Platform.getOS().equals("macosx") && this.getViewer().getTextWidget() != null) {
                Caret caret = this.getViewer().getTextWidget().getCaret();
                RGB converted = new RGB(0, 0, 0);
                converted.red = Math.abs(colorizer.getCaretColor().getRed() - colorizer.getLineHighlightColor().getRed());
                converted.blue = Math.abs(colorizer.getCaretColor().getBlue() - colorizer.getLineHighlightColor().getBlue());
                converted.green = Math.abs(colorizer.getCaretColor().getGreen() - colorizer.getLineHighlightColor().getGreen());
                PaletteData data = new PaletteData(new RGB[]{converted});
                int x = caret.getSize().x;
                int y = caret.getSize().y;
                if (x > 0 && y > 0) {
                    try {
                        ImageData iData = new ImageData(x, y, 1, data);
                        if (this._caretImage != null) {
                            this._caretImage.dispose();
                        }
                        this._caretImage = new Image((Device)caret.getDisplay(), iData);
                        caret.setImage(this._caretImage);
                    }
                    catch (Error error) {
                    }
                    catch (Exception exception) {}
                }
            }
            if ((deadSpace = this.createDeadSpaceColor(bg = colorizer.getBackground())) != null) {
                this.getViewer().getTextWidget().setBackground(deadSpace);
            } else {
                this.getViewer().getTextWidget().setBackground(bg);
            }
            this.getViewer().getTextWidget().setSelectionBackground(colorizer.getSelectionBackground());
            this.getViewer().getTextWidget().setSelectionForeground(colorizer.getSelectionForeground());
        } else {
            Color deadSpace;
            IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
            RGB background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
            RGB selectionFg = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.SelectionForeground");
            RGB selectionBg = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.SelectionBackground");
            Color eclipseBackgroundColor = UnifiedColorManager.getInstance().getColor(background);
            if (store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault")) {
                eclipseBackgroundColor = null;
            }
            Color eclipseSelectionFgColor = UnifiedColorManager.getInstance().getColor(selectionFg);
            if (store.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault")) {
                eclipseSelectionFgColor = null;
            }
            Color eclipseSelectionBgColor = UnifiedColorManager.getInstance().getColor(selectionBg);
            if (store.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault")) {
                eclipseSelectionBgColor = null;
            }
            if ((deadSpace = this.createDeadSpaceColor(eclipseBackgroundColor)) != null) {
                this.getViewer().getTextWidget().setBackground(deadSpace);
            } else {
                this.getViewer().getTextWidget().setBackground(eclipseBackgroundColor);
            }
            this.getViewer().getTextWidget().setSelectionBackground(eclipseSelectionBgColor);
            this.getViewer().getTextWidget().setSelectionForeground(eclipseSelectionFgColor);
            Caret caret = this.getViewer().getTextWidget().getCaret();
            if (this._caretImage != null) {
                this._caretImage.dispose();
            }
            caret.setImage(null);
            if (this.getViewer() instanceof ITextViewerExtension2) {
                ITextViewerExtension2 highlightEditor = (ITextViewerExtension2)this.getViewer();
                if (this._painter != null) {
                    highlightEditor.removePainter((IPainter)this._painter);
                }
            }
        }
    }

    protected void setFoldingColors(LanguageColorizer colorizer) {
        UnifiedReconcilingStrategy strategy;
        SourceViewerConfiguration config;
        if (colorizer.getFoldingFg() != null && (config = this.getSourceViewerConfiguration()) instanceof UnifiedConfiguration && (strategy = ((UnifiedConfiguration)config).getStrategy()) != null) {
            strategy.setFoldingAnnotationHoverColor(colorizer.getFoldingFg());
        }
        if (colorizer.getFoldingBg() != null) {
            UnifiedRulerColumn column;
            if (this._projectionSupport != null && (column = this._projectionSupport.getRulerColumn()) != null) {
                column.setBackground(colorizer.getFoldingBg());
            }
            if (this.fLineNumberRulerColumn != null && this.fLineNumberRulerColumn.getControl() != null && !this.fLineNumberRulerColumn.getControl().isDisposed()) {
                if (this.fLineNumberRulerColumn instanceof UnifiedLineNumberChangeRulerColumn) {
                    ((UnifiedLineNumberChangeRulerColumn)this.fLineNumberRulerColumn).setTextWidget(this.getViewer().getTextWidget());
                    ((UnifiedLineNumberChangeRulerColumn)this.fLineNumberRulerColumn).setSourceViewer(this.getViewer());
                }
                this.fLineNumberRulerColumn.setBackground(colorizer.getFoldingBg());
                this.fLineNumberRulerColumn.redraw();
            }
        }
    }

    private boolean isWordWrapEnabled() {
        return UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editor.ENABLE_WORD_WRAP");
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        if (this.isWordWrapEnabled()) {
            if (this.isPrefQuickDiffAlwaysOn()) {
                UnifiedLineNumberChangeRulerColumn column = new UnifiedLineNumberChangeRulerColumn(this.getSharedColors());
                if (this.getViewer() != null) {
                    column.setSourceViewer(this.getViewer());
                    column.setTextWidget(this.getViewer().getTextWidget());
                }
                column.setHover((IAnnotationHover)this.createChangeHover());
                this.fLineNumberRulerColumn = column;
            } else {
                this.fLineNumberRulerColumn = new UnifiedLineNumberChangeRulerColumn(this.getSharedColors());
                if (this.getViewer() != null) {
                    ((UnifiedLineNumberChangeRulerColumn)this.fLineNumberRulerColumn).setSourceViewer(this.getViewer());
                    ((UnifiedLineNumberChangeRulerColumn)this.fLineNumberRulerColumn).setTextWidget(this.getViewer().getTextWidget());
                }
            }
            this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
            return this.fLineNumberRulerColumn;
        }
        return super.createLineNumberRulerColumn();
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        if (this.isWordWrapEnabled()) {
            UnifiedOverviewRuler ruler = new UnifiedOverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
            for (AnnotationPreference preference : EditorsPlugin.getDefault().getMarkerAnnotationPreferences().getAnnotationPreferences()) {
                if (!preference.contributesToHeader()) continue;
                ruler.addHeaderAnnotationType(preference.getAnnotationType());
            }
            return ruler;
        }
        return super.createOverviewRuler(sharedColors);
    }

    private Color createDeadSpaceColor(Color bg) {
        if (bg != null) {
            int factor = 4;
            boolean canGoDarker = bg.getRed() - factor > 0 || bg.getGreen() - factor > 0 || bg.getBlue() - factor > 0;
            boolean canGoLighter = bg.getRed() + factor > 0 || bg.getGreen() + factor > 0 || bg.getBlue() + factor > 0;
            int red = 0;
            int green = 0;
            int blue = 0;
            if (canGoDarker) {
                red = bg.getRed() - factor > 0 ? bg.getRed() - factor : bg.getRed();
                green = bg.getGreen() - factor > 0 ? bg.getGreen() - factor : bg.getGreen();
                blue = bg.getBlue() - factor > 0 ? bg.getBlue() - factor : bg.getBlue();
            } else if (canGoLighter) {
                red = bg.getRed() + factor > 0 ? bg.getRed() + factor : bg.getRed();
                green = bg.getGreen() + factor > 0 ? bg.getGreen() + factor : bg.getGreen();
                int n = blue = bg.getBlue() + factor > 0 ? bg.getBlue() + factor : bg.getBlue();
            }
            if (canGoDarker || canGoLighter) {
                Color deadSpace = UnifiedColorManager.getInstance().getColor(new RGB(red, green, blue));
                return deadSpace;
            }
        }
        return null;
    }

    private void installTextOccurrenceHighlightSupport() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this._extendedStylesEnabled = true;
    }

    private void uninstallTextOccurrenceHighlightSupport() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
        this.removeMarkedOccurrences();
        this._extendedStylesEnabled = false;
    }

    void removeUnderlinedRange(IRange range) {
        this.underLine = range;
        StyledText textWidget = this.getViewer().getTextWidget();
        try {
            textWidget.redrawRange(range.getStartingOffset(), range.getLength(), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void redrawRange(final IRange range) {
        if (range != null) {
            final StyledText textWidget = this.getViewer().getTextWidget();
            Display display = textWidget.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        textWidget.redrawRange(range.getStartingOffset(), range.getLength(), true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            });
        }
    }

    void setUnderlinedRange(IRange range) {
        if (range != null) {
            this.underLine = null;
            StyledText textWidget = this.getViewer().getTextWidget();
            try {
                textWidget.redrawRange(range.getStartingOffset(), range.getLength(), true);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void linkColorer() {
        if (this._lineStyleListener == null) {
            this._lineStyleListener = new LineStyleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void lineGetStyle(LineStyleEvent e) {
                    UnifiedViewer rr;
                    TextPresentation textPresentation;
                    int orgOffset;
                    EditorFileContext fileContext = UnifiedEditor.this.getFileContext();
                    if (fileContext == null || fileContext.getFileContext() == null) {
                        return;
                    }
                    IParseState parseState = fileContext.getParseState();
                    if (parseState == null) {
                        return;
                    }
                    LexemeList lexemeList = parseState.getLexemeList();
                    if (lexemeList == null) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedEditor_LexemeListIsNull);
                        return;
                    }
                    int offset = orgOffset = e.lineOffset;
                    int extra = 0;
                    int lineLength = e.lineText.length();
                    if (UnifiedEditor.this._viewer instanceof ITextViewerExtension5) {
                        UnifiedViewer v5 = UnifiedEditor.this._viewer;
                        offset = v5.widgetOffset2ModelOffset(e.lineOffset);
                        extra = offset - e.lineOffset;
                    }
                    int maxLineLength = !UnifiedEditor.this.isWordWrapEnabled() && lineLength > UnifiedEditor.this._maxColorizingColumns ? UnifiedEditor.this._maxColorizingColumns : lineLength;
                    Lexeme[] lexemes = null;
                    LexemeList lexemeList2 = lexemeList;
                    synchronized (lexemeList2) {
                        int startingIndex = lexemeList.getLexemeCeilingIndex(offset);
                        int endingIndex = lexemeList.getLexemeFloorIndex(offset + maxLineLength);
                        if (startingIndex == -1 && endingIndex != -1) {
                            startingIndex = endingIndex;
                        }
                        if (endingIndex == -1 && startingIndex != -1) {
                            endingIndex = startingIndex;
                        }
                        if (startingIndex != -1 && endingIndex != -1) {
                            lexemes = lexemeList.cloneRange(startingIndex, endingIndex);
                        }
                    }
                    if (lexemes != null) {
                        StyleRange styleRange;
                        int a;
                        Vector<StyleRange> styles = new Vector<StyleRange>();
                        UnifiedEditor.this._colorizer.createStyles(parseState, styles, lexemes, UnifiedEditor.this._extendedStylesEnabled);
                        StyleRange[] styleResults = styles.toArray(new StyleRange[0]);
                        if (extra > 0) {
                            int i = 0;
                            while (i < styleResults.length) {
                                StyleRange range = styleResults[i];
                                range.start -= extra;
                                ++i;
                            }
                        }
                        if (UnifiedEditor.this.underLine != null) {
                            a = 0;
                            while (a < styleResults.length) {
                                styleRange = styleResults[a];
                                if (styleRange.start == UnifiedEditor.this.underLine.getStartingOffset() && styleRange.start + styleRange.length == UnifiedEditor.this.underLine.getEndingOffset()) {
                                    styleRange.underline = true;
                                }
                                ++a;
                            }
                        } else {
                            a = 0;
                            while (a < styleResults.length) {
                                styleRange = styleResults[a];
                                styleRange.underline = false;
                                ++a;
                            }
                        }
                        e.styles = styleResults;
                    }
                    if ((textPresentation = (rr = (UnifiedViewer)UnifiedEditor.this.getViewer()).getTextPresentation()) != null) {
                        TextPresentation ps = new TextPresentation();
                        if (e.styles != null) {
                            ps.replaceStyleRanges(e.styles);
                        }
                        Iterator nonDefaultStyleRangeIterator = textPresentation.getNonDefaultStyleRangeIterator();
                        while (nonDefaultStyleRangeIterator.hasNext()) {
                            ps.mergeStyleRange((StyleRange)((StyleRange)nonDefaultStyleRangeIterator.next()).clone());
                        }
                        Iterator nonDefaultStyleRangeIterator2 = ps.getNonDefaultStyleRangeIterator();
                        ArrayList<StyleRange> rs = new ArrayList<StyleRange>();
                        while (nonDefaultStyleRangeIterator2.hasNext()) {
                            StyleRange next = (StyleRange)nonDefaultStyleRangeIterator2.next();
                            rs.add(next);
                        }
                        e.styles = rs.toArray(new StyleRange[rs.size()]);
                    }
                }
            };
        }
        if (this._textChangeListener == null) {
            this._textChangeListener = new TextChangeListener(){

                public void textChanging(TextChangingEvent event) {
                }

                public void textChanged(TextChangedEvent event) {
                    StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
                    this.redrawFrom(text, text.getLineAtOffset(text.getCaretOffset()));
                }

                public void textSet(TextChangedEvent event) {
                    StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
                    this.redrawFrom(text, 0);
                }

                private void redrawFrom(StyledText text, int lno) {
                    if (lno < 0 || lno >= text.getLineCount()) {
                        return;
                    }
                    int height = text.getClientArea().height;
                    int width = text.getClientArea().width + text.getHorizontalPixel();
                    try {
                        text.redraw(0, 0, width, height, true);
                    }
                    catch (Exception exception) {}
                }
            };
        }
        this.getViewer().getTextWidget().addLineStyleListener(this._lineStyleListener);
        this.getViewer().getTextWidget().getContent().addTextChangeListener(this._textChangeListener);
    }

    private void linkPairMatcher() {
        if (this._pairMatcher == null) {
            this._pairMatcher = new PairMatcher();
            StyledText text = this.getViewer().getTextWidget();
            text.addPaintListener((PaintListener)this._pairMatcher);
            text.addKeyListener((KeyListener)this._pairMatcher);
            text.addTraverseListener((TraverseListener)this._pairMatcher);
            text.addMouseListener((MouseListener)this._pairMatcher);
            text.addSelectionListener((SelectionListener)this._pairMatcher);
            ScrollBar sb = text.getVerticalBar();
            if (sb != null) {
                sb.addSelectionListener((SelectionListener)this._pairMatcher);
            }
        }
    }

    private void unlinkPairMatcher() {
        if (this._pairMatcher != null) {
            if (this.getViewer() == null) {
                return;
            }
            StyledText text = this.getViewer().getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            text.removePaintListener((PaintListener)this._pairMatcher);
            text.removeKeyListener((KeyListener)this._pairMatcher);
            text.removeTraverseListener((TraverseListener)this._pairMatcher);
            text.removeMouseListener((MouseListener)this._pairMatcher);
            text.removeSelectionListener((SelectionListener)this._pairMatcher);
            ScrollBar sb = text.getVerticalBar();
            if (sb != null) {
                sb.removeSelectionListener((SelectionListener)this._pairMatcher);
            }
        }
    }

    public PairMatch getPairMatch(int offset) {
        IParseState parseState = this.getFileContext().getParseState();
        if (parseState == null) {
            return null;
        }
        LexemeList lexemeList = parseState.getLexemeList();
        Lexeme cursorLexeme = lexemeList.getLexemeFromOffset(offset);
        if (cursorLexeme == null && offset > 0) {
            cursorLexeme = lexemeList.getLexemeFromOffset(offset - 1);
        }
        if (cursorLexeme == null) {
            return null;
        }
        String language = cursorLexeme.getLanguage();
        IPairFinder finder = LanguageRegistry.getPairFinder(language);
        PairMatch match = null;
        if (finder != null && !finder.doNotDisplay()) {
            if (finder instanceof AbstractPairFinder) {
                int loopCount = 2;
                match = ((AbstractPairFinder)finder).findPairMatch(offset, parseState, cursorLexeme, loopCount);
            } else {
                match = finder.findPairMatch(offset, parseState);
            }
        }
        if (match != null) {
            match.setColor(finder.getPairFinderColor());
            match.setDisplayOnlyMatch(finder.displayOnlyMatch());
            match.offset = offset;
            if (match instanceof IPairMatchExt) {
                List<PairMatch> subsequentMatches = ((IPairMatchExt)((Object)match)).getSubsequentMatches();
                for (PairMatch subMatch : subsequentMatches) {
                    subMatch.setColor(finder.getPairFinderColor());
                    subMatch.setDisplayOnlyMatch(finder.displayOnlyMatch());
                    subMatch.offset = offset;
                }
            }
        }
        return match;
    }

    protected Lexeme findBalancingLexeme(int startIndex, String language, int startType, int endType, int direction) {
        LexemeList lexemeList = this.getFileContext().getParseState().getLexemeList();
        return UnifiedEditor.findBalancingLexeme(lexemeList, startIndex, language, startType, endType, direction);
    }

    public static Lexeme findBalancingLexeme(LexemeList lexemeList, int startIndex, String language, int startType, int endType, int direction) {
        Lexeme result = null;
        int count = 0;
        while (startIndex >= 0 && startIndex < lexemeList.size()) {
            result = lexemeList.get(startIndex);
            if (result.getLanguage().equals(language)) {
                if (result.typeIndex == endType) {
                    if (--count == 0) {
                        break;
                    }
                } else if (result.typeIndex == startType) {
                    ++count;
                }
            }
            startIndex += direction;
        }
        if (count != 0) {
            result = null;
        }
        return result;
    }

    public abstract String getDefaultFileExtension();

    public void propertyChange(PropertyChangeEvent e) {
    }

    public boolean isActiveEditor() {
        IEditorPart part = this.getEditorSite().getPage().getActiveEditor();
        if (part == null) {
            return false;
        }
        if (part instanceof IUnifiedEditor) {
            IUnifiedEditor editor = (IUnifiedEditor)part;
            return editor.getEditor() == this;
        }
        return part == this;
    }

    private void onKeyPressed(VerifyEvent event) {
        char c = event.character;
        StyledText styledText = (StyledText)event.widget;
        int keyCode = event.keyCode;
        ITypedRegion reg = this._fileContextWrapper.getPartitionAtOffset(styledText.getCaretOffset());
        if (reg == null) {
            return;
        }
        String contentType = reg.getType();
        IUnifiedEditorContributor contributor = this._baseContributor.findChildContributor(contentType);
        if (contributor != null && contributor.isAutoActivateContentAssist() && contributor.isValidIdentifier(c, keyCode) && this.isLeftCharacterWhitespace(contributor, styledText, c, keyCode)) {
            this.getViewer().getTextWidget().setData("ASSIST_FORCE_ACTIVATION", (Object)true);
            this.showContentAssist();
        }
    }

    private boolean isLeftCharacterWhitespace(IUnifiedEditorContributor contributor, StyledText styledText, char c, int keyCode) {
        int offset = styledText.getCaretOffset();
        if (offset == 0) {
            return true;
        }
        String line = styledText.getText(offset - 1, offset - 1);
        if (line.length() > 0) {
            return contributor.isValidActivationCharacter(line.charAt(0), keyCode);
        }
        return false;
    }

    private void showContentAssist() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    SourceViewer sv = (SourceViewer)UnifiedEditor.this.getSourceViewer();
                    if (sv == null) {
                        return;
                    }
                    Control c = display.getFocusControl();
                    if (c == null || c != sv.getTextWidget()) {
                        return;
                    }
                    if (sv.canDoOperation(13)) {
                        sv.doOperation(13);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedEditor_ErrorContentProposals, (Throwable)e);
                }
            }
        });
    }

    public void showWhitespace(boolean state) {
        ISourceViewer fSourceViewer = this.getSourceViewer();
        if (state) {
            if (this._whitespacePainter == null && fSourceViewer instanceof ITextViewerExtension2) {
                IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
                String spaceChar = store.getString("com.aptana.ide.editor.SPACE_WHITESPACE_STRING");
                String tabChar = store.getString("com.aptana.ide.editor.TAB_WHITESPACE_STRING");
                int maxColorizingColumns = UnifiedEditorsPlugin.getDefault().getPreferenceStore().getInt("com.aptana.ide.editor.COLORIZER_MAXCOLUMNS");
                this._whitespacePainter = new WhitespacePainter((ITextViewer)fSourceViewer, spaceChar, tabChar, maxColorizingColumns);
                this._whitespacePainter.setColor(UnifiedColorManager.getInstance().getColor(new RGB(200, 200, 200)));
                ITextViewerExtension2 extension = (ITextViewerExtension2)fSourceViewer;
                this._whitespacePainter.handleDrawRequest(null);
                extension.addPainter((IPainter)this._whitespacePainter);
            }
        } else if (this._whitespacePainter != null && fSourceViewer instanceof ITextViewerExtension2) {
            ITextViewerExtension2 extension = (ITextViewerExtension2)fSourceViewer;
            extension.removePainter((IPainter)this._whitespacePainter);
            this._whitespacePainter.deactivate(true);
            this._whitespacePainter.dispose();
            this._whitespacePainter = null;
        }
    }

    public void showPianoKeys(boolean state) {
        if (this._painter != null) {
            StyledText text = this.getViewer().getTextWidget();
            this._painter.paintLines(0, text.getLineCount());
        }
    }

    public void updateFoldingStructure(Map annotations) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Collection additions = annotations.values();
        ProjectionAnnotationModel currentModel = this.getProjectionAnnotationModel();
        if (currentModel == null) {
            return;
        }
        Iterator iter = currentModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = currentModel.getPosition((Annotation)annotation);
            if (additions.contains(position)) {
                additions.remove(position);
                continue;
            }
            deletions.add((Annotation)annotation);
        }
        if (annotations.size() != 0 || deletions.size() != 0) {
            currentModel.modifyAnnotations(deletions.toArray(new Annotation[deletions.size()]), annotations, null);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this._viewer = new UnifiedViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport(this._viewer);
        this._projectionSupport = new UnifiedProjectionSupport((ProjectionViewer)this._viewer, this.getAnnotationAccess(), this.getSharedColors());
        this._projectionSupport.install();
        UnifiedViewer sv = this._viewer;
        Display d = this.getSite().getShell().getDisplay();
        this._keyUpListener = new Listener(){

            public void handleEvent(Event e) {
                ctrlDown = false;
            }
        };
        d.addFilter(2, this._keyUpListener);
        this._verifyKeyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                UnifiedEditor.this._hasKeyBeenPressed = true;
                UnifiedEditor.this.onKeyPressed(event);
                ctrlDown = event.keyCode == 262144;
            }
        };
        sv.prependVerifyKeyListener(this._verifyKeyListener);
        SourceViewerConfiguration svc = this.getSourceViewerConfiguration();
        if (svc instanceof UnifiedConfiguration) {
            UnifiedConfiguration uc = (UnifiedConfiguration)svc;
            this._bracketInserterManager = uc.getBracketInserterManager(sv);
            sv.prependVerifyKeyListener(this._bracketInserterManager);
        }
        return this._viewer;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        try {
            IDocumentProvider dp = this.getDocumentProvider();
            if (dp == null) {
                throw new Exception(Messages.UnifiedEditor_DocumentProviderNull);
            }
            IDocument document = dp.getDocument((Object)input);
            DocumentSourceProvider provider = new DocumentSourceProvider(document, input);
            if (provider == null) {
                throw new Exception(Messages.UnifiedEditor_ProviderIsNull);
            }
            boolean isNewInput = this.isNewInput(input);
            this.updateFileInfo(input, provider, document);
            this.updatePartitioner(provider, document, isNewInput);
            this._fileContextWrapper.setFileContext(FileContextManager.get(provider.getSourceURI()));
            this.setErrorListeners(input);
            this.fireNewFileServiceEvent();
            if (this.getViewer() != null && this.getViewer().getTextWidget() != null) {
                this.getViewer().getTextWidget().redraw();
                this.getViewer().getTextWidget().update();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)("Unable to set input in UnifiedEditor: " + e.getMessage()), (Throwable)e);
            Status status = new Status(4, "com.aptana.ide.editors", 0, "Unable to set input in Unified Editor", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public void addFileServiceChangeListener(IFileServiceChangeListener listener) {
        this.fileServiceChangeListeners.add((Object)listener);
    }

    public void removeFileServiceChangeListener(IFileServiceChangeListener listener) {
        this.fileServiceChangeListeners.remove((Object)listener);
    }

    private void fireNewFileServiceEvent() {
        if (this._fileContextWrapper != null && this._fileContextWrapper.getFileContext() != null) {
            final IFileService newService = this._fileContextWrapper.getFileContext();
            Object[] listeners = this.fileServiceChangeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IFileServiceChangeListener l = (IFileServiceChangeListener)listeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.fileServiceChanged(newService);
                    }
                });
                ++i;
            }
        }
    }

    private void setErrorListeners(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            this._errorListener = new ProjectFileErrorListener(file);
        } else if (input instanceof IPathEditorInput || input instanceof NonExistingFileEditorInput) {
            IDocument doc = this.getDocumentProvider().getDocument((Object)input);
            IAnnotationModel ann = this.getDocumentProvider().getAnnotationModel((Object)input);
            this._errorListener = new ExternalFileErrorListener(ann, doc);
        }
        if (this._errorListener != null) {
            this.getFileContext().addErrorListener(this._errorListener);
        }
    }

    protected void updateFileInfo(IEditorInput input, DocumentSourceProvider provider, IDocument document) {
        if (this.isNewInput(input)) {
            IFileServiceFactory fileServiceFactory = this.getFileServiceFactory();
            if (fileServiceFactory != null) {
                FileService context = fileServiceFactory.createFileService(provider, false);
                FileContextManager.add(provider.getSourceURI(), context);
                context.setRedrawRangeListener(this);
            }
            FileContextManager.connectSourceProvider(provider.getSourceURI(), provider);
        }
    }

    private void updatePartitioner(DocumentSourceProvider provider, IDocument document, boolean isNewInput) {
        if (isNewInput) {
            UnifiedDocumentPartitioner partitioner = new UnifiedDocumentPartitioner(provider.getSourceURI());
            partitioner.setLegalContentTypes(this._baseContributor.getContentTypes());
            partitioner.setPartitions();
            if (document instanceof IDocumentExtension3) {
                ((IDocumentExtension3)document).setDocumentPartitioner("__unified_partitioning", (IDocumentPartitioner)partitioner);
            } else {
                throw new IllegalStateException(Messages.UnifiedEditor_DocumentMustBe);
            }
        }
    }

    public EditorFileContext getFileContext() {
        return this._fileContextWrapper;
    }

    protected abstract IUnifiedEditorContributor createLocalContributor();

    public void dispose() {
        SourceViewerConfiguration svc;
        if (this._isDisposing) {
            return;
        }
        this._isDisposing = true;
        if (this._lineStyleListener != null && this.getViewer().getTextWidget() != null && !this.getViewer().getTextWidget().isDisposed()) {
            this.getViewer().getTextWidget().removeLineStyleListener(this._lineStyleListener);
        }
        if (this._textChangeListener != null && this.getViewer().getTextWidget() != null && !this.getViewer().getTextWidget().isDisposed()) {
            this.getViewer().getTextWidget().getContent().removeTextChangeListener(this._textChangeListener);
        }
        this.unlinkPairMatcher();
        if (this._errorListener != null) {
            this.getFileContext().removeErrorListener(this._errorListener);
        }
        if (this._partListener != null) {
            this.getEditorSite().getPage().removePartListener(this._partListener);
            this._partListener = null;
        }
        if (this._keyUpListener != null) {
            Display d = this.getSite().getShell().getDisplay();
            d.removeFilter(2, this._keyUpListener);
            this._keyUpListener = null;
        }
        if (this._verifyKeyListener != null) {
            this._viewer.removeVerifyKeyListener(this._verifyKeyListener);
            this._verifyKeyListener = null;
        }
        if (this._bracketInserterManager != null) {
            this._viewer.removeVerifyKeyListener(this._bracketInserterManager);
            this._bracketInserterManager = null;
        }
        if ((svc = this.getConfiguration()) instanceof UnifiedConfiguration) {
            ((UnifiedConfiguration)svc).dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        this.showWhitespace(false);
        if (this._whitespacePainter != null) {
            this._whitespacePainter.dispose();
        }
        this._saveListeners.clear();
        this._saveAsListeners.clear();
        this._lineStyleListener = null;
        this.outlinePage = null;
        if (this._baseContributor != null) {
            this._baseContributor.setParentConfiguration(null);
            this._baseContributor = null;
        }
        this._errorListener = null;
        this._whitespacePainter = null;
        this._fileExplorerView = null;
        this._prefStore = null;
        this._contextAwareness = null;
        this.disposeDocumentProvider();
        if (this._fileContextWrapper != null) {
            this._fileContextWrapper.deactivateForEditing();
        }
        if (this._extendedStylesEnabled) {
            this.uninstallTextOccurrenceHighlightSupport();
        }
        if (this._caretImage != null) {
            this._caretImage.dispose();
        }
        super.dispose();
    }

    public abstract IFileServiceFactory getFileServiceFactory();

    public Object getAdapter(Class adapter) {
        if (adapter == IContextProvider.class) {
            return LexemeUIHelp.getHelpContextProvider((IWorkbenchPart)this, this.getFileContext());
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public SourceViewerConfiguration getConfiguration() {
        return this.getSourceViewerConfiguration();
    }

    public IContextAwareness getContextAwareness() {
        if (this._contextAwareness == null) {
            this._contextAwareness = new IContextAwareness(){

                public void update(IFileService fileService) {
                }

                public ContextItem getFileContext() {
                    return new ContextItem();
                }
            };
        }
        return this._contextAwareness;
    }

    public UnifiedOutlinePage getOutlinePage() {
        if (this.outlinePage == null || this.outlinePage.getControl() != null && this.outlinePage.getControl().isDisposed()) {
            this.outlinePage = new UnifiedOutlinePage(this);
        }
        return this.outlinePage;
    }

    public UnifiedQuickOutlinePage createQuickOutlinePage() {
        return new UnifiedQuickOutlinePage(this);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        ISourceViewer sourceViewer;
        block30: {
            sourceViewer = this.getSourceViewer();
            if (sourceViewer != null) break block30;
            super.handlePreferenceStoreChanged(event);
            this.setEditorOptions();
            return;
        }
        try {
            try {
                String property = event.getProperty();
                if ("com.aptana.ide.editor.COLORIZER_MAXCOLUMNS".equals(property)) {
                    this._maxColorizingColumns = this.getPreferenceStore().getInt("com.aptana.ide.editor.COLORIZER_MAXCOLUMNS");
                } else if ("tabWidth".equals(property) || "com.aptana.ide.editor.INSERT_SPACES_FOR_TABS".equals(property)) {
                    IPreferenceStore store = this.getPreferenceStore();
                    if (store == null) {
                        throw new Exception(Messages.UnifiedEditor_UnableToRetrievePreferenceStore);
                    }
                    int prefs = store.getInt("tabWidth");
                    SourceViewerConfiguration sv = this.getSourceViewerConfiguration();
                    boolean tabsOrSpaces = store.getBoolean("com.aptana.ide.editor.INSERT_SPACES_FOR_TABS");
                    if (sv != null && sv instanceof UnifiedConfiguration) {
                        UnifiedConfiguration uc = (UnifiedConfiguration)sv;
                        uc.setTabWidth(prefs, tabsOrSpaces, sourceViewer);
                    } else {
                        IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedEditor_ErrorUpdateTabWidth);
                    }
                } else if ("com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_ENABLED".equals(property)) {
                    boolean textHighlightEnabled = this.getPreferenceStore().getBoolean("com.aptana.ide.editors.COLORIZER_TEXT_HIGHLIGHT_ENABLED");
                    if (textHighlightEnabled) {
                        this.installTextOccurrenceHighlightSupport();
                    } else {
                        this.uninstallTextOccurrenceHighlightSupport();
                    }
                } else if (property != null && property.startsWith("com.aptana.ide.editors.EDITOR_FOLDING_ENABLED")) {
                    String language = property.substring("com.aptana.ide.editors.EDITOR_FOLDING_ENABLED".length() + 1, property.length());
                    if (this.getViewer() != null && this.getViewer() instanceof ProjectionViewer) {
                        ProjectionViewer viewer = (ProjectionViewer)this.getViewer();
                        if (UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean(property)) {
                            UnifiedReconcilingStrategy reconciler;
                            if (this.getConfiguration() instanceof UnifiedConfiguration && (reconciler = ((UnifiedConfiguration)this.getConfiguration()).getStrategy()) != null) {
                                reconciler.initialReconcile();
                            }
                        } else if (viewer.getProjectionAnnotationModel() != null) {
                            ArrayList<LanguageProjectAnnotation> mods = new ArrayList<LanguageProjectAnnotation>();
                            Iterator annotationIterator = viewer.getProjectionAnnotationModel().getAnnotationIterator();
                            if (annotationIterator != null) {
                                while (annotationIterator.hasNext()) {
                                    LanguageProjectAnnotation lpa;
                                    Annotation annotation = (Annotation)annotationIterator.next();
                                    if (!(annotation instanceof LanguageProjectAnnotation) || !language.equals((lpa = (LanguageProjectAnnotation)annotation).getLanguage())) continue;
                                    lpa.markDeleted(true);
                                    mods.add(lpa);
                                }
                                viewer.getProjectionAnnotationModel().modifyAnnotations(mods.toArray(new Annotation[mods.size()]), null, null);
                            }
                        }
                    }
                } else if (property != null && property.startsWith("Colorization")) {
                    this.syncFoldingPreferenceStore();
                    if (this.getConfiguration() instanceof UnifiedConfiguration) {
                        UnifiedReconcilingStrategy reconciler = ((UnifiedConfiguration)this.getConfiguration()).getStrategy();
                        ProjectionAnnotationModel currentModel = this.getProjectionAnnotationModel();
                        if (reconciler != null && currentModel != null) {
                            currentModel.removeAllAnnotations();
                            reconciler.initialReconcile();
                        }
                    }
                }
                StyledText viewer = sourceViewer.getTextWidget();
                if (viewer != null) {
                    sourceViewer.getTextWidget().redraw();
                }
            }
            catch (Exception ex) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedEditor_ErrorHandlingPreferenceChange, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            super.handlePreferenceStoreChanged(event);
            this.setEditorOptions();
        }
    }

    private ProjectionAnnotationModel getProjectionAnnotationModel() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (viewer != null) {
            return viewer.getProjectionAnnotationModel();
        }
        return null;
    }

    protected void handleCursorPositionChanged() {
        EditorFileContext fs;
        StyledText styledText = this.getSourceViewer().getTextWidget();
        int offset = styledText.getCaretOffset();
        try {
            if (this.getSourceViewer() instanceof ITextViewerExtension5) {
                offset = ((ITextViewerExtension5)this.getSourceViewer()).widgetOffset2ModelOffset(offset);
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        if ((fs = this.getFileContext()) != null) {
            IFileLanguageService ls;
            LexemeList list = fs.getLexemeList();
            if (list == null) {
                return;
            }
            int index = list.getLexemeFloorIndex(offset);
            if (index == -1 && (index = list.getLexemeCeilingIndex(offset)) == -1) {
                return;
            }
            Lexeme l = list.get(index);
            if (l != null && (ls = fs.getLanguageService(l.getLanguage())) != null && ls.getOffsetMapper() != null) {
                ls.getOffsetMapper().calculateCurrentLexeme(offset);
            }
        }
        super.handleCursorPositionChanged();
    }

    public IEditorPart getEditor() {
        return this;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"com.aptana.ide.editors.UnifiedEditorsScope"});
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSaveComplete() {
        ISaveEvent[] listeners = null;
        ArrayList<ISaveEvent> arrayList = this._saveListeners;
        synchronized (arrayList) {
            listeners = this._saveListeners.toArray(new ISaveEvent[this._saveListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            ISaveEvent element = listeners[i];
            element.onSave(this.getEditor());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSaveAsComplete(File oldFile, File newFile) {
        ISaveAsEvent[] listeners = null;
        ArrayList<ISaveAsEvent> arrayList = this._saveAsListeners;
        synchronized (arrayList) {
            listeners = this._saveAsListeners.toArray(new ISaveAsEvent[this._saveAsListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            ISaveAsEvent element = listeners[i];
            element.onSaveAs(this.getEditor(), oldFile, newFile);
            ++i;
        }
        this.updateFileExplorer();
    }

    private void updateFileExplorer() {
        if (this._fileExplorerView == null) {
            this._fileExplorerView = (IRefreshableView)CoreUIUtils.getViewInternal((String)"com.aptana.ide.js.ui.views.FileExplorerView", null);
        }
        if (this._fileExplorerView == null) {
            return;
        }
        final IRefreshableView view = this._fileExplorerView;
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                view.refresh();
            }
        });
    }

    public void addSaveListener(ISaveEvent listener) {
        this._saveListeners.add(listener);
    }

    public void removeSaveListener(ISaveEvent listener) {
        if (this._saveListeners.contains(listener)) {
            this._saveListeners.remove(listener);
        }
    }

    public void addSaveAsListener(ISaveAsEvent listener) {
        this._saveAsListeners.add(listener);
    }

    public void removeSaveAsListener(ISaveAsEvent listener) {
        if (this._saveAsListeners.contains(listener)) {
            this._saveAsListeners.remove(listener);
        }
    }

    void showPairError() {
        MessageDialog.openInformation(null, (String)Messages.UnifiedEditor_MatchingPairError, (String)Messages.UnifiedEditor_MatchingPairErrorMessage);
    }

    public boolean isHasKeyBeenPressed() {
        return this._hasKeyBeenPressed;
    }

    public void setHasKeyBeenPressed(boolean hasKeyBeenPressed) {
        this._hasKeyBeenPressed = hasKeyBeenPressed;
    }

    protected void createActions() {
        super.createActions();
        final BookmarkRulerAction bra = new BookmarkRulerAction();
        Action bookmarkAction = new Action(){

            public void run() {
                bra.run((IAction)this);
            }
        };
        bra.setActiveEditor((IAction)bookmarkAction, (IEditorPart)this);
        this.setAction(ADD_BOOKMARK, (IAction)bookmarkAction);
        final TaskRulerAction tra = new TaskRulerAction();
        Action taskAction = new Action(){

            public void run() {
                tra.run((IAction)this);
            }
        };
        tra.setActiveEditor((IAction)taskAction, (IEditorPart)this);
        this.setAction(ADD_TASK, (IAction)taskAction);
        ContentAssistAction action = new ContentAssistAction(UnifiedMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId(id);
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        TextOperationAction actionContext = new TextOperationAction(UnifiedMessages.getResourceBundle(), "ContentAssistContextInformation.", (ITextEditor)this, 14);
        actionContext.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)actionContext);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        FoldingExtensionPointLoader.createFoldingActions(this);
        action = new FindReplaceAction(UnifiedMessages.getResourceBundle(), "EditorFindReplace.", (IWorkbenchPart)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setAction(ITextEditorActionConstants.FIND, (IAction)action);
        action.setId(FIND_REPLACE);
        this.markAsContentDependentAction(FIND_REPLACE, true);
        this.setAction(FIND_REPLACE, (IAction)action);
        action = new FindNextAction(UnifiedMessages.getResourceBundle(), "EditorFindNext.", (IWorkbenchPart)this, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.findNext");
        this.setAction("FindNext", (IAction)action);
        action.setId(FIND_NEXT);
        this.markAsContentDependentAction(FIND_NEXT, true);
        this.setAction(FIND_NEXT, (IAction)action);
        action = new FindNextAction(UnifiedMessages.getResourceBundle(), "EditorFindPrevious.", (IWorkbenchPart)this, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
        this.setAction("FindPrevious", (IAction)action);
        action.setId(FIND_PREVIOUS);
        this.markAsContentDependentAction(FIND_PREVIOUS, true);
        this.setAction(FIND_PREVIOUS, (IAction)action);
        this._formatAction = new CodeFormatAction();
    }

    public IUnifiedEditorContributor getBaseContributor() {
        return this._baseContributor;
    }

    protected boolean isNewInput(IEditorInput input) {
        return true;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        int offset = -1;
        Point selectionRange = sourceViewer.getSelectedRange();
        if (selectionRange.x > -1 && selectionRange.y > 0) {
            offset = selectionRange.x;
        }
        if (offset < 0) {
            if (sourceViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
                offset = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
            } else {
                offset = sourceViewer.getVisibleRegion().getOffset();
                offset += styledText.getCaretOffset();
            }
        }
        if (offset < 0) {
            return;
        }
        LexemeList lexemeList = this.getLexemeList();
        if (lexemeList == null) {
            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedEditor_LexemeListIsNull);
            return;
        }
        Lexeme selectedLexeme = lexemeList.getLexemeFromOffset(offset);
        if (selectedLexeme == null) {
            return;
        }
        if (!this.canMarkOccurrences(selectedLexeme)) {
            return;
        }
        String selectedText = selectedLexeme.getText();
        if (selectedText == null || selectedText.length() == 0) {
            return;
        }
        this.markOccurences(lexemeList, selectedLexeme);
        styledText.redraw();
    }

    protected void markOccurences(LexemeList lexemeList, Lexeme selectedLexeme) {
        String selectedText = selectedLexeme.getText();
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        this.removeOccurrenceAnnotations();
        int i = 0;
        while (i < lexemeList.size()) {
            Lexeme lexeme = lexemeList.get(i);
            if (lexeme != null) {
                if (lexeme.isHighlighted()) {
                    lexeme.setHighlighted(false);
                }
                if (lexeme.length == selectedLexeme.length && selectedText.equals(lexeme.getText())) {
                    lexeme.setHighlighted(true);
                    if (model != null) {
                        Position pos = new Position(lexeme.offset, lexeme.length);
                        Annotation occurence = new Annotation("com.aptana.ide.annotation.occurence", false, lexeme.getText());
                        model.addAnnotation(occurence, pos);
                    }
                }
            }
            ++i;
        }
    }

    protected LexemeList getLexemeList() {
        EditorFileContext fileContext = this.getFileContext();
        if (fileContext == null || fileContext.getFileContext() == null) {
            return null;
        }
        IParseState parseState = fileContext.getParseState();
        if (parseState == null) {
            return null;
        }
        LexemeList lexemeList = parseState.getLexemeList();
        return lexemeList;
    }

    public String getLanguageAtOffset(int offset) {
        LexemeList lexemeList = this.getLexemeList();
        if (lexemeList == null) {
            return null;
        }
        Lexeme lexemeAtOffset = lexemeList.getCeilingLexeme(offset);
        if (lexemeAtOffset == null) {
            return null;
        }
        return lexemeAtOffset.getLanguage();
    }

    /*
     * Unable to fully structure code
     */
    private void removeOccurrenceAnnotations() {
        if (this.getDocumentProvider() == null) {
            return;
        }
        model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return;
        }
        iter = model.getAnnotationIterator();
        if (iter != null) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            annotation = (Annotation)iter.next();
            if (!"com.aptana.ide.annotation.occurence".equals(annotation.getType())) continue;
            model.removeAnnotation(annotation);
lbl12:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl13:
        // 1 sources

    }

    public void removeMarkedOccurrences() {
        this.removeOccurrenceAnnotations();
        LexemeList lexemeList = this.getLexemeList();
        if (lexemeList == null) {
            return;
        }
        int i = 0;
        while (i < lexemeList.size()) {
            Lexeme lexeme = lexemeList.get(i);
            if (lexeme != null && lexeme.isHighlighted()) {
                lexeme.setHighlighted(false);
            }
            ++i;
        }
    }

    public boolean canMarkOccurrences(Lexeme lexeme) {
        if (lexeme.getCategoryIndex() == 1) {
            return false;
        }
        return lexeme.getCategoryIndex() != 4;
    }

    public abstract IDocumentProvider createDocumentProvider();

    public boolean autoActivateCodeAssist() {
        return this.autoActivateCodeAssist;
    }

    class PairMatcher
    implements SelectionListener,
    MouseListener,
    KeyListener,
    PaintListener,
    TraverseListener {
        private PairMatch _currentPair;

        PairMatcher() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.stateChanged();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            this.stateChanged();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void paintControl(PaintEvent e) {
            this.stateChanged();
            this.pairsDraw(e.gc, this._currentPair);
        }

        public void keyTraversed(TraverseEvent e) {
            this.stateChanged();
        }

        public void widgetSelected(SelectionEvent e) {
            this.stateChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        void stateChanged() {
            StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
            if (text != null) {
                PairMatch newmatch;
                int resolved;
                int offset = text.getCaretOffset();
                if (UnifiedEditor.this.getViewer() instanceof ITextViewerExtension5 && (resolved = ((ITextViewerExtension5)UnifiedEditor.this.getViewer()).widgetOffset2ModelOffset(offset)) > -1) {
                    offset = resolved;
                }
                if ((newmatch = UnifiedEditor.this.getPairMatch(offset)) == null && this._currentPair != null || newmatch != null && !newmatch.equals(this._currentPair)) {
                    this.pairsDraw(null, this._currentPair);
                    this.pairsDraw(null, newmatch);
                }
                this._currentPair = newmatch;
            }
        }

        void pairsDraw(GC gc, PairMatch pm) {
            List<PairMatch> subsequentMatches;
            if (pm == null) {
                return;
            }
            this.pairsDrawSingle(gc, pm);
            if (pm instanceof IPairMatchExt && (subsequentMatches = ((IPairMatchExt)((Object)pm)).getSubsequentMatches()) != null && subsequentMatches.size() > 0) {
                for (PairMatch subsequentMatch : subsequentMatches) {
                    this.pairsDrawSingle(gc, subsequentMatch);
                }
            }
        }

        void pairsDrawSingle(GC gc, PairMatch pm) {
            if (pm == null) {
                return;
            }
            StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
            if (text != null) {
                int cursor = text.getCaretOffset();
                if (pm.displayOnlyMatch() && gc != null) {
                    if (cursor >= pm.beginStart && cursor <= pm.beginEnd) {
                        this.pairDraw(gc, pm.endStart, pm.endEnd, pm.getColor());
                    } else if (cursor >= pm.endStart && cursor <= pm.endEnd) {
                        this.pairDraw(gc, pm.beginStart, pm.beginEnd, pm.getColor());
                    }
                } else {
                    this.pairDraw(gc, pm.beginStart, pm.beginEnd, pm.getColor());
                    this.pairDraw(gc, pm.endStart, pm.endEnd, pm.getColor());
                }
            }
        }

        void pairDraw(GC gc, int start, int end, Color color) {
            StyledText text = UnifiedEditor.this.getViewer().getTextWidget();
            if (UnifiedEditor.this.getViewer() instanceof ITextViewerExtension5) {
                ITextViewerExtension5 v5 = (ITextViewerExtension5)UnifiedEditor.this.getViewer();
                start = v5.modelOffset2WidgetOffset(start);
                end = v5.modelOffset2WidgetOffset(end);
            }
            if (start < 0 || end < 0 || start > text.getCharCount() || end > text.getCharCount()) {
                return;
            }
            if (gc != null) {
                try {
                    Point left = text.getLocationAtOffset(start);
                    Point right = text.getLocationAtOffset(end);
                    gc.setForeground(color);
                    gc.setLineWidth(1);
                    gc.drawRectangle(left.x + 1, left.y + 1, right.x - left.x - 2, gc.getFontMetrics().getHeight() - 2);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.UnifiedEditor_PairDraw, (String)e.getMessage()));
                }
            } else {
                text.redrawRange(start, end - start, true);
            }
        }
    }
}

