/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.formatting.UnifiedBracketInserterBase;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IPreferenceClient;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.editors.unified.UnifiedViewer;
import com.aptana.ide.lexer.LexemeList;
import java.util.Arrays;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public abstract class UnifiedAutoIndentStrategy
implements IAutoEditStrategy,
IPreferenceClient {
    protected SourceViewerConfiguration configuration;
    protected ISourceViewer sourceViewer;
    protected EditorFileContext context;
    private String spaces = "                                                                            ";

    public UnifiedAutoIndentStrategy(EditorFileContext context, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        this.context = context;
        this.configuration = configuration;
        this.sourceViewer = sourceViewer;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        char current;
        if (command.text == null || command.length > 0) {
            return;
        }
        String[] lineDelimiters = document.getLegalLineDelimiters();
        int index = TextUtilities.endsWith((String[])lineDelimiters, (String)command.text);
        if (index > -1) {
            if (lineDelimiters[index].equals(command.text)) {
                this.indentAfterNewLine(document, command);
            }
            return;
        }
        if (command.text.equals("\t")) {
            UnifiedConfiguration uc;
            if (this.configuration instanceof UnifiedConfiguration && (uc = (UnifiedConfiguration)this.configuration).useSpacesAsTabs()) {
                command.text = uc.getTabAsSpaces();
            }
        } else if (command.text.length() == 1 && this.isAutoInsertCharacter(command.text.charAt(0)) && this.isAutoInsertEnabled() && this.isValidAutoInsertLocation(document, command) && this.overwriteBracket(current = command.text.charAt(0), document, command, this.getLexemeList())) {
            return;
        }
    }

    private boolean isAutoInsertCharacter(char c) {
        int val = Arrays.binarySearch(this.getAutoInsertCharacters(), c);
        return val >= 0;
    }

    protected char[] getAutoInsertCharacters() {
        return new char[]{'(', '<', '[', '\"', '\'', '{'};
    }

    protected char[] getAutoOverwriteCharacters() {
        return new char[]{')', '>', ']', '\"', '\'', '}'};
    }

    protected boolean isAutoInsertEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        String abi = "com.aptana.ide.editor.AUTO_BRACKET_INSERTION";
        return store == null || !store.getString(abi).equals("NONE");
    }

    protected boolean isValidAutoInsertLocation(IDocument d, DocumentCommand c) {
        return true;
    }

    protected void indentAfterNewLine(IDocument d, DocumentCommand c) {
        String indentString = this.getIndentString();
        if (indentString.equals("")) {
            return;
        }
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        c.text = String.valueOf(c.text) + this.getIndentationAtOffset(d, offset);
    }

    public boolean overwriteBracket(char bracket, IDocument document, DocumentCommand command, LexemeList ll) {
        if (this.canOverwriteBracket(bracket, command.offset, document, ll)) {
            command.text = "";
            command.shiftsCaret = false;
            command.caretOffset = command.offset + 1;
            return true;
        }
        return false;
    }

    public boolean canOverwriteBracket(char bracket, int offset, IDocument document, LexemeList ll) {
        if (offset < document.getLength()) {
            char[] autoOverwriteChars = this.getAutoOverwriteCharacters();
            Arrays.sort(autoOverwriteChars);
            if (Arrays.binarySearch(autoOverwriteChars, bracket) < 0) {
                return false;
            }
            try {
                char sibling = document.getChar(offset);
                return sibling == bracket;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }

    public boolean closeBracket(char bracket, IDocument document, DocumentCommand command) {
        if (!this.canCloseBracket(bracket, document)) {
            return false;
        }
        command.text = String.valueOf(Character.toString(bracket)) + Character.toString(UnifiedBracketInserterBase.getPeerCharacter((char)bracket));
        command.shiftsCaret = false;
        command.caretOffset = command.offset + 1;
        return true;
    }

    public boolean canCloseBracket(char bracket, IDocument document) {
        if (!UnifiedBracketInserterBase.hasPeerCharacter((char)bracket)) {
            return false;
        }
        char[] autoInsertChars = this.getAutoInsertCharacters();
        Arrays.sort(autoInsertChars);
        if (Arrays.binarySearch(autoInsertChars, bracket) < 0) {
            return false;
        }
        return !UnifiedBracketInserterBase.isStringBalanced((String)document.get(), (char)bracket, (boolean)true);
    }

    protected String getIndentationAtOffset(IDocument d, int offset) {
        String indentation = "";
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            indentation = this.getIndentationString(d, lineOffset, firstNonWS);
        }
        catch (BadLocationException badLocationException) {}
        return indentation;
    }

    protected String getIndentString() {
        String[] indents = this.configuration.getIndentPrefixes(this.sourceViewer, this.context.getDefaultLanguage());
        boolean hasIndents = indents != null && indents.length != 0;
        String indentString = hasIndents ? indents[0] : "\t";
        return indentString;
    }

    protected String getIndentationString(IDocument d, int lineOffset, int firstNonWS) {
        int indentStringWidth;
        String lineIndent = "";
        try {
            lineIndent = d.get(lineOffset, firstNonWS - lineOffset);
        }
        catch (BadLocationException badLocationException) {}
        if (lineIndent.equals("")) {
            return lineIndent;
        }
        int indentSize = 0;
        int tabWidth = this.configuration.getTabWidth(this.sourceViewer);
        char[] indentChars = lineIndent.toCharArray();
        int i = 0;
        while (i < indentChars.length) {
            char e = indentChars[i];
            indentSize = e == '\t' ? (indentSize += tabWidth - indentSize % tabWidth) : ++indentSize;
            ++i;
        }
        String indentString = this.getIndentString();
        int n = indentStringWidth = indentString.equals("\t") ? tabWidth : indentString.length();
        if (indentStringWidth == 0) {
            return "";
        }
        int indentCount = (int)Math.floor(indentSize / indentStringWidth);
        String indentation = "";
        int i2 = 0;
        while (i2 < indentCount) {
            indentation = String.valueOf(indentation) + indentString;
            ++i2;
        }
        int extra = indentSize % indentStringWidth;
        indentation = String.valueOf(indentation) + this.spaces.substring(0, extra);
        return indentation;
    }

    protected String getIndentForCurrentLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return "";
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer();
            if (end > start) {
                buf.append(d.get(start, end - start));
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    public abstract IPreferenceStore getPreferenceStore();

    protected abstract LexemeList getLexemeList();

    protected boolean indentAfterOpenBrace(IDocument d, DocumentCommand command) {
        int offset = command.offset;
        boolean result = false;
        if (offset != -1 && d.getLength() != 0) {
            String indent = this.getIndentForCurrentLine(d, command);
            String newline = command.text;
            String tab = "\t";
            if (this.configuration instanceof UnifiedConfiguration) {
                UnifiedConfiguration uc = (UnifiedConfiguration)this.configuration;
                tab = uc.getIndent();
            }
            try {
                char c;
                if (command.offset > 0 && (c = d.getChar(command.offset - 1)) == '{') {
                    String startIndent = String.valueOf(newline) + indent + tab;
                    command.text = command.offset < d.getLength() && d.getChar(command.offset) == '}' ? String.valueOf(startIndent) + newline + indent : startIndent;
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + startIndent.length();
                    result = true;
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)Messages.UnifiedAutoIndentStrategy_InvalidOffset, (int)offset), (Throwable)e);
            }
        }
        return result;
    }

    protected void triggerContentAssistPopup() {
        if (this.sourceViewer instanceof SourceViewer) {
            if (!this.autoTriggerAssist()) {
                return;
            }
            ((SourceViewer)this.sourceViewer).doOperation(13);
        }
    }

    protected void hideContentAssistPopup() {
        if (this.sourceViewer instanceof UnifiedViewer) {
            ((UnifiedViewer)this.sourceViewer).closeContentAssist();
        }
    }

    protected void triggerContextAssistPopup() {
        if (this.sourceViewer instanceof SourceViewer) {
            if (!this.autoTriggerAssist()) {
                return;
            }
            ((SourceViewer)this.sourceViewer).doOperation(14);
        }
    }

    protected boolean autoTriggerAssist() {
        return this.getPreferenceStore() != null && this.getPreferenceStore().getBoolean("com.aptana.ide.editors.CODE_ASSIST_AUTO_ACTIVATION");
    }
}

