/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.editors.unified.utils.IUpdaterThreadUpdateable;
import com.aptana.ide.editors.unified.utils.UpdaterThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IdleFileChangedNotifier
implements IUpdaterThreadUpdateable {
    private static IdleFileChangedNotifier instance;
    protected UpdaterThread updaterThread;
    protected Map<FileService, FileContextContentEvent> events = new HashMap<FileService, FileContextContentEvent>();
    protected List<FileService> sourceList = new ArrayList<FileService>();

    protected IdleFileChangedNotifier() {
        this.init();
    }

    protected void init() {
        this.updaterThread = new UpdaterThread(this, 200, "IdleFileChangedNotifier");
        this.updaterThread.start();
    }

    @Override
    public void onUpdaterThreadUpdate() {
        List<FileContextContentEvent> delayedEvents = this.getEventsList();
        int i = 0;
        while (i < delayedEvents.size()) {
            FileContextContentEvent evt = delayedEvents.get(i);
            if (evt != null) {
                IFileService source = evt.getSource();
                if (source instanceof FileService) {
                    this.fireContentChangedEvent(evt, source);
                } else {
                    throw new IllegalStateException(Messages.IdleFileChangedNotifier_SourceNotFileService);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FileContextContentEvent> getEventsList() {
        ArrayList<FileContextContentEvent> delayedEvents = new ArrayList<FileContextContentEvent>();
        IdleFileChangedNotifier idleFileChangedNotifier = this;
        synchronized (idleFileChangedNotifier) {
            int i = 0;
            while (i < this.sourceList.size()) {
                delayedEvents.add(this.events.get(this.sourceList.get(i)));
                ++i;
            }
            this.events = new HashMap<FileService, FileContextContentEvent>();
            this.sourceList.clear();
        }
        return delayedEvents;
    }

    protected void fireContentChangedEvent(FileContextContentEvent evt, IFileService source) {
        ((FileService)source).fireDelayedContentChangedEvent(evt);
    }

    public synchronized void queueContentChangedEvent(FileService fileService, FileContextContentEvent evt) {
        FileContextContentEvent oldEvent = this.events.get(fileService);
        if (oldEvent == null) {
            this.sourceList.add(fileService);
        }
        this.events.put(fileService, evt);
        this.updaterThread.setDirty();
    }

    public synchronized void removeContentChangedEvent(FileService fileService) {
        if (this.events.containsKey(fileService)) {
            this.events.remove(fileService);
        }
    }

    public static synchronized IdleFileChangedNotifier instance() {
        if (instance == null) {
            instance = new IdleFileChangedNotifier();
        }
        return instance;
    }

    static interface IChangeListener {
        public void onChangeListenerEvent();
    }
}

