/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.StreamUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSourceProvider
implements IFileSourceProvider {
    private File file;
    private long lastModStamp = -1L;
    private int sourceLength;

    public FileSourceProvider(File file) {
        this.file = file;
    }

    public String getSource() throws IOException {
        FileInputStream stream = new FileInputStream(this.file);
        String charSet = null;
        return StreamUtils.readContent((InputStream)stream, charSet);
    }

    public int getSourceLength() {
        long stamp = this.file.lastModified();
        if (stamp != this.lastModStamp) {
            try {
                this.sourceLength = this.getSource().length();
                this.lastModStamp = stamp;
            }
            catch (IOException iOException) {
                this.sourceLength = 0;
            }
        }
        return this.sourceLength;
    }

    public String getSourceURI() {
        return CoreUIUtils.getURI((File)this.file);
    }

    public int getLineOfOffset(int offset) {
        throw new UnsupportedOperationException(Messages.FileSourceProvider_MethodNotAvailable);
    }

    public int getLineOffset(int line) {
        throw new UnsupportedOperationException(Messages.FileSourceProvider_MethodNotAvailable);
    }
}

