/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.ContributedOutline;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DefaultBrowser
extends ContributedBrowser {
    private Browser browser;
    private ContributedOutline outline;
    private ProgressListener listener;
    private String url;

    public void createControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listener = new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                DefaultBrowser.this.progressCompleted(event);
            }
        };
        this.browser.addProgressListener(this.listener);
    }

    private String addCacheBuster(String baseURL) {
        String bustedURL = null;
        if (UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.CACHE_BUST_BROWSERS")) {
            if (baseURL != null) {
                String buster = "APTANA_NOCACHE_" + System.currentTimeMillis() + "=" + System.currentTimeMillis();
                bustedURL = baseURL.indexOf(63) == -1 ? String.valueOf(baseURL) + "?" + buster : String.valueOf(baseURL) + "&" + buster;
            }
        } else {
            bustedURL = baseURL;
        }
        return bustedURL;
    }

    public void setURL(String url) {
        this.url = url;
        if (!"about:blank".equals(url)) {
            this.browser.setUrl(this.addCacheBuster(url));
        } else {
            this.browser.setUrl(url);
        }
        if (this.outline != null) {
            this.outline.refresh();
        }
    }

    public Control getControl() {
        return this.browser;
    }

    public void addLocationListener(LocationListener listener) {
        if (this.browser != null) {
            this.browser.addLocationListener(listener);
        }
    }

    public void removeLocationLister(LocationListener listener) {
        if (this.browser != null) {
            this.browser.removeLocationListener(listener);
        }
    }

    public Object getUnderlyingBrowserObject() {
        return this.browser;
    }

    public void refresh() {
        if (this.browser != null && !this.browser.isDisposed() && this.url != null) {
            this.browser.setUrl(this.addCacheBuster(this.url));
        }
    }

    public void dispose() {
        this.browser.dispose();
    }

    public void setOutline(ContributedOutline outline) {
        this.outline = outline;
    }

    public void back() {
        this.browser.back();
    }

    public void forward() {
        this.browser.forward();
    }

    public boolean execute(String script) {
        return this.browser.execute(script);
    }

    public void displaySource() {
    }
}

