/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.unified.ChildOffsetMapper;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.help.HelpResource;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;

public class BaseFileLanguageService
implements IFileLanguageService {
    protected FileService fileService;
    private IParseState parseState;
    private IParser parser;
    private IOffsetMapper offsetMapper;

    public BaseFileLanguageService(FileService fileService, IParseState parseState, IParser parser, IParentOffsetMapper mapper) {
        this.fileService = fileService;
        this.parseState = parseState;
        this.parser = parser;
    }

    public IParseState getParseState() {
        return this.parseState;
    }

    public IParseState getParseState(String language) {
        return this.parseState.getParseState(language);
    }

    public IParser getParser() {
        return this.parser;
    }

    public IFileService getFileContext() {
        return this.fileService;
    }

    public IOffsetMapper getOffsetMapper() {
        return this.offsetMapper;
    }

    public void createOffsetMapper(IParentOffsetMapper parent) {
        this.offsetMapper = new ChildOffsetMapper(parent);
    }

    public String getDocumentationFromLexeme(Lexeme lexeme) {
        return "";
    }

    public String getDocumentationTitleFromLexeme(Lexeme lexeme) {
        return lexeme.getText();
    }

    public HelpResource[] getDocumentationResourcesFromLexeme(Lexeme lexeme) {
        return new HelpResource[0];
    }

    public Lexeme getValidDocumentationLexeme(Lexeme lexeme) {
        return lexeme;
    }

    public void activateForEditing() {
    }

    public void deactivateForEditing() {
    }

    public void connectSourceProvider(IFileSourceProvider sourceProvider) {
    }

    public void disconnectSourceProvider(IFileSourceProvider sourceProvider) {
        if (this.offsetMapper != null) {
            this.offsetMapper.dispose();
        }
        if (this.parseState != null) {
            this.parseState.reset();
        }
        this.offsetMapper = null;
        this.parseState = null;
        this.parser = null;
        this.fileService.setPartitions(null);
        this.fileService = null;
        this.reset(false);
    }

    public void reconnectToEnvironment() {
        IParseState ps = this.getParseState();
        if (ps.getFileIndex() == -1) {
            ps.setFileIndex(Integer.MAX_VALUE);
        }
    }

    public void reset(boolean resetFileIndex) {
    }
}

