/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.BaseFileEditorInput;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;

public class BaseDocumentProvider
extends TextFileDocumentProvider {
    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(Object element, final IDocument document, boolean overwrite) throws CoreException {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info != null) {
            return super.createSaveOperation(element, document, overwrite);
        }
        if (element instanceof BaseFileEditorInput) {
            final BaseFileEditorInput editorInput = (BaseFileEditorInput)element;
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    String charset = ResourcesPlugin.getEncoding();
                    try {
                        Charset cs = Charset.forName(charset);
                        CharsetEncoder encoder = cs.newEncoder();
                        encoder.onMalformedInput(CodingErrorAction.REPLACE);
                        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                        encoder.encode(CharBuffer.wrap(document.get()));
                    }
                    catch (UnmappableCharacterException ex) {
                        Status status = new Status(4, "com.aptana.ide.editors", 0, "The file could not be saved with the following encoding: " + charset + "\nGo to Window->Preferences...->General->Workspace to change the default file encoding.", (Throwable)ex);
                        throw new CoreException((IStatus)status);
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.BaseDocumentProvider_Error, (Throwable)e);
                    }
                    IPath fullPath = editorInput.getPath();
                    File f = fullPath.toFile();
                    FileOutputStream out = null;
                    OutputStreamWriter osw = null;
                    try {
                        try {
                            out = new FileOutputStream(f);
                            osw = new OutputStreamWriter((OutputStream)out, charset);
                            osw.write(document.get());
                        }
                        catch (FileNotFoundException e) {
                            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.BaseDocumentProvider_Error, (Throwable)e);
                        }
                        catch (UnsupportedEncodingException e) {
                            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.BaseDocumentProvider_Error, (Throwable)e);
                        }
                        catch (IOException e) {
                            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.BaseDocumentProvider_Error, (Throwable)e);
                        }
                    }
                    finally {
                        if (osw != null) {
                            try {
                                osw.close();
                            }
                            catch (IOException e) {
                                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.BaseDocumentProvider_Error, (Throwable)e);
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.BaseDocumentProvider_Error, (Throwable)e);
                            }
                        }
                    }
                }
            };
        }
        return super.createSaveOperation(element, document, overwrite);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (info == null && element instanceof IStorageEditorInput && element instanceof IPathEditorInput) {
            try {
                IPath path = ((IPathEditorInput)element).getPath();
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                manager.connect(path, this.getProgressMonitor());
                ITextFileBuffer fileBuffer = manager.getTextFileBuffer(path);
                fileBuffer.requestSynchronizationContext();
                info = this.createEmptyFileInfo();
                info.fTextFileBuffer = fileBuffer;
                info.fCachedReadOnlyState = true;
                path.toFile().setReadOnly();
                IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
                if (file != null) {
                    info.fModel = this.createAnnotationModel(file);
                }
            }
            catch (Exception exception) {
                info = null;
            }
        }
        return info;
    }

    public boolean canSaveDocument(Object element) {
        if (element instanceof NonExistingFileEditorInput) {
            return true;
        }
        return super.canSaveDocument(element);
    }
}

