/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.preferences;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.Messages;
import com.aptana.ide.editors.unified.folding.FoldingExtensionPointLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class FoldingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite displayArea;
    private Group foldingGroup;
    private Button enableFolding;
    private List foldingFields = new ArrayList();

    protected Control createContents(Composite parent) {
        String pref = FoldingExtensionPointLoader.createEnablePreferenceId(this.getLanguage());
        IPreferenceStore storeToInitialize = this.storeToInitialize();
        if (storeToInitialize != null) {
            storeToInitialize.getBoolean(pref);
        }
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.foldingGroup = new Group(this.displayArea, 0);
        this.foldingGroup.setLayout((Layout)new GridLayout(1, true));
        this.foldingGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.foldingGroup.setText(Messages.FoldingPreferencePage_FoldingOptions);
        this.enableFolding = new Button((Composite)this.foldingGroup, 32);
        this.enableFolding.setText(Messages.FoldingPreferencePage_EnableFolding);
        this.enableFolding.setData((Object)pref);
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        this.enableFolding.setSelection(store.getBoolean(pref));
        this.enableFolding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < FoldingPreferencePage.this.foldingFields.size()) {
                    Object obj = FoldingPreferencePage.this.foldingFields.get(i);
                    if (obj instanceof Button) {
                        Button button = (Button)obj;
                        button.setEnabled(FoldingPreferencePage.this.enableFolding.getSelection());
                    }
                    ++i;
                }
            }
        });
        this.addInitialFoldingFields();
        return this.displayArea;
    }

    protected void performDefaults() {
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        String enable = (String)this.enableFolding.getData();
        this.enableFolding.setSelection(store.getDefaultBoolean(enable));
        int i = 0;
        while (i < this.foldingFields.size()) {
            Button button;
            Object obj2;
            Object obj = this.foldingFields.get(i);
            if (obj instanceof Button && (obj2 = (button = (Button)obj).getData()) instanceof String) {
                String data = (String)obj2;
                button.setEnabled(store.getDefaultBoolean(enable));
                button.setSelection(store.getDefaultBoolean(data));
            }
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        String enable = (String)this.enableFolding.getData();
        store.setValue(enable, this.enableFolding.getSelection());
        int i = 0;
        while (i < this.foldingFields.size()) {
            Button button;
            Object obj2;
            Object obj = this.foldingFields.get(i);
            if (obj instanceof Button && (obj2 = (button = (Button)obj).getData()) instanceof String) {
                String data = (String)obj2;
                store.setValue(data, button.getSelection());
            }
            ++i;
        }
        return super.performOk();
    }

    public abstract String getLanguage();

    public abstract IPreferenceStore storeToInitialize();

    public abstract void addInitialFoldingFields();

    public void init(IWorkbench workbench) {
    }

    protected void addInitialFoldingField(String language, String name, String label) {
        String prefId = FoldingExtensionPointLoader.createInitialFoldingPreferenceId(language, name);
        Button foldField = new Button((Composite)this.foldingGroup, 32);
        foldField.setText(label);
        foldField.setData((Object)prefId);
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        foldField.setSelection(store.getBoolean(prefId));
        foldField.setEnabled(this.enableFolding.getSelection());
        this.foldingFields.add(foldField);
    }
}

