/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.EditorPreferencePage;
import com.aptana.ide.editors.preferences.PreferenceMastHead;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class CoreEditorPreferencePage
extends EditorPreferencePage {
    protected Composite editorArea;
    private Cursor hand;
    private Cursor arrow;
    private Composite associations;
    private Composite parentVisible;
    private PreferenceMastHead header;

    protected CoreEditorPreferencePage(int style) {
        super(style);
    }

    protected ImageDescriptor getEditorImage() {
        return UnifiedEditorsPlugin.getImageDescriptor("images/blank_file.png");
    }

    protected abstract String getEditorId();

    protected abstract String getEditorDescription();

    public void createEditorDescriptorArea() {
        this.editorArea = new Composite(this.getFieldEditorParent(), 0);
        this.hand = new Cursor((Device)this.getShell().getDisplay(), 21);
        this.arrow = new Cursor((Device)this.getShell().getDisplay(), 0);
        GridLayout rootLayout = new GridLayout(1, true);
        rootLayout.marginHeight = 0;
        rootLayout.marginWidth = 0;
        this.editorArea.setLayout((Layout)rootLayout);
        this.editorArea.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
        GridData gdArea = new GridData(4, 4, true, false);
        gdArea.horizontalSpan = 2;
        this.editorArea.setLayoutData((Object)gdArea);
        ImageDescriptor desc = this.getEditorImage();
        String editorDesc = this.getEditorDescription();
        this.header = new PreferenceMastHead(this.editorArea, editorDesc, 3, desc);
        final Composite top = this.header.getControl();
        Composite parent = top.getParent();
        int parents = 0;
        while (parent != null && parents <= 3) {
            parent = parent.getParent();
            ++parents;
        }
        if (parent != null) {
            this.parentVisible = parent;
        }
        top.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (top.isVisible() && CoreEditorPreferencePage.this.parentVisible != null) {
                    GC gc = new GC((Drawable)CoreEditorPreferencePage.this.parentVisible);
                    gc.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
                    gc.fillRectangle(((CoreEditorPreferencePage)CoreEditorPreferencePage.this).associations.getLocation().x, ((CoreEditorPreferencePage)CoreEditorPreferencePage.this).associations.getLocation().y, ((CoreEditorPreferencePage)CoreEditorPreferencePage.this).parentVisible.getSize().x, ((CoreEditorPreferencePage)CoreEditorPreferencePage.this).associations.getSize().y + 5);
                    gc.dispose();
                }
            }
        });
        this.associations = new Composite(this.editorArea, 0);
        this.associations.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
        GridLayout assLayout = new GridLayout(2, false);
        assLayout.marginBottom = 5;
        assLayout.marginHeight = 0;
        this.associations.setLayout((Layout)assLayout);
        this.associations.setLayoutData((Object)new GridData(4, 4, true, false));
        String id = this.getEditorId();
        StyledText text = new StyledText(this.associations, 4);
        String base = "File Associations:";
        String fileString = "";
        text.setEditable(false);
        text.setText(fileString);
        text.setCursor(this.arrow);
        text.setForeground(PreferenceMastHead.FOOTER_FG_COLOR);
        text.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
        Composite pencil = new Composite(this.associations, 0);
        pencil.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((IWorkbenchPreferenceContainer)CoreEditorPreferencePage.this.getContainer()).openPage("org.eclipse.ui.preferencePages.FileEditors", null);
            }
        });
        pencil.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
        GridLayout pencilLayout = new GridLayout(1, true);
        pencilLayout.marginWidth = 0;
        pencilLayout.marginHeight = 0;
        pencil.setLayout((Layout)pencilLayout);
        pencil.setCursor(this.hand);
        GridData gdp = new GridData(4, 4, false, false);
        pencil.setLayoutData((Object)gdp);
        StyledText link = new StyledText(pencil, 0);
        link.setCursor(this.hand);
        link.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
        link.setText("[edit]");
        link.setEditable(false);
        Color linkBlue = UnifiedColorManager.getInstance().getColor(new RGB(200, 200, 255));
        StyleRange lbraceRange = new StyleRange(0, 1, linkBlue, null);
        StyleRange editRange = new StyleRange(1, 4, linkBlue, null);
        editRange.underline = true;
        StyleRange rbraceRange = new StyleRange(5, 1, linkBlue, null);
        link.setStyleRange(lbraceRange);
        link.setStyleRange(editRange);
        link.setStyleRange(rbraceRange);
        link.setToolTipText("Edit the file associations");
        GridData editData = new GridData(4, 4, false, false);
        link.setLayoutData((Object)editData);
        link.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((IWorkbenchPreferenceContainer)CoreEditorPreferencePage.this.getContainer()).openPage("org.eclipse.ui.preferencePages.FileEditors", null);
            }
        });
        if (id != null) {
            String[] fileAssociations = this.getFileAssociations(id);
            fileString = StringUtils.join((String)", ", (String[])fileAssociations);
            text.setText(String.valueOf(base) + " " + fileString);
            StyleRange range = new StyleRange(0, base.length(), PreferenceMastHead.FOOTER_FG_COLOR, null);
            range.fontStyle = 1;
            text.setStyleRange(range);
            range = new StyleRange(base.length(), fileString.length(), PreferenceMastHead.FOOTER_FG_COLOR, null);
            text.setStyleRange(range);
        }
    }

    protected String[] getFileAssociations(String id) {
        IEditorRegistry registry = WorkbenchPlugin.getDefault().getEditorRegistry();
        IFileEditorMapping[] array = registry.getFileEditorMappings();
        ArrayList<String> associations = new ArrayList<String>();
        int i = 0;
        while (i < array.length) {
            IFileEditorMapping mapping = array[i];
            if (mapping.getDefaultEditor() != null && mapping.getDefaultEditor().getId().equals(id)) {
                associations.add(mapping.getLabel());
            }
            ++i;
        }
        return associations.toArray(new String[associations.size()]);
    }

    public void createFieldEditors() {
        this.createEditorDescriptorArea();
        super.createFieldEditors();
    }

    public void dispose() {
        super.dispose();
        if (this.hand != null && !this.hand.isDisposed()) {
            this.hand.dispose();
        }
        if (this.arrow != null && !this.arrow.isDisposed()) {
            this.arrow.dispose();
        }
    }

    public void setVisible(boolean visible) {
        if (this.header != null) {
            this.header.setVisible(visible);
        }
        super.setVisible(visible);
    }
}

