/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.actions;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.actions.Messages;
import com.aptana.ide.editors.actions.UnifiedEditorAction;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.utils.EditorHelper;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.IOffsetMapper;
import java.io.File;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;

public class OpenDeclarationAction
extends UnifiedEditorAction {
    public static final String ACTION_ID = String.valueOf(UnifiedEditorsPlugin.getDefault().getBundle().getSymbolicName()) + ".openDeclarationAction";

    public OpenDeclarationAction() {
        super(ACTION_ID, Messages.OpenDeclarationAction_OpenDeclaration);
    }

    public void run() {
        IFileLanguageService fileService = this.getFileService();
        ISourceViewer viewer = this.getActiveEditor().getViewer();
        int offset = viewer.getTextWidget().getCaretOffset();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 v5 = (ITextViewerExtension5)viewer;
            offset = v5.widgetOffset2ModelOffset(offset);
        }
        if (offset == -1) {
            return;
        }
        IOffsetMapper mapper = fileService.getOffsetMapper();
        int lxOffset = mapper.getLexemeIndexFromDocumentOffset(offset);
        if (lxOffset == -1) {
            return;
        }
        Lexeme lx = mapper.getLexemeAtIndex(lxOffset);
        if (lx == null) {
            return;
        }
        String mimetype = lx.getLanguage();
        IFileLanguageService langService = fileService.getFileContext().getLanguageService(mimetype);
        if (langService == null) {
            return;
        }
        IOffsetMapper langMapper = langService.getOffsetMapper();
        if (langMapper == null) {
            return;
        }
        CodeLocation loc = (CodeLocation)langMapper.findTarget(lx);
        if (loc != null) {
            this.openInEditor(CoreUIUtils.getPathFromURI((String)loc.getFullPath()), loc.getStartLexeme());
        }
    }

    private void openInEditor(String fileName, Lexeme lexeme) {
        IEditorPart part = EditorHelper.openInEditor(new File(fileName));
        if (part instanceof IUnifiedEditor && lexeme != null) {
            IUnifiedEditor jsEditor = (IUnifiedEditor)part;
            jsEditor.selectAndReveal(lexeme.offset, lexeme.getEndingOffset() - lexeme.offset);
        }
    }
}

