/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.DocumentCharSequence;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor {
    private final TextSearchRequestor fCollector;
    private final Matcher fMatcher;
    private Map fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private final MultiStatus fStatus;
    private final FileCharSequenceProvider fFileCharSequenceProvider;
    private final ReusableMatchAccess fMatchAccess;
    private final boolean openEditorsOnly;
    private boolean refresh;

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern, boolean openEditorsOnly, boolean refresh) {
        this.fCollector = collector;
        this.refresh = refresh;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher(new String());
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
        this.fMatchAccess = new ReusableMatchAccess();
        this.openEditorsOnly = openEditorsOnly;
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = TextSearchVisitor.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, new Integer(TextSearchVisitor.this.fNumberOfScannedFiles), new Integer(TextSearchVisitor.this.fNumberOfFilesToScan)};
                        TextSearchVisitor.this.fProgressMonitor.subTask(Messages.format((String)SearchMessages.TextSearchVisitor_scanning, (Object[])args));
                        int steps = TextSearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        TextSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            MultiStatus multiStatus;
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : Messages.format((String)SearchMessages.TextSearchVisitor_textsearch_task_label, (Object)this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processFiles(files);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        IFile[] files = null;
        if (this.openEditorsOnly) {
            ArrayList<IFile> filesList = new ArrayList<IFile>();
            IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchPage[] pages = windows[i].getPages();
                int x = 0;
                while (x < pages.length) {
                    IEditorReference[] editorRefs = pages[x].getEditorReferences();
                    int z = 0;
                    while (z < editorRefs.length) {
                        IEditorInput editorInput;
                        IEditorPart ep = editorRefs[z].getEditor(false);
                        if (ep instanceof ITextEditor && (editorInput = ep.getEditorInput()) instanceof IFileEditorInput) {
                            IFileEditorInput ed = (IFileEditorInput)editorInput;
                            filesList.add(ed.getFile());
                        }
                        ++z;
                    }
                    ++x;
                }
                ++i;
            }
            files = new IFile[filesList.size()];
            filesList.toArray(files);
        } else {
            files = new FilesOfScopeCalculator(scope, this.fStatus).process();
        }
        return this.search(files, monitor);
    }

    public void initDocuments() {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
    }

    private void processFiles(IFile[] files) {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        int i = 0;
        while (i < files.length) {
            this.fCurrentFile = files[i];
            boolean res = this.processFile(this.fCurrentFile);
            if (!res) break;
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    private Map evalNonFileBufferDocuments() {
        HashMap result = new HashMap();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processFile(IFile file) {
        block28: {
            try {
                Document doc;
                CharSequence seq;
                block29: {
                    if (!this.fCollector.acceptFile(file)) return true;
                    if (this.fMatcher == null) {
                        return true;
                    }
                    IDocument document = this.getOpenDocument(file);
                    if (document != null) {
                        DocumentCharSequence documentCharSequence = new DocumentCharSequence(document);
                        this.locateMatches(file, (CharSequence)documentCharSequence, document);
                        break block28;
                    }
                    seq = null;
                    seq = this.fFileCharSequenceProvider.newCharSequence(file);
                    doc = null;
                    if (seq.length() < 1000000) {
                        String string = seq.toString();
                        doc = new Document(string);
                        seq = string;
                    }
                    if (!this.hasBinaryContent(seq, file) || this.fCollector.reportBinaryFile(file)) break block29;
                    if (seq == null) return true;
                    try {
                        this.fFileCharSequenceProvider.releaseCharSequence(seq);
                        return true;
                    }
                    catch (IOException e) {
                        SearchPlugin.log((Throwable)e);
                        return true;
                    }
                }
                try {
                    try {
                        this.locateMatches(file, seq, (IDocument)doc);
                    }
                    catch (FileCharSequenceProvider.FileCharSequenceException e) {
                        e.throwWrappedException();
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (seq != null) {
                        try {
                            this.fFileCharSequenceProvider.releaseCharSequence(seq);
                        }
                        catch (IOException e) {
                            SearchPlugin.log((Throwable)e);
                        }
                    }
                }
            }
            catch (UnsupportedCharsetException e) {
                Object[] args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                String message = Messages.format((String)SearchMessages.TextSearchVisitor_unsupportedcharset, (Object[])args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (IllegalCharsetNameException e) {
                Object[] args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                String message = Messages.format((String)SearchMessages.TextSearchVisitor_illegalcharset, (Object[])args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (IOException e) {
                Object[] args = new String[]{this.getExceptionMessage(e), file.getFullPath().makeRelative().toString()};
                String message = Messages.format((String)SearchMessages.TextSearchVisitor_error, (Object[])args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (CoreException e) {
                Object[] args = new String[]{this.getExceptionMessage((Exception)((Object)e)), file.getFullPath().makeRelative().toString()};
                String message = Messages.format((String)SearchMessages.TextSearchVisitor_error, (Object[])args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (StackOverflowError e) {
                String message = SearchMessages.TextSearchVisitor_patterntoocomplex0;
                this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 4, message, (Throwable)e));
                ++this.fNumberOfScannedFiles;
                return false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (!this.fProgressMonitor.isCanceled()) return true;
        throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = FileCharSequenceProvider.BUFFER_SIZE;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    private void locateMatches(IFile file, CharSequence searchInput, IDocument document) throws CoreException {
        try {
            this.fMatcher.reset(searchInput);
            int k = 0;
            while (this.fMatcher.find()) {
                int start = this.fMatcher.start();
                int end = this.fMatcher.end();
                if (end != start) {
                    this.fMatchAccess.initialize(file, start, end - start, searchInput, document);
                    boolean res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                    if (!res) {
                        return;
                    }
                }
                if (k++ != 20) continue;
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                }
                k = 0;
            }
        }
        finally {
            this.fMatchAccess.initialize(null, 0, 0, new String());
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = (IDocument)this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    public IProgressMonitor getFProgressMonitor() {
        return this.fProgressMonitor;
    }

    public void setFProgressMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private static final int MAX_LINE_LENGTH = 300;
        private int fOffset;
        private int fLength;
        private int lineNumber = -1;
        private IFile fFile;
        private CharSequence fContent;
        private String lineContent;

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getLineContent() {
            return this.lineContent;
        }

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        public void initialize(IFile file, int start, int length, CharSequence content, IDocument document) {
            block7: {
                this.fFile = file;
                this.fOffset = start;
                this.fLength = length;
                this.fContent = content;
                if (document != null) {
                    try {
                        this.lineNumber = document.getLineOfOffset(start);
                        IRegion lineInformation = document.getLineInformation(this.lineNumber);
                        if (lineInformation.getLength() < 300) {
                            this.lineContent = document.get(lineInformation.getOffset(), lineInformation.getLength());
                            break block7;
                        }
                        int ka = start - 100;
                        if (ka < 0) {
                            ka = 0;
                        }
                        int max = Math.min(document.getLength() - 1, ka + 300);
                        this.lineContent = document.get(ka, max);
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    int ka = start - 100;
                    if (ka < 0) {
                        ka = 0;
                    }
                    int max = Math.min(content.length() - 1, ka + 300);
                    this.lineContent = content.subSequence(ka, max).toString();
                }
            }
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }

    public class FilesOfScopeCalculator
    implements IResourceProxyVisitor {
        private final TextSearchScope fScope;
        private final MultiStatus fStatus;
        private ArrayList fFiles;

        public FilesOfScopeCalculator(TextSearchScope scope, MultiStatus status) {
            this.fScope = scope;
            this.fStatus = status;
        }

        public boolean visit(IResourceProxy proxy) {
            boolean inScope = this.fScope.contains(proxy);
            if (inScope && proxy.getType() == 1) {
                this.fFiles.add(proxy.requestResource());
            }
            return inScope;
        }

        public IFile[] process() {
            this.fFiles = new ArrayList();
            try {
                IResource[] roots = this.fScope.getRoots();
                int i = 0;
                while (i < roots.length) {
                    try {
                        IResource resource = roots[i];
                        if (TextSearchVisitor.this.refresh) {
                            resource.refreshLocal(2, null);
                        }
                        if (resource.isAccessible()) {
                            resource.accept((IResourceProxyVisitor)this, 0);
                        }
                    }
                    catch (CoreException ex) {
                        this.fStatus.add(ex.getStatus());
                    }
                    ++i;
                }
                IFile[] iFileArray = this.fFiles.toArray(new IFile[this.fFiles.size()]);
                return iFileArray;
            }
            finally {
                this.fFiles = null;
            }
        }
    }
}

