/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StreamUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.search.epl.Activator;
import com.aptana.ide.search.epl.FileMatch;
import com.aptana.ide.search.epl.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;

public class AptanaFileMatch
extends FileMatch
implements IAdaptable {
    final int lineNumber;
    String lineContent;
    private final File file;

    public AptanaFileMatch(IFile element, int offset, int length, int lineNumber, String lineContent) {
        super(element, offset, length);
        this.lineContent = lineContent != null ? lineContent.trim() : null;
        this.lineNumber = lineNumber;
        this.file = null;
    }

    public AptanaFileMatch(File element, int offset, int length, int lineNumber, String lineContent) {
        super(null, offset, length);
        this.lineContent = lineContent != null ? lineContent.trim() : null;
        this.lineNumber = lineNumber;
        this.file = element;
    }

    public Object getElement() {
        if (this.file != null) {
            return this.file;
        }
        return super.getElement();
    }

    public File getFileElement() {
        return this.file;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLineContent() {
        if (this.lineContent == null) {
            try {
                if (this.getFile() != null) {
                    String readContent = StreamUtils.readContent((InputStream)this.getFile().getContents(), (String)this.getFile().getCharset(true));
                    int from = Math.max(0, this.getOffset() - 40);
                    int to = Math.min(readContent.length(), this.getOffset() + this.getLength() + 30);
                    this.lineContent = readContent.substring(from, to);
                }
            }
            catch (IOException e) {
                this.lineContent = StringUtils.format((String)Messages.AptanaFileMatch_IO_ERROR, (String)e.getMessage());
                IdeLog.logError((Plugin)Activator.getDefault(), (String)this.lineContent);
            }
            catch (CoreException e) {
                this.lineContent = StringUtils.format((String)Messages.AptanaFileMatch_CORE_ERROR, (String)e.getMessage());
                IdeLog.logError((Plugin)Activator.getDefault(), (String)this.lineContent);
            }
        }
        return this.lineContent;
    }

    public Object getAdapter(Class adapter) {
        return this.getFile().getAdapter(adapter);
    }
}

